package com.ejianc.business.zdsmaterial.material.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.material.bean.MatFeeApplyDetailEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MatFeeApplyDetailMapper;
import com.ejianc.business.zdsmaterial.material.service.IMatFeeApplyDetailService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物资费用申请-明细
 * 
 * @author generator
 * 
 */
@Service("matFeeApplyDetailService")
public class MatFeeApplyDetailServiceImpl extends BaseServiceImpl<MatFeeApplyDetailMapper, MatFeeApplyDetailEntity> implements IMatFeeApplyDetailService {

    @Override
    public Map<Long, List<MatFeeApplyDetailEntity>> getAllBySettleIds(List<Long> pIds) {
        Map<Long, List<MatFeeApplyDetailEntity>> resp = new HashMap<>();

        QueryWrapper<MatFeeApplyDetailEntity> query = new QueryWrapper<>();
        query.in("apply_id", pIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<MatFeeApplyDetailEntity> dbList = super.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            resp = dbList.stream().collect(Collectors.groupingBy(MatFeeApplyDetailEntity::getApplyId));
        }

        return resp;
    }
}
