package com.ejianc.business.zdsmaterial.plan.conjecture.service;

import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * 物料识别历史匹配记录实体
 * 
 * @author generator
 * 
 */
public interface IMaterialConjectureService extends IBaseService<MaterialConjectureEntity> {

    /**
     * 物料异步识别
     * @param identificationId
     */
    void startConjecture(String identificationId, String authority, String mode);

    List<MaterialConjectureEntity> getAllByIdentifyId(String identificationId, String mateType,
                                                      String actualCategoryName, String actualMaterialCode,
                                                      String actualMaterialName, String actualMaterialSpec, String actualUnitName, BigDecimal actualNum);
    List<MaterialConjectureEntity> getAllByIdentifyId(String identificationId, String mateType,
                                                             String actualCategoryName, String actualMaterialCode,
                                                             String actualMaterialName, String actualMaterialSpec,
                                                             String actualUnitName, BigDecimal actualNum, String loadState);
    List<MaterialConjectureEntity> getAllByIdentifyId(String identificationId, String mateType,
                                                             String actualCategoryName, String actualMaterialCode,
                                                             String actualMaterialName, String actualMaterialSpec,
                                                             String actualUnitName, BigDecimal actualNum, String loadState, List<Long> categoryIds);

    void fillBillInfo(Set<String> identifyIds, Long billId, String billCode, String billType);

    List<MaterialConjectureVO> getAllByBillId(Long billId);

    void delConjectureByIds(List<Long> detailIds);

    List<MaterialConjectureVO> materialConjecture(List<MaterialConjectureEntity> saveList, String authority);
}
