package com.ejianc.business.zdsmaterial.plan.control.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.material.vo.PurchaseAnalysisVo;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanSumDetailEntity;
import com.ejianc.business.zdsmaterial.plan.control.mapper.ControlPlanSumDetailMapper;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanDetailEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 物资总控计划汇总明细
 * 
 * @author generator
 * 
 */
@Service("controlPlanSumDetailService")
public class ControlPlanSumDetailServiceImpl extends BaseServiceImpl<ControlPlanSumDetailMapper, ControlPlanSumDetailEntity> implements IControlPlanSumDetailService{

    @Autowired
    private ControlPlanSumDetailMapper mapper;

    @Override
    public List<PurchasePlanDetailEntity> queryList(List<Long> materialIds, Long projectId) {
        return mapper.queryMaterialList(materialIds, projectId);
    }
    @Override
    public List<ControlPlanSumDetailEntity> queryListBySum(List<Long> materialIds, Long projectId) {
        return mapper.queryMaterialListBySum(materialIds, projectId);
    }


    @Override
    public List<PurchaseAnalysisVo> getList(Map<String, Object> params) {
        return mapper.getList(params);
    }

    @Override
    public List<PurchaseAnalysisVo> countChangeNum(Map<String, Object> params) {
        return mapper.countChangeNum(params);
    }

    @Override
    public long count(Map<String, Object> params) {
        return mapper.count(params);
    }

    @Override
    public List<JSONObject> querySubByPlanIds(List<Long> planIds, List<Long> projectIds) {
        return mapper.querySubByPlanIds(planIds, projectIds);
    }


}
