package com.ejianc.business.zdsmaterial.plan.purchase.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.bean.GoodsEntity;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.service.IGoodsService;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategorySettingsEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategorySettingsService;
import com.ejianc.business.zdsmaterial.material.vo.ArchivesInforVo;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanEntity;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanSumDetailEntity;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanDetailService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.mapper.PurchasePlanDetailMapper;
import com.ejianc.business.zdsmaterial.plan.purchase.mapper.PurchasePlanMapper;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanService;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanDetailVO;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanVO;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.SupPurchasePlanDetailVO;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.SupPurchasePlanVo;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 采购计划
 * 
 * @author generator
 * 
 */
@Service("purchasePlanService")
public class PurchasePlanServiceImpl extends BaseServiceImpl<PurchasePlanMapper, PurchasePlanEntity> implements IPurchasePlanService {
    private static final String BILL_CODE = "ZDS-PUR-PLAN";//此处需要根据实际修改
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMaterialCategorySettingsService categorySettingsService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IControlPlanSumDetailService sumDetailService;
    @Autowired
    private IPurchasePlanDetailService detailService;
    @Autowired
    private IControlPlanService controlPlanService;
    @Autowired
    private IControlPlanDetailService controlPlanDetailService;
    @Autowired
    private IMaterialCategoryService materialCategoryService;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private PurchasePlanMapper mapper;
    @Autowired
    private PurchasePlanDetailMapper detailMapper;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IGoodsService goodsService;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IOrgApi orgApi;


    @Override
    public void validatePlanNum(PurchasePlanEntity entity) {
        //子表不为空
        if(CollectionUtils.isNotEmpty(entity.getDetailList())) {

            //查询总控计划中的物资
            List<Long> materialIds = controlPlanDetailService.getAllMaterialByProject(entity.getProjectId());

            if(CollectionUtils.isEmpty(materialIds)) {
                return;
            }

            //Map<materialId,requirementNun>  计算物资采购计划量总和
            Map<Long, BigDecimal> detailNumMap = new HashMap<>();
            //Map<materialId, >
            Map<Long, PurchasePlanDetailEntity> materialMap = new HashMap<>();
            //采购计划总量为负 的物资Id
            Set<Long> negativeNumMaterialIds = new HashSet<>();

            entity.getDetailList().stream().filter(item -> !"del".equals(item.getRowState())
                    && materialIds.contains(item.getMaterialId())).forEach(detail -> {
                detailNumMap.put(detail.getMaterialId(), ComputeUtil.safeAdd(detailNumMap.get(detail.getMaterialId()), detail.getRequirementNum()));
                if(BigDecimal.ZERO.compareTo(detail.getRequirementNum()) > 0) {
                    negativeNumMaterialIds.add(detail.getMaterialId());
                }
                materialMap.put(detail.getMaterialId(), detail);
            });

            //查询在途（审批中的计划占用量）
            if(!detailNumMap.isEmpty()) {
                List<PurchasePlanDetailEntity> approvingList = detailService.getAllMaterialByProjectAndMaterialIds(entity.getProjectId(),
                        new ArrayList<>(detailNumMap.keySet()),
                        entity.getId(),
                        Arrays.asList(new Integer[]{BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()}));
                if(CollectionUtils.isNotEmpty(approvingList)) {
                    approvingList.stream().forEach(detail -> {
                        detailNumMap.put(detail.getMaterialId(), ComputeUtil.safeAdd(detailNumMap.get(detail.getMaterialId()), detail.getRequirementNum()));
                    });
                }
            }

          if(CollectionUtils.isNotEmpty(negativeNumMaterialIds)) {
                //查询项目下已生效的计划单 对应当前计划单中物资的总需求里
                List<Map<String, Object>> totalRequiredNumByMaterial = detailMapper.totalRequiredNumByMaterial(new ArrayList<>(negativeNumMaterialIds), entity.getProjectId(), entity.getId());
                Map<Long, BigDecimal> effectNum = new HashMap<>();
                if(CollectionUtils.isNotEmpty(totalRequiredNumByMaterial)) {
                    effectNum.putAll(totalRequiredNumByMaterial.stream()
                            .filter(item -> null != item.get("materialId"))
                            .collect(Collectors.toMap(item -> Long.valueOf(item.get("materialId").toString()),
                            item -> null != item.get("totalNum") ? new BigDecimal(item.get("totalNum").toString()) : BigDecimal.ZERO)));
                }
                PurchasePlanDetailEntity tmpDetail = null;
                BigDecimal totalNum = null;
                for(Long materialId : materialMap.keySet()) {
                    tmpDetail = materialMap.get(materialId);
                    totalNum = ComputeUtil.safeAdd(detailNumMap.get(materialId), effectNum.get(materialId));
                    if(BigDecimal.ZERO.compareTo(totalNum) > 0) {
                        throw new BusinessException("物资【编码："+tmpDetail.getMaterialCode()+"，名称："+tmpDetail.getMaterialName()+"】负数可冲抵量："
                                +(null != effectNum.get(materialId) ? effectNum.get(materialId).setScale(2, BigDecimal.ROUND_HALF_UP).toPlainString()
                                : BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP).toPlainString())
                                +"，已超："+totalNum.negate().setScale(2, BigDecimal.ROUND_HALF_UP).toPlainString()+"，请调整！");
                    }
                }
            }
        }
    }

    @Override
    public PurchasePlanVO saveOrUpdate(PurchasePlanVO saveOrUpdateVO) {
        PurchasePlanEntity entity = BeanMapper.map(saveOrUpdateVO, PurchasePlanEntity.class);
        //查询累计占用量是否大于等于0
        validatePlanNum(entity);

        boolean b = checkUpdateDetailParams(saveOrUpdateVO);
        if (b){
            saveOrUpdateVO.setExcessBpmFlag(1);
            entity.setExcessBpmFlag(1);
        }else{
            saveOrUpdateVO.setExcessBpmFlag(0);
            entity.setExcessBpmFlag(0);
        }
        if(entity.getId() == null || entity.getId() == 0){
            entity.setPushStatus(0);
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            CommonResponse<EmployeeVO> employeeVOCommonResponse = employeeApi.queryEmployeByUserId(InvocationInfoProxy.getUserid());
            if (employeeVOCommonResponse.isSuccess()){
                EmployeeVO data = employeeVOCommonResponse.getData();
                entity.setUserPostName(data.getPostName());
                entity.setUserDepartName(data.getDeptName());
                entity.setUserOrgName(data.getOrgName());
                entity.setCreateUserId(InvocationInfoProxy.getUserid());
                entity.setExcessFlag(0);
            }
        }
        List<PurchasePlanDetailVO> details =  saveOrUpdateVO.getDetailList().stream().filter(x -> !"del".equals(x.getRowState())).collect(Collectors.toList());
        for (PurchasePlanDetailVO vo:details){
            if (vo.getExcessDetailFlag()==1){
                entity.setExcessFlag(1);
                break;
            }
        }

        //处理物资id为空 物资分类编码为空
        entity.getDetailList().stream().filter(item -> null == item.getMaterialId()).forEach(item -> item.setMaterialId(IdWorker.getId()));
        List<PurchasePlanDetailEntity> emptyTypeCodeList = entity.getDetailList().stream().filter(item -> StringUtils.isBlank(item.getMaterialTypeCode())).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(emptyTypeCodeList)) {
            List<Long> materialTypeIds = new ArrayList<>(emptyTypeCodeList.stream().map(PurchasePlanDetailEntity::getMaterialTypeId).collect(Collectors.toSet()));
            if(CollectionUtils.isNotEmpty(materialTypeIds)) {
                Map<Long, String> categoryCodeMap = new HashMap<>();
                List<MaterialCategoryVO> materialCategorys = materialCategoryService.getAllByIds(materialTypeIds);
                categoryCodeMap.putAll(materialCategorys.stream().collect(Collectors.toMap(item -> item.getId(), item -> item.getCode())));

                emptyTypeCodeList.stream().filter(item -> categoryCodeMap.containsKey(item.getMaterialTypeId()))
                        .forEach(item -> item.setMaterialTypeCode(categoryCodeMap.get(item.getMaterialTypeId())));
            }
        }

        List<PurchasePlanDetailEntity> detailList = entity.getDetailList();
        List<Long> collect = detailList.stream().filter(e -> 1 == e.getWorkPlanFlag()&&(null==e.getRowState()||!e.getRowState().equals("del"))).map(e -> e.getMaterialId()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)){
            checkMaterialSumPlan(collect,entity.getProjectId());
        }
        String materialTypeNames = saveOrUpdateVO.getDetailList().stream().filter(x->!"del".equals(x.getRowState()) &&
                StringUtils.isNotEmpty(x.getMaterialTypeName())).map(PurchasePlanDetailVO::getMaterialTypeName).distinct().collect(Collectors.joining(","));
        entity.setMaterialTypeNames(materialTypeNames);
        detailService.setMaterialNo(entity.getDetailList());
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, PurchasePlanVO.class);
    }

    @Override
    public PurchasePlanEntity setSid(PurchasePlanEntity purchasePlanEntity){
        List<Long> ids = new ArrayList<>();
        if (purchasePlanEntity.getCommitUserId()!=null){
            ids.add(purchasePlanEntity.getCommitUserId());//提交人主键
        }
        if (purchasePlanEntity.getProjectManagerId()!=null){
            ids.add(purchasePlanEntity.getProjectManagerId());//项目经理id
        }

        if (purchasePlanEntity.getEngineerId()!=null){
            ids.add(purchasePlanEntity.getEngineerId());//主责工程师id
        }
        if (purchasePlanEntity.getChiefEngineerId()!=null){
            ids.add(purchasePlanEntity.getChiefEngineerId());//项目总工id
        }
        if (purchasePlanEntity.getCreateUserId()!=null){
            ids.add(purchasePlanEntity.getCreateUserId());//编制者id
        }
        if (purchasePlanEntity.getProjectManagerId()!=null){
            ids.add(purchasePlanEntity.getProjectManagerId());//项目经理id
        }
        if (purchasePlanEntity.getPurchaseWorkerId()!=null){
            ids.add(purchasePlanEntity.getPurchaseWorkerId());//采购工程师id
        }
        if (purchasePlanEntity.getApproveUserId()!=null){
            ids.add(purchasePlanEntity.getApproveUserId());//审批人id
        }

        List<Long> collect = ids.stream().distinct().collect(Collectors.toList());
        CommonResponse<List<EmployeeVO>> byIds = employeeApi.getJustByIds(collect);
        System.out.println(byIds);
        if (byIds.isSuccess()){
            List<EmployeeVO> data = byIds.getData();
            if (CollectionUtils.isNotEmpty(data)){
                for (EmployeeVO vo:data){
                    if (vo.getSourceId()!=null){
                        if (purchasePlanEntity.getCreateUserId().equals(vo.getId())){
                            purchasePlanEntity.setCommitUserSid(vo.getSourceId());
                        }
                        if (purchasePlanEntity.getEngineerId().equals(vo.getId())){
                            purchasePlanEntity.setEngineerSid(vo.getSourceId());
                        }
                        if (purchasePlanEntity.getProjectManagerId()!=null&&purchasePlanEntity.getProjectManagerId().equals(vo.getId())){
                            purchasePlanEntity.setProjectManagerSid(vo.getSourceId());
                        }
                        if (purchasePlanEntity.getChiefEngineerId()!=null&&purchasePlanEntity.getChiefEngineerId().equals(vo.getId())){
                            purchasePlanEntity.setChiefEngineerSid(vo.getSourceId());
                        }
                        if (purchasePlanEntity.getCreateUserId().equals(vo.getId())){
                            purchasePlanEntity.setCreateUserSid(vo.getSourceId());
                        }
                        if (purchasePlanEntity.getPurchaseWorkerId().equals(vo.getId())){
                            purchasePlanEntity.setPurchaseWorkerSid(vo.getSourceId());
                        }
                        if (purchasePlanEntity.getApproveUserId().equals(vo.getId())){
                            purchasePlanEntity.setApproveUserSid(vo.getSourceId());
                        }
                    }

                }
            }
        }else {
            throw new BusinessException("网络异常， 人员信息获取失败， 请稍后再试");
        }
        List<Long> collect1 = purchasePlanEntity.getDetailList().stream().map(e -> e.getMaterialTypeId()).distinct().collect(Collectors.toList());
        List<MaterialCategoryVO> materialCategoryVOS = materialCategoryService.queryCategoryListByIds(collect1);
        Map<Long, String> idMap = materialCategoryVOS.stream().filter(e->null!=e.getSourceId()).collect(Collectors.toMap(e -> e.getId(), e -> e.getSourceId()));
        if (idMap != null){
            for (PurchasePlanDetailEntity detail:purchasePlanEntity.getDetailList()){
                if (idMap.containsKey(detail.getMaterialTypeId())){
                    detail.setMaterialTypeSid(idMap.get(detail.getMaterialTypeId()));
                }
            }
        }

        return purchasePlanEntity;
    }

    @Override
    public CommonResponse<PurchasePlanVO> queryDetail(Long id) {
        PurchasePlanEntity entity = super.selectById(id);
//        setSid(entity);
        PurchasePlanVO vo = BeanMapper.map(entity, PurchasePlanVO.class);
        List<PurchasePlanDetailVO> detailList = vo.getDetailList();
        List<PurchasePlanDetailVO> newDetailList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailList)){
            Map<Long, List<PurchasePlanDetailVO>> collect = detailList.stream().collect(Collectors.groupingBy(PurchasePlanDetailVO::getMaterialId));
            Map<Long, PurchasePlanDetailVO> mapCommonResponse = queryMaterialListSum(new ArrayList<>(collect.keySet()),vo.getProjectId());
            if (null!=mapCommonResponse&&mapCommonResponse.size()>0){
                for (Map.Entry<Long, List<PurchasePlanDetailVO>> entry : collect.entrySet()) {
                    if (mapCommonResponse.containsKey(entry.getKey())){
                        List<PurchasePlanDetailVO> value = entry.getValue();
                        for (PurchasePlanDetailVO vo1:value){
                            PurchasePlanDetailVO detailVO = mapCommonResponse.get(entry.getKey());
                            vo1.setNum(detailVO.getNum());
                            vo1.setResidueNum(detailVO.getResidueNum()==null?BigDecimal.ZERO:detailVO.getResidueNum());

                        }
                    }
                }
                for (List l:collect.values()){
                    newDetailList.addAll(l);
                }
                Map<Long, BigDecimal> collect1 = newDetailList.stream().collect(Collectors.groupingBy(PurchasePlanDetailVO::getMaterialId,
                        Collectors.reducing(BigDecimal.ZERO, PurchasePlanDetailVO::getRequirementNum, BigDecimal::add)));
                for (PurchasePlanDetailVO detailVO:newDetailList){
                    if (collect1.containsKey(detailVO.getMaterialId())){
                        if (ComputeUtil.isGreaterThan(collect1.get(detailVO.getMaterialId()),detailVO.getResidueNum())){
                            detailVO.setExcessResidueDetailFlag(1);
                        }else {
                            detailVO.setExcessResidueDetailFlag(0);
                        }
                        if (ComputeUtil.isGreaterThan(collect1.get(detailVO.getMaterialId()),detailVO.getNum())){
                            detailVO.setExcessDetailFlag(1);
                        }{
                            detailVO.setExcessDetailFlag(0);
                        }
                    }
                }
                vo.setDetailList(newDetailList);
            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @Override
    public ParamsCheckVO checkParams(PurchasePlanVO planVo) {
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();

        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
//        1-不控制-none，2-提醒-warn，3-无法保存-alert
        String[] paramsArray = {"none", "warn", "alert"};
        String[] alertArray = {"仅提示", "超量审批", "不可提交"};
        //校验是否存在总控计划
        if (CollectionUtils.isNotEmpty(planVo.getDetailList())){

            //获取清单明细中所有物料Id
            List<Long> materialIds = new ArrayList<>(planVo.getDetailList().stream().filter(e -> !"del".equals(e.getRowState()) && null != e.getMaterialId())
                    .map(e -> e.getMaterialId()).collect(Collectors.toSet()));
            //获取物资总控量
            Map<Long, PurchasePlanDetailVO> materialControlNum = queryMaterialListSum(materialIds, planVo.getProjectId());

            List<PurchasePlanDetailVO> purchasePlanDetailVOS = detailService.selectPlanSumByMaterialIds(materialIds, planVo.getProjectId());
            Map<Long, BigDecimal> detailTotalNumMap = purchasePlanDetailVOS.stream().collect(Collectors.toMap(e -> e.getMaterialId(), e -> e.getRequirementNum()));

            List<PurchasePlanDetailVO> detailList = planVo.getDetailList();
            //重新赋值总控量
            detailList.stream().filter(detail -> !"del".equals(detail.getRowState())).forEach(detail -> {
                if(materialControlNum.containsKey(detail.getMaterialId())) {
                    detail.setNum(materialControlNum.get(detail.getMaterialId()).getNum());
                    detail.setWorkPlanFlag(PlanConstant.INTEGER_YES);
                    detail.setResidueNum(materialControlNum.get(detail.getMaterialId()).getResidueNum());
                } else {
                    detail.setNum(BigDecimal.ZERO);
                    detail.setWorkPlanFlag(PlanConstant.INTEGER_NO);
                    detail.setResidueNum(BigDecimal.ZERO);
                }
                if(detailTotalNumMap.containsKey(detail.getMaterialId())) {
                    detail.setTotalRequirementNum(materialControlNum.get(detail.getMaterialId()).getTotalRequirementNum());
                } else {
                    detail.setTotalRequirementNum(BigDecimal.ZERO);
                }
                //计算总控计划剩余量
                detail.setResidueNum(ComputeUtil.safeSub(detail.getResidueNum(), detail.getRequirementNum()));
                detail.setExcessResidueDetailFlag(ComputeUtil.safeSub(detail.getRequirementNum(), detail.getResidueNum())
                        .compareTo(BigDecimal.ZERO) > 0
                        ? PlanConstant.INTEGER_YES : PlanConstant.INTEGER_NO);
                detail.setExceedNum(ComputeUtil.safeSub(detail.getRequirementNum(), detail.getNum()));
                detail.setExcessDetailFlag(detail.getExceedNum().compareTo(BigDecimal.ZERO) > 0
                        ? PlanConstant.INTEGER_YES : PlanConstant.INTEGER_NO);
            });

            //无总控计划的物资明细
            List<PurchasePlanDetailVO> noPlanList = detailList.stream()
                    .filter(e -> !"del".equals(e.getRowState()) && !materialControlNum.containsKey(e.getMaterialId())).collect(Collectors.toList());

            if (CollectionUtils.isNotEmpty(noPlanList)){
                Map<Long, List<PurchasePlanDetailVO>> collect1 = noPlanList.stream().collect(
                        Collectors.groupingBy(
                                PurchasePlanDetailVO::getMaterialTypeId));
                Map<Long, List<MaterialCategorySettingsEntity>> longListMap = categorySettingsService.returnSettings(new ArrayList(collect1.keySet()));
                for (Map.Entry<Long, List<PurchasePlanDetailVO>> entry : collect1.entrySet()) {
                    if (longListMap.containsKey(entry.getKey())){
                        for (PurchasePlanDetailVO detailVO: entry.getValue()){
                            List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                            ParamsCheckVO paramsCheck = new ParamsCheckVO();
                            paramsCheck.setWarnType(paramsArray[2]);
                            ParamsCheckDsVO checkVO = new ParamsCheckDsVO();
                            checkVO.setOrgName(planVo.getOrgName());
                            checkVO.setWarnItem("严管材料无总控计划，请编制/变更总控计划");
                            checkVO.setWarnName("严管材料无总控计划，请编制/变更总控计划");
                            String stringBuffer = "【材料分类：" + detailVO.getMaterialTypeName() +
                                    "物资编码：" + detailVO.getMaterialCode() +
                                    "物资名称：" + detailVO.getMaterialName() +
                                    "属性值：" + detailVO.getPropertyShowName() +
                                    "型号：" + detailVO.getMaterialCode() +
                                    "】严管材料无总控计划，请编制/变更总控计划";
                            checkVO.setContent(stringBuffer);
                            checkDsVOS.add(checkVO);
                            paramsCheck.setDataSource(checkDsVOS);
                            paramsCheckVOList.add(paramsCheck);
                        }
                    }
                }
            }
            List<PurchasePlanDetailVO> filterList = detailList.stream().filter(e -> !"del".equals(e.getRowState()) && 1==e.getExcessResidueDetailFlag()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(filterList)){

                Map<Long, List<PurchasePlanDetailVO>> collectByTypeId = filterList.stream().collect(
                        Collectors.groupingBy(
                                PurchasePlanDetailVO::getMaterialTypeId));
                List<Long> categoryIds = new ArrayList<>(collectByTypeId.keySet());
                Map<Long, List<MaterialCategorySettingsEntity>> categoryIdSettings = categorySettingsService.returnSettings(categoryIds);
                for (Map.Entry<Long, List<MaterialCategorySettingsEntity>> entry : categoryIdSettings.entrySet()) {
                    List<PurchasePlanDetailVO> purchasePlanDetailVO = collectByTypeId.get(entry.getKey());

                    Map<String, List<PurchasePlanDetailVO>> collect = purchasePlanDetailVO.stream().collect(Collectors.groupingBy(PurchasePlanDetailVO::getMaterialCode));
                    for (Map.Entry<String, List<PurchasePlanDetailVO>> sumDetail : collect.entrySet()){
                        BigDecimal requirementNum = sumDetail.getValue().stream().collect(Collectors.reducing(BigDecimal.ZERO, PurchasePlanDetailVO::getRequirementNum, BigDecimal::add));
                        BigDecimal num = sumDetail.getValue().get(0).getNum();
                        BigDecimal totalRequirementNum = sumDetail.getValue().get(0).getTotalRequirementNum();
                        BigDecimal useAdd = ComputeUtil.safeAdd(totalRequirementNum, requirementNum);
                        BigDecimal bigDecimal1 = ComputeUtil.safeSub(useAdd, num);
                        //多少
                        BigDecimal bigDecimal = ComputeUtil.bigDecimalPercent(bigDecimal1,num,4);
                        if (null!=entry.getValue()){
                            List<MaterialCategorySettingsEntity> value = entry.getValue();
                            List<MaterialCategorySettingsEntity> sortCollect = value.stream().sorted(Comparator.comparing(MaterialCategorySettingsEntity::getControlMode)).collect(Collectors.toList());
                            for (MaterialCategorySettingsEntity settingsEntity:sortCollect){
                                Integer controlMode1 = settingsEntity.getControlMode();
                                boolean checkFlag = false;
                                String warnType = "";
                                //区域校验 取头不取尾
                                if (controlMode1==1||controlMode1==2){
                                    if (ComputeUtil.isGreaterThan(bigDecimal,settingsEntity.getMinControlRation())&&ComputeUtil.isLessOrEqual(bigDecimal,settingsEntity.getMaxControlRation())){
                                        //区间内继续组装数据
                                        checkFlag =true;
                                        warnType = paramsArray[1];
                                    }
                                }else {
                                    if (ComputeUtil.isGreaterThan(bigDecimal,settingsEntity.getMinControlRation())){
                                        //继续组装数据
                                        checkFlag =true;
                                        warnType = paramsArray[2];
                                    }
                                }
                                if (checkFlag){
                                    for (PurchasePlanDetailVO detailVO :sumDetail.getValue()){
                                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                                        ParamsCheckVO paramsCheck = new ParamsCheckVO();
                                        paramsCheck.setWarnType(warnType);
                                        //控制等级
                                        Integer controlMode = settingsEntity.getControlMode();
                                        ParamsCheckDsVO checkVO = new ParamsCheckDsVO();
                                        checkVO.setOrgName(planVo.getOrgName());
                                        checkVO.setWarnItem(alertArray[controlMode -1]);
                                        checkVO.setWarnName(alertArray[controlMode -1].equals("不可提交")?"不可提交,请变更总控计划!":alertArray[controlMode -1]);
                                        String stringBuffer = "【材料分类：" + detailVO.getMaterialTypeName() +
                                                "物资编码：" + detailVO.getMaterialCode() +
                                                "物资名称：" + detailVO.getMaterialName() +
                                                "属性值：" + detailVO.getPropertyShowName() +
                                                "型号：" + detailVO.getMaterialCode() +
                                                "】总控量" + detailVO.getNum() +
                                                "累计超量" + bigDecimal1;
                                        checkVO.setContent(stringBuffer);
                                        checkDsVOS.add(checkVO);
                                        paramsCheck.setDataSource(checkDsVOS);
                                        paramsCheckVOList.add(paramsCheck);
                                    }

                                }
                            }
                        }
                    }
                    }
            }
        }
        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0&&null!=e.getWarnType()).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<ParamsCheckVO> result = new ArrayList<>();
        if(null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if(null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for(ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }
        return paramsCheckVO;
    }

    public boolean checkUpdateDetailParams(PurchasePlanVO planVo) {
        boolean flag = false;
        String[] paramsArray = {"none", "warn", "alert"};
        String[] alertArray = {"仅提示", "超量审批", "不可提交"};

        List<String> errList = new ArrayList<>();

        CommonResponse<JSONArray> projectResp = projectPoolApi.queryProjectPoolById(planVo.getProjectId());
        if (!projectResp.isSuccess()){
            throw new BusinessException("查询项目数据出错！");
        }
        ProjectPoolSetVO p = JSONObject.parseObject(JSONObject.toJSONString(projectResp.getData().get(0)), ProjectPoolSetVO.class);
        //项目总控计划控采购计划标识: 0-不控制，1-控制
//        if(PlanConstant.INTEGER_NO.equals(p.getControlPurPlanFlag())) {
//            return CommonResponse.success("参数校验成功！", new ParamsCheckVO());
//        }

        //校验是否存在总控计划
        if (CollectionUtils.isNotEmpty(planVo.getDetailList())) {
            Map<Long, BigDecimal> controlNum = new HashMap<>();
            List<Long> materialIds = planVo.getDetailList().stream()
                    .filter(item -> !"del".equals(item.getRowState()) &&
                            null != item.getMaterialId()).map(PurchasePlanDetailVO::getMaterialId).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(materialIds)) {
                List<PurchasePlanDetailEntity> controlPlanSumDetailEntities = sumDetailService.queryList(materialIds, planVo.getProjectId());
                if(CollectionUtils.isNotEmpty(controlPlanSumDetailEntities)) {
                    controlNum.putAll(controlPlanSumDetailEntities.stream().collect(Collectors.toMap(item -> item.getMaterialId(), item -> item.getNum())));
                }
            }


            //查询控制设置
            List<PurchasePlanDetailVO> filterList = planVo.getDetailList().stream().filter(e -> !"del".equals(e.getRowState())
                    && 1 == e.getExcessResidueDetailFlag()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(filterList)) {
                Map<Long, List<PurchasePlanDetailVO>> collectByTypeId = filterList.stream().collect(
                        Collectors.groupingBy(
                                PurchasePlanDetailVO::getMaterialTypeId));
                List<Long> categoryIds = new ArrayList<>(collectByTypeId.keySet());
                Map<Long, List<MaterialCategorySettingsEntity>> categoryIdSettings = categorySettingsService.returnSettings(categoryIds);
                for (Map.Entry<Long, List<MaterialCategorySettingsEntity>> entry : categoryIdSettings.entrySet()) {
                    List<PurchasePlanDetailVO> purchasePlanDetailVO = collectByTypeId.get(entry.getKey());

                    Map<String, List<PurchasePlanDetailVO>> collect = purchasePlanDetailVO.stream().collect(Collectors.groupingBy(PurchasePlanDetailVO::getMaterialCode));
                    for (Map.Entry<String, List<PurchasePlanDetailVO>> sumDetail : collect.entrySet()) {
                        BigDecimal requirementNum = sumDetail.getValue().stream().collect(Collectors.reducing(BigDecimal.ZERO, PurchasePlanDetailVO::getRequirementNum, BigDecimal::add));
                        BigDecimal num = sumDetail.getValue().get(0).getNum();
                        BigDecimal totalRequirementNum = sumDetail.getValue().get(0).getTotalRequirementNum();
                        BigDecimal useAdd = ComputeUtil.safeAdd(totalRequirementNum, requirementNum);
                        BigDecimal bigDecimal1 = ComputeUtil.safeSub(useAdd, num);
                        if (ComputeUtil.isGreaterThan(bigDecimal1, num)){
                            sumDetail.getValue().stream().forEach(e->{
                                if (StringUtils.isBlank(e.getExcessCause())){
                                    if (!errList.contains(e.getMaterialCode())){
                                        if(controlNum.containsKey(e.getMaterialId()) || PlanConstant.INTEGER_YES.equals(p.getControlPurPlanFlag())) {
                                            //项目未开启总控空采购计划且不在总控计划中 不提示超量
                                            errList.add(e.getMaterialCode());
                                        }
                                    }

                                }
                            });
                        }

                        //多少
                        BigDecimal bigDecimal = ComputeUtil.bigDecimalPercent(bigDecimal1, num, 4);


                        if (null != entry.getValue()) {
                            List<MaterialCategorySettingsEntity> value = entry.getValue();
                            List<MaterialCategorySettingsEntity> sortCollect = value.stream().sorted(Comparator.comparing(MaterialCategorySettingsEntity::getControlMode)).collect(Collectors.toList());
                            for (MaterialCategorySettingsEntity settingsEntity : sortCollect) {
                                Integer controlMode1 = settingsEntity.getControlMode();
                                boolean checkFlag = false;
                                String warnType = "";
                                //区域校验 取头不取尾
                                if (controlMode1 == 1 || controlMode1 == 2) {
                                    if (ComputeUtil.isGreaterThan(bigDecimal, settingsEntity.getMinControlRation()) && ComputeUtil.isLessOrEqual(bigDecimal, settingsEntity.getMaxControlRation())) {
                                        //区间内继续组装数据
                                        checkFlag = true;
                                        warnType = paramsArray[1];
                                    }
                                } else {
                                    if (ComputeUtil.isGreaterThan(bigDecimal, settingsEntity.getMinControlRation())) {
                                        //继续组装数据
                                        checkFlag = true;
                                        warnType = paramsArray[2];
                                    }
                                }
                                if (checkFlag) {
                                    for (PurchasePlanDetailVO detailVO : sumDetail.getValue()) {
                                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                                        ParamsCheckVO paramsCheck = new ParamsCheckVO();
                                        paramsCheck.setWarnType(warnType);
                                        //控制等级
                                        Integer controlMode = settingsEntity.getControlMode();
                                        if (controlMode==2){
                                            flag = true;
                                            return true;
                                        }
                                    }

                                }
                            }
                        }
                    }
                    if(CollectionUtils.isNotEmpty(errList)){
                        throw new BusinessException("请填写对应物资编码" + errList.stream().collect(Collectors.joining(","))+ "的超量原因！");
                    }

                }
            }
            }
        return false;
    }


    @Override
    public Map<Long, PurchasePlanDetailVO> queryMaterialListSum(List<Long> materialIds,Long projectId){
        if (CollectionUtils.isNotEmpty(materialIds)){
            List<PurchasePlanDetailEntity> controlPlanSumDetailEntities = sumDetailService.queryList(materialIds,projectId);
            List<PurchasePlanDetailVO> purchasePlanDetailVOS = detailService.selectPlanSumByMaterialIds(materialIds, projectId);

            //查询计划量
            //TODO 查询订单量
            BigDecimal num = BigDecimal.ZERO, decimal1 = null;
            if (CollectionUtils.isNotEmpty(controlPlanSumDetailEntities)){
                List<PurchasePlanDetailVO> purchasePlanVOS = BeanMapper.mapList(controlPlanSumDetailEntities, PurchasePlanDetailVO.class);
                Map<Long, PurchasePlanDetailVO> collect = purchasePlanVOS.stream().collect(Collectors.toMap(PurchasePlanDetailVO::getMaterialId, e -> e));
                for (PurchasePlanDetailVO entry : purchasePlanDetailVOS) {
                    if (collect.containsKey(entry.getMaterialId())){
                        num = collect.get(entry.getMaterialId()).getNum();
                        decimal1 = ComputeUtil.safeSub(num, entry.getRequirementNum());
                        collect.get(entry.getMaterialId()).setResidueNum(ComputeUtil.isGreaterThan(decimal1,BigDecimal.ZERO)?decimal1:BigDecimal.ZERO);
                    } else {
                        entry.setResidueNum(ComputeUtil.safeSub(BigDecimal.ZERO, entry.getRequirementNum()));
                        collect.put(entry.getMaterialId(), entry);
                    }
                }
                return collect;
            } else if(CollectionUtils.isNotEmpty(purchasePlanDetailVOS)) {
                for (PurchasePlanDetailVO entry : purchasePlanDetailVOS) {
                    decimal1 = ComputeUtil.safeSub(num, entry.getRequirementNum());
                    entry.setResidueNum(ComputeUtil.isGreaterThan(decimal1,BigDecimal.ZERO)?decimal1:BigDecimal.ZERO);
                }
                return purchasePlanDetailVOS.stream().collect(Collectors.toMap(item -> item.getMaterialId(), item -> item));
            }
        }
        return new HashMap<>();
    }

    @Override
    public Map<String, BigDecimal> queryAllotSum(List<String> materialCodes, Long projectId) {
        Map<String, BigDecimal> collect = new HashMap<>();
        if(CollectionUtils.isNotEmpty(materialCodes)){

            CommonResponse<ProjectVO> projectVOCommonResponse = projectPoolApi.queryDetailById(projectId);
            ProjectVO data = projectVOCommonResponse.getData();
            Long secOrgId = null;

            //TODO 查询项目所属二级单位在云仓的上架数量。
            CommonResponse<OrgVO> orgResp = orgApi.getOneById(data.getOrgId());
            if(!orgResp.isSuccess() || null == orgResp.getData()) {
                logger.error("查询组织id-{}对应二级单位信息失败：{}", data.getOrgId(), JSONObject.toJSONString(orgResp));
                throw new BusinessException("查询二级单位信息失败!");
            }

            OrgVO orgVO = orgResp.getData();
            String[] idStrArr = orgVO.getInnerCode().split("\\|");
            secOrgId = idStrArr.length > 2 ? Long.valueOf(idStrArr[1]) : Long.valueOf(idStrArr[idStrArr.length-1]);

            QueryWrapper<GoodsEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
            queryWrapper.in("material_code",materialCodes);
            queryWrapper.in("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
            List<GoodsEntity> list = goodsService.list(queryWrapper);

            if (CollectionUtils.isNotEmpty(list)){
                for(GoodsEntity g : list) {
                    if(secOrgId.equals(g.getOrgId())) {
                        collect.put(g.getMaterialCode()+"_local", ComputeUtil.safeAdd(collect.containsKey(g.getMaterialCode()+"_local")
                                ? collect.get(g.getMaterialCode()+"_local") : BigDecimal.ZERO, g.getNum()));
                    } else {
                        collect.put(g.getMaterialCode()+"_other", ComputeUtil.safeAdd(collect.containsKey(g.getMaterialCode()+"_other")
                                ? collect.get(g.getMaterialCode()+"_other") : BigDecimal.ZERO, g.getNum()));
                    }
                }
            }
            return collect;
        }
        return collect;
    }

    @Override
    public Map<String, BigDecimal> queryAllotOrgSum(List<String> materialCodes, Long projectId) {
        Map<String, BigDecimal> collect = new HashMap<>();
        if(CollectionUtils.isNotEmpty(materialCodes)){

            Long secOrgId = null;
            CommonResponse<ProjectVO> projectVOCommonResponse = projectPoolApi.queryDetailById(projectId);
            ProjectVO data = projectVOCommonResponse.getData();

            CommonResponse<OrgVO> orgResp = orgApi.getOneById(data.getOrgId());
            if(!orgResp.isSuccess() || null == orgResp.getData()) {
                logger.error("查询组织id-{}对应二级单位信息失败：{}", data.getOrgId(), JSONObject.toJSONString(orgResp));
                throw new BusinessException("查询二级单位信息失败!");
            }

            OrgVO orgVO = orgResp.getData();
            String[] idStrArr = orgVO.getInnerCode().split("\\|");
            secOrgId = idStrArr.length > 2 ? Long.valueOf(idStrArr[1]) : Long.valueOf(idStrArr[idStrArr.length-1]);

            //TODO 查询项目所属二级单位在云仓的上架数量。
            QueryWrapper<GoodsEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("org_id", secOrgId);
            queryWrapper.in("material_code",materialCodes);
            List<GoodsEntity> list = goodsService.list(queryWrapper);

            if (CollectionUtils.isNotEmpty(list)){
                Map<String, List<GoodsEntity>> collect1 = list.stream().collect(Collectors.groupingBy(GoodsEntity::getMaterialCode));
                for (Map.Entry<String, List<GoodsEntity>> entity : collect1.entrySet()) {
                    if (CollectionUtils.isNotEmpty(entity.getValue())) {
                        List<GoodsEntity> value = entity.getValue();
                        BigDecimal num = BigDecimal.ZERO;
                        for (GoodsEntity e:value){
                            num = ComputeUtil.safeAdd(num,e.getNum());
                        }
                        collect.put(entity.getKey(),num);
                    }
                }
            }
            return collect;
        }
        return collect;
    }

    @Override
    public  BigDecimal  queryAllotOtherSum(String materialCode, Long brandId, Long projectId) {
            //TODO 材料编码+品牌查询项目所属二级单位除外的其他大区在云仓的上架数量。
            CommonResponse<ProjectVO> projectVOCommonResponse = projectPoolApi.queryDetailById(projectId);
            ProjectVO data = projectVOCommonResponse.getData();
            Long secOrgId = null;

            CommonResponse<OrgVO> orgResp = orgApi.getOneById(data.getOrgId());
            if(!orgResp.isSuccess() || null == orgResp.getData()) {
                logger.error("查询组织id-{}对应二级单位信息失败：{}", data.getOrgId(), JSONObject.toJSONString(orgResp));
                throw new BusinessException("查询二级单位信息失败!");
            }

            OrgVO orgVO = orgResp.getData();
            String[] idStrArr = orgVO.getInnerCode().split("\\|");
            secOrgId = idStrArr.length > 2 ? Long.valueOf(idStrArr[1]) : Long.valueOf(idStrArr[idStrArr.length-1]);

            //TODO 查询项目所属二级单位在云仓的上架数量。
            QueryWrapper<GoodsEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.ne("org_id", secOrgId);
            queryWrapper.eq("material_code",materialCode);
            queryWrapper.eq("brand_id",brandId);
            List<GoodsEntity> list = goodsService.list(queryWrapper);
            BigDecimal num = BigDecimal.ZERO;
            for (GoodsEntity entity:list){
                num = ComputeUtil.safeAdd(num,entity.getNum());
            }
            return num;
    }

    /**
     * 查询对应的物质是否处于变更中
     * @param materialIds ww1
     */
    @Override
    public void checkMaterialSumPlan(List<Long> materialIds,Long projectId){
        List<String> materialNames = new ArrayList<>();
        QueryWrapper<ControlPlanEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id",projectId);
        queryWrapper.in("bill_type", PlanConstant.CHANGE_ING);
        queryWrapper.notIn("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});

        List<ControlPlanEntity> list = controlPlanService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)){
            QueryWrapper<ControlPlanDetailEntity> queryParam = new QueryWrapper();
            queryParam.in("plan_id",list.stream().map(e->e.getId()).collect(Collectors.toList()));
            List<ControlPlanDetailEntity> detailList =  controlPlanDetailService.list(queryParam);
            if (CollectionUtils.isNotEmpty(detailList)) {
                detailList.stream().forEach(e->{
                    if (materialIds.indexOf(e.getMaterialId())>-1){
                        materialNames.add(e.getMaterialName());
                    }
                });

                if (CollectionUtils.isNotEmpty(materialNames)){
                    throw new BusinessException("当前物料"+String.join(", ", materialNames)+"在总控计划汇总中处于变更中，不允许保存或提交采购计划！");
                }
            }

        }
//        List<PurchasePlanDetailEntity> controlPlanSumDetailEntities = sumDetailService.queryList(materialIds,projectId);
//        List<Long> collect = controlPlanSumDetailEntities.stream().map(PurchasePlanDetailEntity::getPlanId).collect(Collectors.toList());
//
//        QueryWrapper<ControlPlanSumEntity> queryWrapper = new QueryWrapper<>();
//        queryWrapper.eq("project_id",projectId);
//        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
//        queryWrapper.eq("change_status", PlanConstant.CHANGE_ING);
//        List<ControlPlanSumEntity> list = sumService.list(queryWrapper);
//
//
//
//
//        int count =
//        if (count>0){
//            throw new BusinessException("总控计划汇总变更中，不允许提交采购计划！");
//        }

    }


    @Override
    public void planToSum(PurchasePlanEntity plan,boolean addFlag){
        if (CollectionUtils.isNotEmpty(plan.getDetailList())){
            List<PurchasePlanDetailEntity> detailList = plan.getDetailList();
            List<PurchasePlanDetailEntity> collect = detailList.stream().filter(e -> e.getWorkPlanFlag() == 1).collect(Collectors.toList());
            logger.info("collect"+ JSONObject.toJSONString(collect));
            if (CollectionUtils.isNotEmpty(collect)){
                Map<Long, List<PurchasePlanDetailEntity>> collect1 = collect.stream().collect(Collectors.groupingBy(
                        PurchasePlanDetailEntity::getMaterialId));
                logger.info("collect1"+ JSONObject.toJSONString(collect1));
                QueryWrapper<ControlPlanSumDetailEntity> detailEntityQueryWrapper = new QueryWrapper<>();
                detailEntityQueryWrapper.in("material_id",collect1.keySet());

                List<ControlPlanSumDetailEntity> list = sumDetailService.queryListBySum(collect.stream().map(PurchasePlanDetailEntity::getMaterialId).collect(Collectors.toList()),plan.getProjectId());
                if (CollectionUtils.isNotEmpty(list)){
                    for (ControlPlanSumDetailEntity e :list){
                        if (collect1.containsKey(e.getMaterialId())){
                            List<PurchasePlanDetailEntity> purchasePlanDetailEntities = collect1.get(e.getMaterialId());
                            BigDecimal decimal = purchasePlanDetailEntities.stream().map(PurchasePlanDetailEntity::getRequirementNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal getPlanNum = e.getPlanNum();
                            if (addFlag){
                                e.setPlanNum(ComputeUtil.safeAdd(decimal,getPlanNum));
                            }else {
                                e.setPlanNum(ComputeUtil.safeSub(getPlanNum,decimal));
                            }
                        }
                        if (e.getPlanNum() != null && e.getPlanNum().compareTo(BigDecimal.ZERO) == 1){
                            e.setQuoteType(2);
                        }else {
                            e.setQuoteType(1);
                        }
                    }
                    sumDetailService.saveOrUpdateBatch(list);
                }

            }
        }
    }

    @Override
    public IPage<SupPurchasePlanVo> supQueryList(Map<String, Object> params){

        IPage<SupPurchasePlanVo> page = new Page<>();
        List<SupPurchasePlanVo> voList = new ArrayList<>();
        if (!params.containsKey("pageNumber")){
            throw new BusinessException("pageNumber 未传入!");
        }
        if (!params.containsKey("pageSize")){
            throw new BusinessException("pageSize 未传入!");

        }
        page.setCurrent(Integer.valueOf(params.get("pageNumber").toString()));
        page.setSize(Integer.valueOf(params.get("pageSize").toString()));

//        CommonResponse<List<OrgVO>> childrenByParentIdWithoutProjectDept = iOrgApi.findChildrenByParentIdWithoutProjectDept(1744904277224144897L);
//        params.put("orgIds",childrenByParentIdWithoutProjectDept.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        long total = mapper.count(params);
        page.setTotal(total);
        if(total == 0) {
            page.setRecords(voList);
            return page;
        }
        long startLine = (page.getCurrent() < 1 ? 0 : page.getCurrent() -  1) * page.getSize();
        params.put("startLine", startLine);
        params.put("pageSize", page.getSize());


        List<PurchasePlanEntity> list = mapper.getList(params);
        List<Long> collect1 = list.stream().map(PurchasePlanEntity::getId).collect(Collectors.toList());
        Map<Long, String> collect = list.stream().collect(Collectors.toMap(e -> e.getId(), e -> e.getCreateUserSid()));
        JSONObject paramStr = new JSONObject();
        paramStr.put("sourceIds",collect1);
        paramStr.put("orderType","desc");



        List<ArchivesInforVo> inforVos = new ArrayList<>();
        //设置附件信息
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(paramStr);
        if (listCommonResponse.isSuccess()){
            List<AttachmentVO> data = listCommonResponse.getData();
            for (AttachmentVO vo:data){
                ArchivesInforVo archivesInforVo = new ArchivesInforVo();
                if (collect.containsKey(vo.getSourceId())){
                    archivesInforVo.setAttach_Uploader_Sid(collect.get(vo.getSourceId()));
                }
                archivesInforVo.setAttach_Uploader(vo.getUploadUserName());
                archivesInforVo.setAttach_Name(vo.getFileName().replaceAll(" ", ""));
                archivesInforVo.setAttach_Extension(vo.getFileName());
                archivesInforVo.setAttachBase64(vo.getTruePath());
                archivesInforVo.setAttach_UploadDateTime(vo.getCreateTime());
                archivesInforVo.setSourceId(vo.getSourceId().toString());
                archivesInforVo.setPS_PurchasePlan_FK(new UUID(vo.getSourceId(), vo.getSourceId() >> 64).toString());
                inforVos.add(archivesInforVo);
            }
        }
        Map<String, List<ArchivesInforVo>> fileCollect  = inforVos.stream().collect(Collectors.groupingBy(ArchivesInforVo::getSourceId));

        //设置明细
        List<PurchasePlanDetailEntity> supPurchasePlanDetailVOS = detailMapper.selectPlanByPIds(collect1);
        List<SupPurchasePlanDetailVO> detailVOS = new ArrayList<>();
        for (PurchasePlanDetailEntity detail:supPurchasePlanDetailVOS){
            if(StringUtils.isNotBlank(detail.getPropertyValue())) {
                //替换单引号
                detail.setPropertyValue(detail.getPropertyValue().replaceAll("'", "‘"));
            }
            SupPurchasePlanDetailVO supPurchasePlanDetailVO = returnSubDetail(detail);
            detailVOS.add(supPurchasePlanDetailVO);
        }
        Map<String, List<SupPurchasePlanDetailVO>> collect2 = detailVOS.stream().collect(Collectors.groupingBy(SupPurchasePlanDetailVO::getPS_PurchasePlan_FK));

        for (PurchasePlanEntity entity:list){
            String planGuid = new UUID(entity.getId(), entity.getId() >> 64).toString();
            SupPurchasePlanVo vo = returnSubEntity(entity);
            //设置明细
            if (collect2.containsKey(planGuid)){
                List<SupPurchasePlanDetailVO> detailVOS1 = collect2.get(planGuid);
                Integer[] arr = {1};
                List<SupPurchasePlanDetailVO> cc = detailVOS1.stream().peek(e -> e.setSortID((arr[0]++).toString())).collect(Collectors.toList());
                vo.setDetails(cc);
            }
            //设置附件
            if (fileCollect.containsKey(vo.getYQL_SID())){
                vo.setArchivesInfor(fileCollect.get(vo.getYQL_SID()));
            }
            voList.add(vo);
        }
        page.setRecords(voList);
        return page;
    }

    public SupPurchasePlanDetailVO returnSubDetail(PurchasePlanDetailEntity detail){
        SupPurchasePlanDetailVO supPurchasePlanDetailVO = new SupPurchasePlanDetailVO();
        supPurchasePlanDetailVO.setYQL_SID(detail.getId().toString());
        supPurchasePlanDetailVO.setMaterialClass(detail.getMaterialTypeName());
        supPurchasePlanDetailVO.setListMaterialCodeT(detail.getMaterialCode());
        supPurchasePlanDetailVO.setMaterialName(detail.getMaterialName()+"."+detail.getPropertyValue());
        supPurchasePlanDetailVO.setMaterialClassSid(null==detail.getMaterialTypeSid()?null:detail.getMaterialTypeSid());
        supPurchasePlanDetailVO.setMaterialClass_FK(new UUID(detail.getMaterialId(), detail.getMaterialId() >> 64).toString());
        supPurchasePlanDetailVO.setMeteringUnit(detail.getUnitName());
        supPurchasePlanDetailVO.setBuyAmount(detail.getRequirementNum().toString());
        supPurchasePlanDetailVO.setPS_PurchasePlan_FK(new UUID(detail.getPlanId(), detail.getPlanId() >> 64).toString());
        supPurchasePlanDetailVO.setSupplyTime(detail.getPlanInDate());
        supPurchasePlanDetailVO.setMemo(detail.getMemo());
        supPurchasePlanDetailVO.setModelNorm(detail.getPropertyValue());
        supPurchasePlanDetailVO.setListMaterialCode(detail.getMaterialSerialNo());
        if (null != detail.getBudgetType() && "1".equals(detail.getBudgetType())) {
            supPurchasePlanDetailVO.setMaterialCode(detail.getCostCodingCode());
        } else{
            supPurchasePlanDetailVO.setMaterialCode(detail.getCostCodingName());
        }
        supPurchasePlanDetailVO.setSystemClassifyName(detail.getSystemClassifyName());
        supPurchasePlanDetailVO.setInventoryClassifyCode(detail.getInventoryClassifyCode());
        supPurchasePlanDetailVO.setNewPropertyVal(detail.getSourceType()==2?"1":"0");
        return supPurchasePlanDetailVO;
    }
    public SupPurchasePlanVo returnSubEntity(PurchasePlanEntity entity){
        SupPurchasePlanVo vo = new SupPurchasePlanVo();
        vo.setYQL_SID(entity.getId().toString());
        vo.setMa_id(entity.getBillCode());
        vo.setStatus("2");
        vo.setAccount_Project_Id(entity.getProjectCode());
        vo.setAccountingProjectSet_FK(entity.getProjectSid());
        vo.setAccount_Project_Shortname(entity.getProjectName());
        vo.setProjectManager(entity.getProjectManagerName());
        vo.setProjectManager_Sid(null==entity.getProjectManagerSid()?null:entity.getProjectManagerSid().toString());
        vo.setResponsibleEngineer(entity.getEngineerName());
        vo.setResponsibleEngineer_Sid(null==entity.getEngineerSid()?null:entity.getEngineerSid().toString());
        vo.setPurchaseEngineer(entity.getPurchaseWorkerName());
        vo.setPurchaseEngineer_Sid(null==entity.getPurchaseWorkerSid()?null:entity.getPurchaseWorkerSid().toString());
        vo.setMajor(entity.getJobSpecialtyName());
        vo.setMajorSid(entity.getJobSpecialtyCode());
        vo.setProjectChiefEngineer(entity.getChiefEngineerName());
        vo.setProjectChiefEngineer_Sid(null==entity.getChiefEngineerSid()?null:entity.getChiefEngineerSid().toString());
        vo.setBusContractName(entity.getBusinessContractName());
        vo.setBuContractSID(null==entity.getBusinessContractId()?null:entity.getBusinessContractId().toString());
        vo.setBusContractCode(entity.getBusinessContractCode());
        vo.setPurchaseContent(entity.getMemo());
        vo.setSYS_Created(entity.getCreateTime());
        vo.setApprDate(entity.getEffectDate());
        vo.setRegister_Name(entity.getCreateUserName());
        vo.setPosition_Name(entity.getUserPostName());
        vo.setDivision_Name(entity.getUserDepartName());
        vo.setOrg_Name(entity.getUserOrgName());
        vo.setApprHuman_sid(null==entity.getApproveUserSid()?null:entity.getApproveUserSid().toString());
        vo.setAccount_Project_Fullname(entity.getProjectName());
        vo.setApprHuman(entity.getApproveUserName());
        vo.setSYS_CreatedBy(entity.getCreateUserSid());
        return vo;
    }

    }
