package com.ejianc.business.zdsmaterial.sub.fee.bean;

import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 分包费用申请审核人员设置
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_sub_fee_auditor_set")
public class AuditorSetEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_sid")
    private String projectSid; // 项目来源id
    @TableField(value="org_id")
    private Long orgId; // 单据组织id
    @TableField(value="org_name")
    private String orgName; // 单据组织名称
    @TableField(value="org_code")
    private String orgCode; // 单据组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="auditorUserDetailService",pidName="auditorSetId")
    private List<AuditorUserDetailEntity> userDetailList = new ArrayList<>(); // 分包费用申请审核人员设置详情
    @TableField(exist=false)
    @SubEntity(serviceName="auditorContractDetailService",pidName="auditorSetId")
    private List<AuditorContractDetailEntity> contractDetailList = new ArrayList<>(); // 分包费用申请审核人员设置合同详情
    

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectSid() {
        return projectSid;
    }

    public void setProjectSid(String projectSid) {
        this.projectSid = projectSid;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    

    public List<AuditorUserDetailEntity> getUserDetailList() {
        return userDetailList;
    }

    public void setUserDetailList(List<AuditorUserDetailEntity> userDetailList) {
        this.userDetailList = userDetailList;
    }

    public List<AuditorContractDetailEntity> getContractDetailList() {
        return contractDetailList;
    }

    public void setContractDetailList(List<AuditorContractDetailEntity> contractDetailList) {
        this.contractDetailList = contractDetailList;
    }
}
