package com.ejianc.business.zdsmaterial.sub.fee.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.sub.fee.bean.AuditorContractDetailEntity;
import com.ejianc.business.zdsmaterial.sub.fee.bean.AuditorSetEntity;
import com.ejianc.business.zdsmaterial.sub.fee.service.IAuditorContractDetailService;
import com.ejianc.business.zdsmaterial.sub.fee.service.IAuditorSetService;
import com.ejianc.business.zdsmaterial.sub.fee.vo.AuditorContractDetailVO;
import com.ejianc.business.zdsmaterial.sub.fee.vo.AuditorSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;

@Controller
@RequestMapping("auditorSet")
public class AuditorSetController implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IAuditorSetService service;
    @Autowired
    private IAuditorContractDetailService contractDetailService;


    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AuditorSetVO> queryDetail(Long id) {
        AuditorSetEntity entity = service.selectById(id);
        AuditorSetVO vo = BeanMapper.map(entity, AuditorSetVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }
    @RequestMapping(value = "/auditorSetByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AuditorSetVO> auditorSetByProjectId(Long projectId) {
        return service.auditorSetByProjectId(projectId);
    }

    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AuditorContractDetailVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        if(!param.getParams().containsKey("auditorSetId")){
//            throw new BusinessException("人员必输！！");
//        }
        IPage<AuditorContractDetailEntity> page = contractDetailService.queryPage(param,false);
        IPage<AuditorContractDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<AuditorContractDetailVO> records = BeanMapper.mapList(page.getRecords(), AuditorContractDetailVO.class);
        pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/queryContract", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> queryContract(@RequestBody AuditorContractDetailVO detailVO) {
        return service.queryContract(detailVO);
    }
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AuditorSetVO> saveOrUpdate(@RequestBody AuditorSetVO saveOrUpdateVO) {
        return service.saveOrUpdate(saveOrUpdateVO);
    }


}
