package com.ejianc.business.zdsmaterial.sub.fee.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractDetailEntity;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractDetailService;
import com.ejianc.business.zdsmaterial.sub.fee.bean.SubFeeApplyDetailEntity;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyDetailService;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyService;
import com.ejianc.business.zdssupplier.sub.api.ISubSupplierApi;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2024/5/20 18:25
 */
@RestController
@RequestMapping("subFeeApply/erp")
public class SubFeeApplyErpController {

    Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private ISubSupplierApi subSupplierApi;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private ISubFeeApplyService service;

    @Autowired
    private ISubFeeApplyDetailService detailService;

    @Autowired
    private ISubContractDetailService contractDetailService;


    @PostMapping(value = "/pageList")
    public CommonResponse<JSONObject> pageSyncList(@RequestBody JSONObject param) {
        JSONObject resp = new JSONObject();

        logger.info("ERP查询分包费用申请参数：{}", JSONObject.toJSONString(param, SerializerFeature.PrettyFormat));
        Integer pageSize = null != param && null != param.getInteger("PageSize") ? param.getInteger("PageSize") : 10;
        Integer pageNum = null != param && null != param.getInteger("PageNum") ? param.getInteger("PageNum") : 1;
        String BeginDateTime = null != param && null != param.getString("BeginDateTime") ? param.getString("BeginDateTime") : null;
        String EndDateTime = null != param && null != param.getString("EndDateTime") ? param.getString("EndDateTime") : null;

        Map<String, Object> queryParam = new HashMap<>();
        if(StringUtils.isNotBlank(BeginDateTime)) {
            queryParam.put("beginDateTime", BeginDateTime);
        }
        if(StringUtils.isNotBlank(EndDateTime)) {
            queryParam.put("endDateTime", EndDateTime);
        }

        int count = service.pageCount(queryParam);
        resp.put("total", count);
        resp.put("pageSize", pageSize);
        resp.put("pageNum", pageNum);

        if(count == 0) {
            resp.put("records", new ArrayList<>());
            return CommonResponse.success("查询成功！", resp);
        }

        Integer startLine = pageNum - 1 < 0 ? pageSize : (pageNum - 1) * pageSize;
        queryParam.put("startLine", startLine);
        queryParam.put("pageSize", pageSize);

        List<JSONObject> pageList = service.pageList(queryParam);
        List<Long> projectIds = new ArrayList<>();
        List<Long> pIds = new ArrayList<>();
        List<Long> supplierIds = new ArrayList<>();
        List<String> syncContractVO = new ArrayList<>();
        List<Long> empIds = new ArrayList<>();
        pageList.stream().forEach(item -> {
            if(!projectIds.contains(item.getLong("projectId"))) {
                projectIds.add(item.getLong("projectId"));
            }
            if(!pIds.contains(item.getLong("YQL_SID"))) {
                pIds.add(item.getLong("YQL_SID"));
            }
            if(!supplierIds.contains(item.getLong("supplierId"))) {
                supplierIds.add(item.getLong("supplierId"));
            }
            if(StringUtils.isNotBlank(item.getString("ApprHumanCode")) && !syncContractVO.contains(item.getString("ApprHumanCode"))) {
                syncContractVO.add(item.getString("ApprHumanCode"));
            }
            if(!empIds.contains(item.getLong("EngineerId"))) {
                empIds.add(item.getLong("EngineerId"));
            }
        });

        //查询项目信息
        CommonResponse<JSONArray> projectResp = projectPoolApi.queryProjectByIds(projectIds);
        if(!projectResp.isSuccess()) {
            logger.error("分包费用申请查询失败，根据项目Id列表-{}查询项目信息失败，{}", JSONObject.toJSONString(projectIds),
                    JSONObject.toJSONString(projectResp, SerializerFeature.PrettyFormat));
            return CommonResponse.error("查询失败，获取项目信息失败！");
        }

        Map<Long, String> projectSidMap = new HashMap<>();
        List<ProjectPoolSetVO> projectList = JSONArray.parseArray(JSONObject.toJSONString(projectResp.getData()), ProjectPoolSetVO.class);
        if(CollectionUtils.isNotEmpty(projectList)) {
            projectSidMap.putAll(projectList.stream().collect(Collectors.toMap(ProjectPoolSetVO::getId, ProjectPoolSetVO::getSourceId)));
        }

        //查询供应商信息
        Map<Long, SupplierVO> supplierMap = new HashMap<>();
        CommonResponse<List<SupplierVO>> supplierResp = subSupplierApi.getAllByIds(supplierIds);
        if(!supplierResp.isSuccess()) {
            logger.error("分包费用申请查询失败，根据供应商列表-{}查询人员信息失败，{}", JSONObject.toJSONString(supplierIds),
                    JSONObject.toJSONString(supplierResp, SerializerFeature.PrettyFormat));
            return CommonResponse.error("查询失败，获取供应商信息失败！");
        }
        supplierMap.putAll(supplierResp.getData().stream().collect(Collectors.toMap(SupplierVO::getId, Function.identity())));

        //查询人员信息
        Map<String, EmployeeVO> empMap = new HashMap<>();
        Map<Long, EmployeeVO> empIdMap = new HashMap<>();
        CommonResponse<List<EmployeeVO>> empResp = employeeApi.getAllByEmployeeCodes(syncContractVO);
        if(!empResp.isSuccess()) {
            logger.error("分包费用申请查询失败，根据人员工号列表-{}查询人员信息失败，{}", JSONObject.toJSONString(syncContractVO),
                    JSONObject.toJSONString(empResp, SerializerFeature.PrettyFormat));
            return CommonResponse.error("查询失败，获取人员信息失败！");
        }
        List<EmployeeVO> empList = empResp.getData();
        if(CollectionUtils.isNotEmpty(empList)) {
            empMap.putAll(empList.stream().collect(Collectors.toMap(EmployeeVO::getCode, Function.identity())));
        }
        if(CollectionUtils.isNotEmpty(empIds)) {
            empResp = employeeApi.getByIds(empIds);
            if(!empResp.isSuccess()) {
                logger.error("分包费用申请查询失败，根据人员id列表-{}查询人员信息失败，{}", JSONObject.toJSONString(empIds),
                        JSONObject.toJSONString(empResp, SerializerFeature.PrettyFormat));
                return CommonResponse.error("查询失败，获取人员信息失败！");
            }

            empList = empResp.getData();
            if(CollectionUtils.isNotEmpty(empList)) {
                empIdMap.putAll(empList.stream().collect(Collectors.toMap(EmployeeVO::getId, Function.identity())));
            }
        }

        //查询费用子表
        Map<Long, List<SubFeeApplyDetailEntity>> subDetailMap = detailService.getAllBySettleIds(pIds);

        //查询附件信息
        JSONObject params = new JSONObject();
        params.put("sourceIds", new ArrayList<>(pIds));
        CommonResponse<List<AttachmentVO>> attachResp = attachmentApi.queryAllBySourceIdList(params);

        if(!attachResp.isSuccess()) {
            logger.error("根据sourceId列表-{}查询对应附件信息失败，", JSONObject.toJSONString(pIds),
                    JSONObject.toJSONString(attachResp, SerializerFeature.PrettyFormat));
            return CommonResponse.error("查询失败，获取子表附件信息失败！");
        }

        List<AttachmentVO> fileData = attachResp.getData();
        Map<Long, List<AttachmentVO>> fileMap = new HashMap<>();
        fileMap.putAll(fileData.stream().collect(Collectors.groupingBy(AttachmentVO::getSourceId)));

        //查询分包合同字表
        List<Long> contractDetailIds = new ArrayList<>(subDetailMap.values().stream().flatMap(List::stream).map(SubFeeApplyDetailEntity::getInfoId).collect(Collectors.toSet()));
        Map<Long, SubContractDetailEntity> contractDetailMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(contractDetailIds)) {
            contractDetailMap = contractDetailService.getAllByIds(contractDetailIds);
        }

        EmployeeVO emp = null;
        ProjectPoolSetVO project = null;
        SupplierVO supplier = null;
        AttachmentVO attach = null;
        SubContractDetailEntity tmpDetail = null;
        for(JSONObject settle : pageList) {
            //获取工程师信息
            emp = empIdMap.get(settle.getLong("EngineerId"));
            settle.put("Engineer_Sid", emp.getSourceId());
            settle.put("Engineer", emp.getName());
            //获取审核人信息
            emp = empMap.get(settle.getString("ApprHumanCode"));
            settle.put("ApprHuman_sid", emp.getSourceId());
            settle.put("ApprHuman", emp.getName());
            //获取项目信息
            settle.put("Account_Project_Sid", projectSidMap.get(settle.getLong("projectId")));
            settle.remove("projectId");
            //供应商信息
            supplier = supplierMap.get(settle.getLong("supplierId"));
            settle.put("Company_Sid", supplier.getThirdSourceId());
            settle.put("Company_Name", supplier.getName());
            settle.remove("supplierId");

            //审核日期
            settle.put("ApprDate", DateFormatUtil.formatDate("yyyy-MM-dd", settle.getDate("ApprDate"))); //审核时间

            //子表信息
            JSONArray detailArr = new JSONArray();
            settle.put("SubDetails", detailArr);
            JSONObject detailJson = null;
            for(SubFeeApplyDetailEntity detail : subDetailMap.get(settle.getLong("YQL_SID"))) {
                tmpDetail = contractDetailMap.get(detail.getInfoId());
                detailJson = new JSONObject();
                detailJson.put("YQL_SID", detail.getId()); //益企联数据唯一标识
                detailJson.put("SpeModel", detail.getPropertyValue()); //规格型号
                detailJson.put("Unit", detail.getUnitName()); //计量单位
                detailJson.put("Number", detail.getNum().toPlainString()); //数量
                detailJson.put("MaterialPrice", null != detail.getMaterialTaxPrice() ?
                        detail.getMaterialTaxPrice().toPlainString() : BigDecimal.ZERO); //材料单价
                detailJson.put("ManPrice", null != detail.getHumanTaxPrice() ? detail.getHumanTaxPrice().toPlainString() : BigDecimal.ZERO); //人工单价
                detailJson.put("ComprePrice", detail.getCompareTaxPrice().toPlainString()); //综合单价
                detailJson.put("SumMoney", detail.getTaxMny().toPlainString()); //合价
                detailJson.put("Brand", detail.getBrandName()); //品牌
                detailJson.put("Memo", detail.getMemo()); //备注
                detailJson.put("PacketCode", null != tmpDetail ? tmpDetail.getCostCodingName() : ""); //费用包编码
                detailJson.put("SubConMoney", null != tmpDetail && null != tmpDetail.getSumTaxConMoney() ? tmpDetail.getSumTaxConMoney().toPlainString() : ""); //费用包金额
                detailJson.put("ProjectContent", null != tmpDetail ? tmpDetail.getProjectContent() : ""); //项目名称

                detailArr.add(detailJson);
            }

            //附件
            JSONArray subFileArr = new JSONArray();
            settle.put("ArchivesList", subFileArr);
            if(null != fileMap.get(settle.getLong("YQL_SID"))) {
                JSONObject subF = null;
                for(AttachmentVO file : fileMap.get(settle.getLong("YQL_SID"))) {
                    subF = new JSONObject();
                    subF.put("Attach_Name", file.getFileName()); //附件名称
                    subF.put("Attach_Extension", file.getFileName().substring(file.getFileName().indexOf("."))); //附件扩展名
                    subF.put("Attach_Type", file.getFileName().substring(file.getFileName().indexOf(".")+1)); //附件类型
                    subF.put("AttachBase64", BASE_HOST + "filepreview/" + file.getFilePath()); //附件类型
                    subF.put("YQL_SID", file.getId()); //益企联主
                    subFileArr.add(subF);
                }
            }
        }

        resp.put("records", pageList);

        return CommonResponse.success("查询成功！", resp);
    }


}
