package com.ejianc.business.zdsmaterial.sub.fee.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.sub.fee.bean.SubFeeApplyDetailEntity;
import com.ejianc.business.zdsmaterial.sub.fee.bean.SubFeeApplyEntity;
import com.ejianc.business.zdsmaterial.sub.fee.mapper.SubFeeApplyDetailMapper;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyDetailService;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyService;
import com.ejianc.business.zdsmaterial.sub.fee.vo.SubFeeApplyDetailVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包费用申请清单
 * 
 * @author generator
 * 
 */
@Service("subFeeApplyDetailService")
public class SubFeeApplyDetailServiceImpl extends BaseServiceImpl<SubFeeApplyDetailMapper, SubFeeApplyDetailEntity> implements ISubFeeApplyDetailService{

    @Autowired
    private ISubFeeApplyService applyService;

    @Override
    public Map<Long, SubFeeApplyDetailVO> getApproveDetailMap(List<Long> infoIds) {
        if(CollectionUtils.isEmpty(infoIds)){
            return new HashMap<>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("infoId", new Parameter(QueryParam.IN, infoIds));
        List<SubFeeApplyDetailEntity> list = super.queryList(param);
        List<Long> ids = list.stream().map(x->x.getApplyId()).distinct().collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(ids)){
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
            queryParam.getParams().put("applyType", new Parameter(QueryParam.EQ, PlanConstant.APPLY_TYPE_APPROVE));
            List<SubFeeApplyEntity> applyList = applyService.queryList(queryParam);
            List<Long> applyIds = applyList.stream().map(x->x.getId()).distinct().collect(Collectors.toList());
            ids.retainAll(applyIds);
        }
        list = list.stream().filter(x->ids.contains(x.getApplyId())).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(list)){
            return new HashMap<>();
        }
        Map<Long, SubFeeApplyDetailVO> map =  new HashMap<>();
        for(SubFeeApplyDetailEntity entity : list){
            SubFeeApplyDetailVO vo = new SubFeeApplyDetailVO();
            if(map.containsKey(entity.getInfoId())){
                vo = map.get(entity.getInfoId());
            }
            vo.setInfoId(entity.getInfoId());
            vo.setLastNum(ComputeUtil.safeAdd(vo.getLastNum(), entity.getNum()));
            vo.setLastMny(ComputeUtil.safeAdd(vo.getLastMny(), entity.getMny()));
            vo.setLastTaxMny(ComputeUtil.safeAdd(vo.getLastTaxMny(), entity.getTaxMny()));
            map.put(entity.getInfoId(), vo);
        }
        return map;
    }

    @Override
    public Map<Long, List<SubFeeApplyDetailEntity>> getAllBySettleIds(List<Long> pIds) {
        Map<Long, List<SubFeeApplyDetailEntity>> resp = new HashMap<>();

        QueryWrapper<SubFeeApplyDetailEntity> query = new QueryWrapper<>();
        query.in("apply_id", pIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<SubFeeApplyDetailEntity> dbList = super.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            resp = dbList.stream().collect(Collectors.groupingBy(SubFeeApplyDetailEntity::getApplyId));
        }

        return resp;
    }
}
