package com.ejianc.business.zdsmaterial.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.constants.ReferConstant;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.config.RequestConfig.Builder;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.*;
import java.util.Map.Entry;

@Component
public class MatFileUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static String baseHost;
    private static final MatFileUtil instance = new MatFileUtil();

    private MatFileUtil() {
    }

    public static MatFileUtil getInstance() {
        return instance;
    }

    public Map<String, InputStream> batchDownFileFlow(List<Long> fileIds, boolean mustSuc) {
        Map<String, InputStream> resp = new HashMap();
        String url = baseHost + "ejc-file-web/attachment/batchdownflow";
        Map<String, String> params = new HashMap();
        params.put("fileIds", StringUtils.join(fileIds, ","));
        String downloadFileStr = null;

        try {
            downloadFileStr = ReferHttpClientUtils.getAndHeader(url, params);
            this.logger.info("根据url-{}，参数-{}", url, JSONObject.toJSONString(params));
            Map<String, String> respMap = (Map)JSONObject.parseObject(downloadFileStr, new TypeReference<Map<String, String>>() {
            }, new Feature[0]);
            if (null == respMap.get("data")) {
                this.logger.error("根据附件Id下载附件为空", JSONObject.toJSONString(fileIds));
                return new HashMap();
            }

            JSONObject json = JSON.parseObject((String)respMap.get("data"));
            Iterator var9 = json.keySet().iterator();

            while(var9.hasNext()) {
                String key = (String)var9.next();
                resp.put(key, new ByteArrayInputStream(json.getBytes(key)));
            }
        } catch (Exception var11) {
            this.logger.error("根据附件Id下载附件异常-{}", JSONObject.toJSONString(fileIds), var11);
            if (mustSuc) {
                throw new BusinessException("下载附件异常，", var11);
            }
        }

        return resp;
    }

    public Map<String, List<AttachmentVO>> handleReqFile(MultipartHttpServletRequest multipartRequest, Map<String, String> fileSourceTypeMapping, String billType, String authority, String sourceId) {
        Map<String, List<AttachmentVO>> resp = new HashMap();
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        Map<String, Map<String, Map<String, InputStream>>> fileMaps = new HashMap();
        HashMap fileItemMap = null;

        try {
            Iterator var10 = fileMap.entrySet().iterator();

            while(var10.hasNext()) {
                Entry<String, MultipartFile> entity = (Entry)var10.next();
                MultipartFile mf = (MultipartFile)entity.getValue();
                String originalFilename = mf.getOriginalFilename();
                if (null == fileMaps.get(fileSourceTypeMapping.get(originalFilename))) {
                    fileMaps.put(fileSourceTypeMapping.get(originalFilename), new HashMap());
                }

                fileItemMap = new HashMap();
                fileItemMap.put(originalFilename, mf.getInputStream());
                ((Map)fileMaps.get(fileSourceTypeMapping.get(originalFilename))).put(originalFilename, fileItemMap);
            }

            fileMaps.keySet().forEach((sourceType) -> {
                List<AttachmentVO> attachs = this.upFile(sourceType, sourceId, billType, (Map)fileMaps.get(sourceType), authority);
                if (CollectionUtils.isNotEmpty(attachs)) {
                    resp.put(sourceType, attachs);
                }

            });
            return resp;
        } catch (Exception var14) {
            throw new BusinessException("将请求中附件信息上传至文件中心异常: ", var14);
        }
    }

    public List<AttachmentVO> upFile(String sourceType, String sourceId, String billType, Map<String, Map<String, InputStream>> files, String authority) {
        this.logger.info("获取认证信息--" + authority);
        List<AttachmentVO> attachs = new ArrayList();
        if (StringUtils.isNotBlank(authority)) {
            InvocationInfoProxy.setExtendAttribute("authority", authority);
            InvocationInfoProxy.setParameter(ReferConstant.HEAD_authority, authority);
            Map<String, String> params = new HashMap();
            if (StringUtils.isNotBlank(sourceId)) {
                params.put("sourceId", sourceId);
            }

            if (StringUtils.isNotBlank(sourceType)) {
                params.put("sourceType", sourceType);
            }

            params.put("billType", billType);
            Map<String, String> headers = new HashMap();
            headers.put("authority", authority);

            try {
                this.logger.info("文件上传参数：params-{}, headers-{}, 文件数量-{}", new Object[]{params, headers, files.size()});
                String fileUploadRespStr = HttpTookit.postFiles(baseHost + "ejc-file-web/attachment/upload", params, headers, files, 10000, 10000);
                this.logger.info("文件上传响应结果：{}", fileUploadRespStr);
                CommonResponse<List<AttachmentVO>> attachmentResp = (CommonResponse)JSONObject.parseObject(fileUploadRespStr, CommonResponse.class);
                this.logger.info("上传文件返回信息: {}", JSONObject.toJSONString(attachmentResp));
                if (!attachmentResp.isSuccess()) {
                    this.logger.error("保存模板文件失败sourceId-{}, sourceType-{}, billType-{}, 原因：{}", new Object[]{sourceId, sourceType, billType, attachmentResp.getMsg()});
                    return null;
                }

                attachs = JSONObject.parseArray(JSONObject.toJSONString(attachmentResp.getData()), AttachmentVO.class);
            } catch (Exception var11) {
                this.logger.error("保存模板文件失败sourceId-{}, sourceType-{}, billType-{}, 原因：", new Object[]{sourceId, sourceType, billType, var11});
                return null;
            }

            this.logger.info("模板文件保存成功：{}", JSONObject.toJSONString(attachs));
        }

        return (List)attachs;
    }

    public static String postFile(String url, Map<String, String> params, Map<String, String> headers, InputStream inputStream, String fileName) throws Exception {
        String charset = "UTF-8";
        HttpClient client = null;
        HttpPost post = new HttpPost(url);
        HttpServletRequest request = null;
        String result = "";
        Integer connTimeout = 10000;
        Integer readTimeout = 10000;

        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(Charset.forName("UTF-8")).addBinaryBody("file", inputStream, ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8"), fileName);
            Iterator var13 = params.keySet().iterator();

            while(var13.hasNext()) {
                String key = (String)var13.next();
                builder.addPart(key, new StringBody((String)params.get(key), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8")));
            }

            HttpEntity entity = builder.build();
            post.setEntity(entity);
            Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout);
            }

            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout);
            }

            post.setConfig(customReqConf.build());
            if (null != headers) {
                String key = null;
                Iterator it = headers.keySet().iterator();

                while(it.hasNext()) {
                    key = (String)it.next();
                    post.addHeader(key, (String)headers.get(key));
                }
            } else {
                request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                post.addHeader("authority", request.getHeader("authority"));
                post.addHeader("ejc-token", request.getHeader("ejc-token"));
            }

            HttpResponse res;
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
                res = client.execute(post);
            } else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(128);
                cm.setDefaultMaxPerRoute(128);
                client = HttpClients.custom().setConnectionManager(cm).build();
                res = client.execute(post);
            }

            result = IOUtils.toString(res.getEntity().getContent(), charset);
        } finally {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }

        }

        return result;
    }

    public String getBaseHost() {
        return baseHost;
    }

    @Value("${common.env.base-host}")
    public void setBaseHost(String baseHost) {
        MatFileUtil.baseHost = baseHost;
    }
}
