package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceEntity;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceService;
import com.ejianc.business.zdsmaterial.erp.vo.ErpInvoiceVO;
import com.ejianc.business.zdsmaterial.util.DateUtil;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 领航发票实体
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("erpInvoice")
public class ErpInvoiceController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IErpInvoiceService service;

    @Autowired
    private IErpInvoiceDetailService detailService;

    private final String INVOICE_ERP_REQ_URL = "/cefoc/yql/getMEBillList";

    private final String MAT_INVOICE_QUOTE_URL = "/cefoc/yql/getMEBillSubList";
    private final String SUB_INVOICE_QUOTE_URL = "/cefoc/yql/getSubBillSubList";

    /**
     *
     */
    private final String INVOICE_ERP_CHECK_AND_GET_NORMAL_URL = "/cefoc/yql/YQLCheckFP";

    /**
     *
     */
    private final String INVOICE_ERP_CHECK_AND_GET_SPECIAL_URL = "/cefoc/yql/YQLCheckZYFP";

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ErpInvoiceVO> queryDetail(Long id) {
        ErpInvoiceEntity entity = service.selectById(id);
        ErpInvoiceVO vo = BeanMapper.map(entity, ErpInvoiceVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ErpInvoiceVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("number");
        fuzzyFields.add("saleTaxNumber");
        fuzzyFields.add("saleName");
        fuzzyFields.add("invoiceTitle");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(param.getParams().containsKey("usedFlag")) {
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("AND");

            ComplexParam c2 = new ComplexParam();
            c2.setLogic("OR");
            c2.getParams().put("quoteFlag", new Parameter(QueryParam.EQ, param.getParams().get("usedFlag").getValue()));

            ComplexParam c3 = new ComplexParam();
            c3.setLogic("OR");
            c2.getParams().put("erpQuoteFlag", new Parameter(QueryParam.EQ, param.getParams().get("usedFlag").getValue()));
            c1.getComplexParams().add(c2);
            c1.getComplexParams().add(c3);
            param.getComplexParams().add(c1);

            param.getParams().remove("usedFlag");
        }

        IPage<ErpInvoiceEntity> page = service.queryPage(param,false);
        IPage<ErpInvoiceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ErpInvoiceVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("number");
        fuzzyFields.add("saleTaxNumber");
        fuzzyFields.add("saleName");
        fuzzyFields.add("invoiceTitle");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        if(param.getParams().containsKey("usedFlag")) {
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("AND");

            ComplexParam c2 = new ComplexParam();
            c2.setLogic("OR");
            c2.getParams().put("quoteFlag", new Parameter(QueryParam.EQ, param.getParams().get("usedFlag").getValue()));

            ComplexParam c3 = new ComplexParam();
            c3.setLogic("OR");
            c2.getParams().put("erpQuoteFlag", new Parameter(QueryParam.EQ, param.getParams().get("usedFlag").getValue()));
            c1.getComplexParams().add(c2);
            c1.getComplexParams().add(c3);
            param.getComplexParams().add(c1);

            param.getParams().remove("usedFlag");
        }

        param.setPageIndex(1);
        param.setPageSize(-1);
        List<ErpInvoiceEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ErpInvoice-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refErpInvoiceData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ErpInvoiceVO>> refErpInvoiceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        logger.error("refErpInvoiceData condition " + condition);
        logger.error("refErpInvoiceData searchText " + searchText);
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("statusName");
        param.getFuzzyFields().add("typeName");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("number");
        param.getFuzzyFields().add("saleTaxNumber");
        param.getFuzzyFields().add("saleName");
        param.getFuzzyFields().add("invoiceTitle");

        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);

        if(StringUtils.isNotBlank(searchText)) {
            if (StringUtils.isNotBlank(condition)) {
                JSONObject conJson = JSONObject.parseObject(condition);
                conJson.put("number", searchText);
                condition = conJson.toJSONString();
            }
        }
        if(StringUtils.isNotBlank(searchObject)) {
            JSONObject searchJson = JSONObject.parseObject(searchObject);

            if(searchJson.containsKey("usedFlag")) {
                if(PlanConstant.STRING_YES.equals(searchJson.get("usedFlag"))) {
                    param.getParams().put("quoteFlag", new Parameter(QueryParam.SQL, " (quote_flag = '1' or erp_quote_flag = '1')"));
                } else {
                    param.getParams().put("quoteFlag", new Parameter(QueryParam.SQL, " (quote_flag = '0' or erp_quote_flag = '0')"));
                }

                searchJson.remove("usedFlag");
            }
            if(!searchJson.isEmpty()) {
                param.setSearchObject(JSONObject.toJSONString(searchJson));
            }
        }

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("invoice_title", new Parameter(QueryParam.SQL, " invoice_title is not null"));
//        param.getParams().put("quoteFlag", new Parameter(QueryParam.EQ, PlanConstant.STRING_NO)); //查询未被引用的发票
//        param.getParams().put("erpQuoteFlag", new Parameter(QueryParam.EQ, PlanConstant.STRING_NO)); //查询ERP未被引用的发票
        if(StringUtils.isNotEmpty(condition)) {
            JSONObject _con = JSONObject.parseObject(condition);
            if(StringUtils.isNotBlank(_con.getString("saleName"))) {
                param.getParams().put("saleName", new Parameter(QueryParam.EQ, _con.getString("saleName")));
            }
            if(StringUtils.isNotBlank(_con.getString("number"))) {
                param.getParams().put("number", new Parameter(QueryParam.EQ, _con.getString("number")));
            } else {
                return CommonResponse.error("无发票号查询时，数据为空");
            }

            if(_con.containsKey("usedFlag")) {
                if(PlanConstant.STRING_YES.equals(_con.get("usedFlag"))) {
                    param.getParams().put("quoteFlag", new Parameter(QueryParam.SQL, " (quote_flag = '1' or erp_quote_flag = '1')"));
                } else {
                    param.getParams().put("quoteFlag", new Parameter(QueryParam.SQL, " (quote_flag = '0' or erp_quote_flag = '0')"));
                }
                param.getParams().remove("usedFlag");
            }
        } else {
            return CommonResponse.error("无发票号查询时，数据为空");
        }

        param.getParams().put("source_id", new Parameter(QueryParam.SQL, " source_id is not null "));
        IPage<ErpInvoiceEntity> page = service.queryPage(param,false);
        IPage<ErpInvoiceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ErpInvoiceVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    @PostMapping(value = "/zdsInvoiceSync")
    public CommonResponse<String> zdsInvoiceSync(@RequestBody JSONObject reqParam) {
        logger.info("*********************中电四-领航发票信息同步任务 开始*********************");
        Integer pageNum = null != reqParam.get("pageNum") ? reqParam.getInteger("pageNum") : 0;
        Integer pageSize = null != reqParam.get("pageSize") ? reqParam.getInteger("pageSize") : Integer.valueOf(ZDSInterfaceCommonUtil.getErpDataBatchSize());
        JSONObject param = new JSONObject();
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + INVOICE_ERP_REQ_URL;
        boolean hasNext = true;
        Map<String, String> headers = null;

        //请求连续失败次数，连续两次请求失败时 任务终止
        Integer reqErrorTimes = null != reqParam.get("reqErrorTimes") ? reqParam.getInteger("reqErrorTimes") : 0;
        reqParam.remove("reqErrorTimes");

        String reqDateStr = null;
        String startDateStr = null;
        String endDateStr = null;
        if (null != reqParam.get("startDate")) {
            startDateStr = reqParam.getString("startDate");
            endDateStr = reqParam.getString("endDate");
        } else {
            //同步前两天（含当天）的数据
            startDateStr = DateFormatUtil.formatDate("yyyy-MM-dd", DateUtil.addDays(new Date(), -2)) + " 00:00:00";
            endDateStr = DateFormatUtil.formatDate("yyyy-MM-dd", new Date()) + " 23:59:59";
        }
        param.put("BeginDateTime", startDateStr);
        param.put("EndDateTime", endDateStr);

        try {
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            param.put("PageSize", pageSize);
            JSONObject reqJson = null;
            JSONArray pageData =null;

            param.put("PageNum", ++pageNum);
            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param),
                    headers, ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);

            reqJson = JSONObject.parseObject(reqResp);

            logger.info("请求中电四获取领航发票：请求地址-{},参数-{},header-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
            if("ok".equals(reqJson.getString("status"))) {
                logger.info("中电四领航发票同步,请求成功，共{}条数据",reqJson.getString("allCount"));
                handleErpPageData(reqJson);
            } else {
                logger.error("请求中电四获取领航发票结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
            }

        } catch (Exception e) {
            logger.error("获取中电四领航发票信息异常, 请求地址：{}, 请求参数：{}", reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat));
            logger.error("获取中电四领航发票信息异常", e);

            reqErrorTimes++;
            if(reqErrorTimes >= 3) {
                return CommonResponse.error("同步中电四领航发票信息异常");
            }
            try {
                logger.info("同步中电四领航发票异常，10s后重试.........,当前已同步{}数据",param.getInteger("PageNum")-1);
                //休息5s
                Thread.sleep(10000);
                param.put("pageSize", param.getInteger("PageSize"));
                param.put("pageNum", param.getInteger("PageNum")-1);
                param.put("reqErrorTimes", reqErrorTimes);
                return zdsInvoiceSync(param);
            } catch (Exception e1) {
                logger.error("重启中电四领航发票同步接口异常,", e1);
                return CommonResponse.error("同步中电四领航发票信息异常");
            }
        }

        logger.info("*********************中电四-领航发票信息同步任务 结束*********************");
        return CommonResponse.success("中电四领航发票同步完成！");
    }

    @Transactional(rollbackFor = Exception.class)
    public void handleErpPageData(JSONObject dataJson) {
        JSONObject tmp = null;
        JSONObject detailTmp = null;
        ErpInvoiceEntity tmpEntity = null;
        ErpInvoiceDetailEntity tmpDetailEntity = null;
        Map<String, ErpInvoiceEntity> dataMap = new HashMap<>();

        List<ErpInvoiceEntity> saveList = new ArrayList<>();
        List<ErpInvoiceDetailEntity> saveDetailList = new ArrayList<>();

        JSONArray pageData = dataJson.getJSONArray("MEBillList");
        logger.info("本次待处理发票主表数据：{}条", pageData.size());
        if(pageData.size() == 0) {
            logger.info("本次待处理发票主表数据为空，任务执行结束。。。。");
            return;
        }
        List<String> invoiceNumList = new ArrayList<>();
//        Map<number,sourceId>
        Map<String, String> numSourceMap = new HashMap<>();
        for(Object obj : pageData) {
            tmp = (JSONObject) obj;
            tmpEntity = new ErpInvoiceEntity();
            tmpEntity.setSourceId(tmp.getString("C_PS_InvoiceInfoOID").toLowerCase()); //ERP主键
            tmpEntity.setTypeCode(tmp.getString("FPZLDM"));//发票种类标识
            tmpEntity.setTypeName(tmp.getString("FPZLDM_Value"));////发票种类名称
            tmpEntity.setStatusCode(tmp.getString("FPZTDM"));//发票状态代码
            tmpEntity.setStatusName(tmp.getString("FPZTDM_Value"));//发票状态名称
            tmpEntity.setCode(tmp.getString("FPDM"));//发票代码
            tmpEntity.setNumber(tmp.getString("FPHM"));//发票号码
            tmpEntity.setMny(tmp.getBigDecimal("JE"));//金额
            tmpEntity.setSaleName(tmp.getString("XFMC"));//消方名称
            tmpEntity.setSaleTaxNumber(tmp.getString("XFSBH"));//销方税号
            tmpEntity.setMemo(tmp.getString("BZ"));//备注
            tmpEntity.setInvoiceTitle(tmp.getString("GFMC"));//发票抬头
            tmpEntity.setId(IdWorker.getId());
            tmpEntity.setErpQuoteFlag(PlanConstant.STRING_NO);//未引用
            tmpEntity.setQuoteFlag(PlanConstant.STRING_NO); //未引用
            try {
                if(StringUtils.isNotBlank(tmp.getString("KPRQ"))) {
                    tmpEntity.setInvoiceDate(DateFormatUtil.parseDate("yyyy-MM-dd HH:mm:ss", tmp.getString("KPRQ").replace("T", " "))); //开票日期
                }
            } catch (Exception e) {
                logger.info("格式化中电四发票时间出错！{}", tmp.toJSONString(), e);
            }

            if(StringUtils.isNotBlank(tmpEntity.getNumber()) && !invoiceNumList.contains(tmpEntity.getNumber())) {
                invoiceNumList.add(tmpEntity.getNumber());
            }
            numSourceMap.put(tmpEntity.getNumber(), tmpEntity.getSourceId());

            dataMap.put(tmpEntity.getSourceId(), tmpEntity);
        }

        JSONArray detailArray = dataJson.getJSONArray("InvoiceGoodsList"); //子表
        if(null != detailArray && detailArray.size() > 0) {
            for(Object detailObj : detailArray) {
                detailTmp = (JSONObject) detailObj;
                tmpEntity = dataMap.get(detailTmp.getString("C_PS_InvoiceInfo_FK").toLowerCase());
                if(null != tmpEntity) {
                    tmpDetailEntity = new ErpInvoiceDetailEntity();
                    tmpDetailEntity.setPid(tmpEntity.getId()); //主表主键
                    tmpDetailEntity.setInvoiceSid(detailTmp.getString("C_PS_InvoiceInfo_FK").toLowerCase()); //主表ERP主键
                    tmpDetailEntity.setDetailName(detailTmp.getString("SPMC"));//商品名称
                    tmpDetailEntity.setDetailSpec(detailTmp.getString("GGXH"));//商品规格型号
                    tmpDetailEntity.setDetailUnitName(detailTmp.getString("JLDW"));//商品计量单位
                    tmpDetailEntity.setDetailNum(detailTmp.getBigDecimal("SL"));//商品数量
                    tmpDetailEntity.setDetailMny(detailTmp.getBigDecimal("SPJE"));//金额
                    tmpDetailEntity.setDetailTax(detailTmp.getBigDecimal("SPSE"));//商品税额
                    tmpDetailEntity.setDetailRate(detailTmp.getBigDecimal("SLV"));//商品税率
                    tmpDetailEntity.setInvoiceMny(detailTmp.getBigDecimal("FPJE"));//发票金额

                    tmpEntity.getDetailList().add(tmpDetailEntity);
                }
            }
        }

        List<ErpInvoiceEntity> dbListBySourceId = service.getAllBySourceIds(new ArrayList<>(dataMap.keySet()));
        logger.info("本次ERP 发票同步，SID匹配在库发票数量：{}", dbListBySourceId.size());
        if(CollectionUtils.isNotEmpty(dbListBySourceId)) {
            //更新列表
            for(ErpInvoiceEntity dbEntity : dbListBySourceId) { //更新状态
                if(StringUtils.isBlank(dbEntity.getSourceId())){
                    logger.error("发票:id-{} sourceId为空，跳过更新", dbEntity.getId());
                    continue;
                }
                tmpEntity = dataMap.get(dbEntity.getSourceId().toLowerCase());
                if(null == tmpEntity) {
                    logger.error("*******新同步发票 未匹配到SID为:{}的发票，跳过更新~！！！！！！！");
                    continue;
                }
                dbEntity.setStatusCode(tmpEntity.getStatusCode());
                dbEntity.setStatusName(tmpEntity.getStatusName());
                dbEntity.setInvoiceDate(tmpEntity.getInvoiceDate()); //开票日期

                dataMap.remove(tmpEntity.getSourceId());
                saveList.add(dbEntity);
                if(invoiceNumList.contains(dbEntity.getNumber())) {
                    invoiceNumList.remove(dbEntity.getNumber());
                }
            }
        }

        if(CollectionUtils.isNotEmpty(invoiceNumList)) {
            List<ErpInvoiceEntity> dbListByNum = service.getAllByInvoiceNums(invoiceNumList);
            logger.info("本次ERP 发票同步，发票号码 匹配在库发票数量：{}", dbListByNum.size());
            if(CollectionUtils.isNotEmpty(dbListByNum)) {
                for(ErpInvoiceEntity dbEntity : dbListByNum) {
                    tmpEntity = dataMap.get(StringUtils.isNotBlank(dbEntity.getSourceId()) ? dbEntity.getSourceId() : numSourceMap.get(dbEntity.getNumber()));
                    if(null == tmpEntity) {
                        logger.info("发票号码：{}, 发票SID：{}", dbEntity.getNumber(), dbEntity.getSourceId());
                        continue;
                    }

                    if(StringUtils.isBlank(dbEntity.getSourceId()) && CollectionUtils.isNotEmpty(tmpEntity.getDetailList())) {
                        //针对先同步到引用记录【只有发票简单信息，无字表明细】 后同步到发票的情况，此时保存发票明细
                        tmpEntity.getDetailList().forEach(detail -> detail.setPid(dbEntity.getId()));
                        saveDetailList.addAll(tmpEntity.getDetailList());
                    }

                    dbEntity.setInvoiceDate(tmpEntity.getInvoiceDate()); //开票日期
                    dbEntity.setSourceId(tmpEntity.getSourceId()); //ERP主键
                    dbEntity.setTypeCode(tmpEntity.getTypeCode());//发票种类标识
                    dbEntity.setTypeName(tmpEntity.getTypeName());////发票种类名称
                    dbEntity.setStatusCode(tmpEntity.getStatusCode());//发票状态代码
                    dbEntity.setStatusName(tmpEntity.getStatusName());//发票状态名称
                    dbEntity.setCode(tmpEntity.getCode());//发票代码
                    dbEntity.setNumber(tmpEntity.getNumber());//发票号码
                    dbEntity.setMny(tmpEntity.getMny());//金额
                    dbEntity.setSaleName(tmpEntity.getSaleName());//消方名称
                    dbEntity.setSaleTaxNumber(tmpEntity.getSaleTaxNumber());//销方税号
                    dbEntity.setMemo(tmpEntity.getMemo());//备注
                    dbEntity.setInvoiceTitle(tmpEntity.getInvoiceTitle());//发票抬头
                    dbEntity.setQuoteFlag(PlanConstant.STRING_YES); //直接标记为已引用

                    dataMap.remove(tmpEntity.getSourceId());
                    saveList.add(dbEntity);
                }
            }
        }

        logger.info("本次ERP 发票同步，新增发票数量：{}", dataMap.keySet().size());
        if(!dataMap.isEmpty()) {
            for(ErpInvoiceEntity d : dataMap.values()) {
                saveList.add(d);
                saveDetailList.addAll(d.getDetailList());
            }
        }

        logger.info("本次保存发票主表数据-{}条", saveList.size());
        if(CollectionUtils.isNotEmpty(saveList)) {
            service.saveOrUpdateBatch(saveList, saveList.size(), false);
        }

        logger.info("本次保存发票子表数据-{}条", saveDetailList.size());
        if(CollectionUtils.isNotEmpty(saveDetailList)) {
            detailService.saveOrUpdateBatch(saveDetailList, saveDetailList.size(), false);
        }
    }

    /**
     * 同步已引用的采购发票
     *
     * @return
     */
    @GetMapping(value = "syncMatUsedInvoice")
    public CommonResponse<String> syncMatUsedInvoice(
            @RequestParam(required = false) String beginDate,
            @RequestParam(required = false) String endDate,
            @RequestParam(required = false) Integer pageSize,
            @RequestParam(required = false) Integer pageNum) {
        return syncUsedInvoice(beginDate, endDate, pageSize, pageNum, MAT_INVOICE_QUOTE_URL, 0);
    }

    /**
     * 同步已引用的采购发票
     *
     * @return
     */
    @GetMapping(value = "syncSubUsedInvoice")
    public CommonResponse<String> syncSubUsedInvoice(
            @RequestParam(required = false) String beginDate,
            @RequestParam(required = false) String endDate,
            @RequestParam(required = false) Integer pageSize,
            @RequestParam(required = false) Integer pageNum) {
        return syncUsedInvoice(beginDate, endDate, pageSize, pageNum, SUB_INVOICE_QUOTE_URL, 0);
    }

    private CommonResponse<String> syncUsedInvoice(String beginDate, String endDate, Integer pageSize, Integer pageNum, String reqUrl, Integer reqErrorTimes) {
        logger.info("*********************中电四-引用发票信息同步任务 开始*********************");

        String url = ZDSInterfaceCommonUtil.getErpReqHost()+ reqUrl;
        Map<String, String> headers = null;
        JSONObject param = new JSONObject();
        param.put("BeginDateTime", StringUtils.isNotBlank(beginDate) ? beginDate :
                DateFormatUtil.formatDate("yyyy-MM-dd", DateUtil.addDays(new Date(), -1)) + " 00:00:00");
        param.put("EndDateTime", StringUtils.isNotBlank(endDate) ? endDate :
                DateFormatUtil.formatDate("yyyy-MM-dd", new Date()) + " 23:59:59");
        Integer PageSize = null != pageSize ? pageSize : 100;
        Integer PageNum = null != pageNum ? pageNum : 1;

        try {
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            param.put("PageSize", PageSize);
            JSONObject reqJson = null;

            param.put("PageNum", PageNum);
            String reqResp = HttpTookit.postByJson(url, JSONObject.toJSONString(param),
                    headers, ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);

            reqJson = JSONObject.parseObject(reqResp);
            reqErrorTimes = 0;

            if("ok".equals(reqJson.getString("status"))) {
                logger.info("引用发票信息同步任务同步,请求成功，共{}条数据",reqJson.getString("allCount"));
                handleErpUsedInvoiceData(reqJson);
            } else {
                logger.error("请求引用发票信息结果返回失败：请求地址-{},参数-{},header-{},结果-{}", url, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
            }

        } catch (Exception e) {
            logger.error("获取引用发票信息信息异常, 请求地址：{}, 请求参数：{}", url, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat), e);

            reqErrorTimes++;
            if(reqErrorTimes >= 3) {
                return CommonResponse.error("同步引用发票信息异常");
            }
            try {
                logger.info("同步引用发票信息异常，5s后重试.........,当前已同步{}数据",param.getInteger("PageNum")-1);
                //休息5s
                Thread.sleep(5000);
                param.put("reqErrorTimes", reqErrorTimes);
                return syncUsedInvoice(beginDate, endDate, pageSize, pageNum, reqUrl, reqErrorTimes);
            } catch (Exception e1) {
                logger.error("重启引用发票信息同步接口异常,", e1);
                return CommonResponse.error("同步引用发票信息异常");
            }
        }

        logger.info("*********************中电四-引用发票信息同步任务 结束*********************");
        return CommonResponse.success("引用发票信息同步成功！");
    }

    @Transactional(rollbackFor = Exception.class)
    public void handleErpUsedInvoiceData(JSONObject dataJson) {
        JSONObject tmp = null;
        JSONArray pageData = dataJson.getJSONArray("data");
        List<ErpInvoiceEntity> updateList = new ArrayList<>();
        List<ErpInvoiceEntity> saveList = new ArrayList<>();
        logger.info("本次待处理ERP引用发票主表数据：{}条", pageData.size());
        if(pageData.size() == 0) {
            logger.info("本次待处理ERP引用发票主表数据为空，任务执行结束。。。。");
            return;
        }
        Map<String, JSONObject> invoiceMap = new HashMap<>();
        for(Object obj : pageData) {
            tmp = (JSONObject) obj;
            invoiceMap.put(tmp.getString("InvoiceHM"), tmp);
        }

        ErpInvoiceEntity tmpInvoice = null;
        if(!invoiceMap.isEmpty()) {
            List<ErpInvoiceEntity> dbInvoiceList = service.getAllByInvoiceNums(new ArrayList<>(invoiceMap.keySet()));
            for(ErpInvoiceEntity dbItem : dbInvoiceList) {
                tmp = invoiceMap.get(dbItem.getNumber());
                if(null != tmp && !PlanConstant.STRING_YES.equals(dbItem.getErpQuoteFlag())) {
                    dbItem.setErpQuoteFlag(PlanConstant.STRING_YES);
                    dbItem.setGoodsName(tmp.getString("GoodsName"));
                    dbItem.setErpCreateTime(tmp.getString("SYS_Created"));
                    dbItem.setErpRegisterName(tmp.getString("Register_Name"));
                    dbItem.setErpQuoteBillCode(tmp.getString("Ma_id"));
                    invoiceMap.remove(dbItem.getNumber());
                    updateList.add(dbItem);
                }
            }
        }

        if(!invoiceMap.isEmpty()) {
            //针对发票未同步至EL平台，但引用记录同步过来的情况
            for(JSONObject tmpInvoiceJson : invoiceMap.values()) {
                tmpInvoice = new ErpInvoiceEntity();
                tmpInvoice.setErpQuoteFlag(PlanConstant.STRING_YES);
                tmpInvoice.setGoodsName(tmpInvoiceJson.getString("GoodsName"));
                tmpInvoice.setErpCreateTime(tmpInvoiceJson.getString("SYS_Created"));
                tmpInvoice.setErpRegisterName(tmpInvoiceJson.getString("Register_Name"));
                tmpInvoice.setNumber(tmpInvoiceJson.getString("InvoiceHM"));
                tmpInvoice.setInvoiceTitle(tmpInvoiceJson.getString("InvoiceTT"));
                tmpInvoice.setCode(tmpInvoiceJson.getString("InvoiceDM"));
                tmpInvoice.setErpQuoteBillCode(tmpInvoiceJson.getString("Ma_id"));
                saveList.add(tmpInvoice);
            }
        }

        logger.info("本次同步引用发票，更新数量：{}条", updateList.size());
        if(CollectionUtils.isNotEmpty(updateList)) {
            service.saveOrUpdateBatch(updateList, updateList.size(), false);
        }

        logger.info("本次同步引用发票，保存数量：{}条", saveList.size());
        if(CollectionUtils.isNotEmpty(saveList)) {
            service.saveOrUpdateBatch(saveList, saveList.size(), false);
        }

    }

    @PostMapping(value = "synSingleInvoice")
    public CommonResponse<IPage<ErpInvoiceVO>> synSingleInvoice(@RequestBody JSONObject paramJson) {

        ErpInvoiceVO param = BeanMapper.map(paramJson, ErpInvoiceVO.class);

        //1、验证参数
        if(StringUtils.isBlank(param.getNumber())) {
            return CommonResponse.error("发票号码不能为空");
        }
        if(StringUtils.isBlank(param.getTypeCode())) {
            return CommonResponse.error("发票类型不能为空");
        }
        if(null == param.getInvoiceDate()) {
            return CommonResponse.error("开票日期不能为空");
        }
        if(StringUtils.isBlank(param.getSyncInvoiceType())) {
            return CommonResponse.error("查验发票类别不能为空");
        }
        if("c".equals(param.getTypeCode())) {
            if(StringUtils.isBlank(param.getCode())) {
                return CommonResponse.error("发票代码不能为空");
            }
            if(PlanConstant.STRING_YES.equals(param.getSyncInvoiceType()) && null == param.getMny()) {
                return CommonResponse.error("发票金额(无税)不能为空");
            }
        } else {
            if(null == param.getMny()) {
                return CommonResponse.error("发票金额(无税)不能为空");
            }
            if(null == param.getTax()) {
                return CommonResponse.error("发票税额不能为空");
            }
        }

        //2、调用航信发票查验接口、入库
        ErpInvoiceVO invoice = checkAndGetErpInvoice(param, paramJson.getString("reqUrl"));
        if(StringUtils.isNotBlank(invoice.getCheckErrInfo())) {
            return CommonResponse.error(invoice.getCheckErrInfo());
        }

        //4、返回发票同步结果
        IPage<ErpInvoiceVO> pageData = new Page<>(null != invoice ? 1 : 0, 10, null != invoice ? 1 : 0);
        if(null != invoice) {
            pageData.setRecords(Collections.singletonList(invoice));
        }

        return CommonResponse.success(pageData);
    }

    private ErpInvoiceVO checkAndGetErpInvoice(ErpInvoiceVO param, String reqErpUrl) {
        ErpInvoiceVO resp = new ErpInvoiceVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        JSONObject reqJson = new JSONObject();
        try {

            if("c".equals(param.getTypeCode())) {
                //增值税普通发票，查询需要参数：发票代码，发票号码，开票日期
                //增值税专用发票，查询需要参数：发票代码，发票号码，开票日期，无税金额
                reqJson.put("FPDM", param.getCode());
                reqJson.put("CKFPType", "0");
                reqJson.put("CheckCode", param.getCheckCode());
                if(PlanConstant.STRING_YES.equals(param.getSyncInvoiceType())) {
                    reqJson.put("JE", param.getMny().toPlainString());
                }
            } else {
                //增值税普通全电发票不需要传发票代码，需要传发票号码，开票日期，不含税金额和税额
                //增值税专用全电发票不需要传发票代码，需要传发票号码，开票日期，不含税金额和税额
                reqJson.put("CKFPType", "1");
                reqJson.put("JE", param.getMny().toPlainString());
                reqJson.put("SE", param.getTax().toPlainString());
            }

            reqJson.put("KPRQ",sdf.format(param.getInvoiceDate()));
            reqJson.put("FPHM", param.getNumber());

            Map<String, String> headers = ZDSInterfaceCommonUtil.getErpHeaders();
            String url = ZDSInterfaceCommonUtil.getErpReqHost()+ (StringUtils.isNotBlank(reqErpUrl) ? reqErpUrl : PlanConstant.STRING_NO.equals(param.getSyncInvoiceType()) ? INVOICE_ERP_CHECK_AND_GET_NORMAL_URL : INVOICE_ERP_CHECK_AND_GET_SPECIAL_URL);
            headers.put("Content-Type", "application/json;charset=UTF-8");

            String reqResp = HttpTookit.postByJson(url, JSONObject.toJSONString(reqJson),
                    headers, ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);
            logger.info("请求中电四获取领航发票查验：请求地址-{},参数-{},header-{},结果: {}", url, JSONObject.toJSONString(reqJson), JSONObject.toJSONString(headers), reqResp);

            if(reqResp.contains("查验失败")) {
                Integer start = reqResp.indexOf("查验失败");
                resp.setCheckErrInfo(reqResp.substring(reqResp.indexOf("查验失败"), reqResp.indexOf("\"", start)));
                return resp;
            }
            JSONObject reqRespJson = JSONObject.parseObject(reqResp);
            if("ok".equals(reqRespJson.getString("status"))) {
                if("0".equals(reqRespJson.getString("checkResult"))) {
                    resp.setCheckErrInfo(reqRespJson.getString("info"));
                    return resp;
                }
                resp = saveCheckedInvoiceData(reqRespJson);
            } else {
                logger.error("请求中电四获取领航发票查验失败：请求地址-{},参数-{},header-{},结果-{}", url, JSONObject.toJSONString(reqJson), JSONObject.toJSONString(headers), reqResp);

                if(StringUtils.isBlank(reqRespJson.getString("Message")) || reqRespJson.getString("Message").contains("出现错误")) {
                    resp.setCheckErrInfo("查验发票失败，请重试！");
                } else {
                    resp.setCheckErrInfo(reqRespJson.getString("Message"));
                }
            }

        } catch (Exception e) {
            logger.error("根据发票信息:[{}]获取查验发票异常", JSONObject.toJSONString(reqJson));
            logger.error("根据发票信息获取查验发票异常: ", e);
            resp.setCheckErrInfo("发票查验失败");
        }

        return resp;
    }

    private ErpInvoiceVO saveCheckedInvoiceData(JSONObject reqJson) {
        ErpInvoiceVO resp=null;
        JSONObject tmp = JSONArray.parseArray(reqJson.getString("InvoiceData")).getJSONObject(0);

        ErpInvoiceEntity tmpEntity = new ErpInvoiceEntity();
        tmpEntity.setSourceId(tmp.getString("C_PS_InvoiceInfoOID")); //ERP主键
        tmpEntity.setTypeCode(tmp.getString("FPZLDM"));//发票种类标识
        tmpEntity.setTypeName(tmp.getString("FPZLDM_Value"));////发票种类名称
        tmpEntity.setStatusCode("0");//发票状态代码
        tmpEntity.setStatusName("正常");//发票状态名称
        tmpEntity.setCode(tmp.getString("FPDM"));//发票代码
        tmpEntity.setNumber(tmp.getString("FPHM"));//发票号码
        tmpEntity.setMny(tmp.getBigDecimal("JE"));//金额
        tmpEntity.setMny(tmp.getBigDecimal("SE"));//金额
        tmpEntity.setSaleName(tmp.getString("XFMC"));//消方名称
        tmpEntity.setSaleTaxNumber(tmp.getString("XFSBH"));//销方税号
        tmpEntity.setMemo(tmp.getString("BZ"));//备注
        tmpEntity.setInvoiceTitle(tmp.getString("GFMC"));//发票抬头
        tmpEntity.setId(IdWorker.getId());
        tmpEntity.setErpQuoteFlag(PlanConstant.STRING_NO);//未引用
        tmpEntity.setQuoteFlag(PlanConstant.STRING_NO); //未引用
        try {
            if(StringUtils.isNotBlank(tmp.getString("KPRQ"))) {
                tmpEntity.setInvoiceDate(DateFormatUtil.parseDate("yyyy-MM-dd HH:mm:ss", tmp.getString("KPRQ").replace("T", " "))); //开票日期
            }
        } catch (Exception e) {
            logger.info("格式化中电四发票时间出错！{}", tmp.toJSONString(), e);
        }


        JSONArray detailArray = reqJson.getJSONArray("InvoiceGoodsList"); //子表
        JSONObject detailTmp = null;
        ErpInvoiceDetailEntity tmpDetailEntity = null;
        if(null != detailArray && detailArray.size() > 0) {
            for(Object detailObj : detailArray) {
                detailTmp = (JSONObject) detailObj;
                if(null != tmpEntity) {
                    tmpDetailEntity = new ErpInvoiceDetailEntity();
                    tmpDetailEntity.setPid(tmpEntity.getId()); //主表主键
                    tmpDetailEntity.setInvoiceSid(detailTmp.getString("C_PS_InvoiceInfo_FK")); //主表ERP主键
                    tmpDetailEntity.setDetailName(detailTmp.getString("SPMC"));//商品名称
                    tmpDetailEntity.setDetailSpec(detailTmp.getString("GGXH"));//商品规格型号
                    tmpDetailEntity.setDetailUnitName(detailTmp.getString("JLDW"));//商品计量单位
                    tmpDetailEntity.setDetailNum(detailTmp.getBigDecimal("SL"));//商品数量
                    tmpDetailEntity.setDetailMny(detailTmp.getBigDecimal("SPJE"));//金额
                    tmpDetailEntity.setDetailTax(detailTmp.getBigDecimal("SPSE"));//商品税额
                    tmpDetailEntity.setDetailRate(detailTmp.getBigDecimal("SLV"));//商品税率
                    tmpDetailEntity.setInvoiceMny(detailTmp.getBigDecimal("FPJE"));//发票金额

                    tmpEntity.getDetailList().add(tmpDetailEntity);
                }
            }
        }

        //查询是否已入库
        List<ErpInvoiceEntity> dbListBySourceId = service.getAllBySourceIds(Collections.singletonList(tmpEntity.getSourceId()));
        if(!CollectionUtils.isNotEmpty(dbListBySourceId)) {
            //未入库保存入库
            service.saveOrUpdate(tmpEntity, false);
            return BeanMapper.map(tmpEntity, ErpInvoiceVO.class);

        } else {
            ErpInvoiceEntity dbEntity = service.selectById(dbListBySourceId.get(0).getId());
            return BeanMapper.map(dbEntity, ErpInvoiceVO.class);
        }
    }
}
