package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.bean.SubTypeEntity;
import com.ejianc.business.zdsmaterial.erp.service.ISubTypeService;
import com.ejianc.business.zdsmaterial.material.vo.SubTypeVO;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 分包类型实体
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("subType")
public class SubTypeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ISubTypeService service;

    @Autowired
    private SessionManager sessionManager;

    private final String SUB_TYPE_ERP_REQ_URL = "/cefoc/yql/getGoodTypeList";

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubTypeVO> queryDetail(Long id) {
    	SubTypeEntity entity = service.selectById(id);
    	SubTypeVO vo = BeanMapper.map(entity, SubTypeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubTypeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<SubTypeEntity> page = service.queryPage(param,false);
        IPage<SubTypeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubTypeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubTypeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubType-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubTypePageData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubTypeVO>> refSubTypePageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                       String condition,
                                                       String searchObject,
                                                       String searchText,
                                                       @RequestParam(required = false) String ids) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("longCode");

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if(StringUtils.isNotBlank(ids)) {
            param.getParams().put("id", new Parameter(QueryParam.IN, ids)); //只查启用的项
        } else {
            if(StringUtils.isNotEmpty(condition)){
                JSONObject _con = JSONObject.parseObject(condition);
                if (_con.containsKey("contractId")) {
                    param.getParams().put("contractId", new Parameter(QueryParam.EQ, String.valueOf(_con.get("contractId"))));
                }
            }
            param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1)); //只查启用的项
        }
        param.getOrderMap().put("sequence", "asc");

        IPage<SubTypeEntity> page = service.queryPage(param,false);
        IPage<SubTypeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubTypeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refSubTypeTreeData", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> refSubTypeData(@RequestParam(required=false) String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("longCode");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if(StringUtils.isNotBlank(searchText)) {
            param.setSearchText(searchText);
        }

        param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1)); //只查启用的项
        param.getOrderMap().put("sequence", "asc");

        List<SubTypeEntity> list = service.queryList(param);
        List<Map> resultMapList = BeanMapper.mapList(list, Map.class);

//        JSONObject jsonObject = new JSONObject();
//        jsonObject.put("data", );
        return ResultAsTree.createTreeData(resultMapList);
     }

     @PostMapping(value = "querySubTypeTree")
     public CommonResponse<JSONObject> querySubTypeTree(@RequestBody QueryParam param) {
         return CommonResponse.success(service.querySubTypeTree(param));
     }

    @GetMapping(value = "syncErpSubTypes")
    public CommonResponse<String> syncErpBrands() {
        logger.info("*********************中电四-分包类型信息同步任务 开始*********************");
        Integer pageNum = 0;
        Integer pageSize = Integer.valueOf(ZDSInterfaceCommonUtil.getErpDataBatchSize());
        Map<String, Integer> param = new HashMap<>();
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + SUB_TYPE_ERP_REQ_URL;
        boolean hasNext = true;
        Map<String, String> headers= null;

        try {
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            param.put("PageSize", pageSize);
            JSONObject reqJson = null;
            JSONArray pageData =null;

            while(hasNext) {
                param.put("PageNum", ++pageNum);
                String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers,
                        ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);
                reqJson = JSONObject.parseObject(reqResp);

                if("ok".equals(reqJson.getString("status"))) {
                    pageData = reqJson.getJSONArray("data");
                    if(null != pageData && pageData.size() > 0) {
                        logger.info("中电四分包类型同步，处理第{}页, {}条数据", pageNum, pageData.size());
                        handleErpDataPage(pageData);
                    } else {
                        logger.info("中电四分包类型同步 处理数据完成！！！总共{}页数据！", pageNum);
                        hasNext = false;
                    }
                } else {
                    logger.error("请求中电四获取分包类型结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
                    hasNext = false;
                }
            }

        } catch (Exception e) {
            logger.error("获取中电四分包类型信息异常, 请求地址：{}, 请求参数：{}", reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat), e);
            return CommonResponse.error("同步中电四分包类型信息异常");
        }

        logger.info("*********************中电四-分包类型信息同步任务 结束*********************");
        return CommonResponse.success("中电四分包类型同步完成！");
    }

    private void handleErpDataPage(JSONArray pageData) {
        JSONObject tmpJson = null;
        SubTypeEntity tmpEntity = null;
        List<SubTypeEntity> saveList = new ArrayList<>();
        Map<String, SubTypeEntity> pageSourceMap = new HashMap<>();
        Set<String> sourceIds = new HashSet<>();

        for(Object obj : pageData) {
            tmpJson = (JSONObject) obj;
            tmpEntity = new SubTypeEntity();
            tmpEntity.setName(tmpJson.getString("Title"));
            tmpEntity.setViewName(tmpJson.getString("ViewTitle"));
            tmpEntity.setSourceId(tmpJson.getString("C_SD_GoodsTypeOID"));
            tmpEntity.setEnabled("True".equals(tmpJson.getString("IsEnable")) ? 1 : 0);
            tmpEntity.setSequence(null != tmpJson.get("Sort_ID") ? tmpJson.getInteger("Sort_ID") : 1);
            tmpEntity.setMemo(null != tmpJson.getString("Memo") ? tmpJson.getString("Memo") : null);
            tmpEntity.setLongCode(tmpJson.getString("Long_code"));
            tmpEntity.setShortCode(tmpJson.getString("Short_code"));
            tmpEntity.setParentSourceId(tmpJson.getString("ParentOID"));

            if("00000000-0000-0000-0000-000000000000".equals(tmpEntity.getParentSourceId()) || StringUtils.isBlank(tmpEntity.getParentSourceId())) {
                tmpEntity.setParentSourceId(null);
            }

            pageSourceMap.put(tmpEntity.getSourceId(), tmpEntity);
            sourceIds.add(tmpEntity.getSourceId());
            if(StringUtils.isNotBlank(tmpEntity.getParentSourceId())) {
                sourceIds.add(tmpEntity.getParentSourceId());
            }
        }

        Map<String, SubTypeEntity> dbSourceMap = new HashMap<>();
        List<SubTypeEntity> dbListBySourceId = service.getAllBySourceIds(new ArrayList<>(sourceIds));
        if(CollectionUtils.isNotEmpty(dbListBySourceId)) {
            dbSourceMap = dbListBySourceId.stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));
        }
        SubTypeEntity parent = null;
        for(SubTypeEntity subType : pageSourceMap.values()) {
            //更新
            if(dbSourceMap.containsKey(subType.getSourceId())) {
                tmpEntity = dbSourceMap.get(subType.getSourceId());
                tmpEntity.setName(subType.getName());
                tmpEntity.setViewName(subType.getViewName());
                tmpEntity.setEnabled(subType.getEnabled());
                tmpEntity.setSequence(subType.getSequence());
                tmpEntity.setMemo(subType.getMemo());
                tmpEntity.setLongCode(subType.getLongCode());
                tmpEntity.setShortCode(subType.getShortCode());
            } else {
                //新增
                tmpEntity = subType;
            }

            if(StringUtils.isNotBlank(subType.getParentSourceId())) {
                parent = dbSourceMap.get(subType.getParentSourceId());
                if(null == parent) {
                    parent = pageSourceMap.get(subType.getParentSourceId());
                }
                if(null == parent) {
                    logger.error("分包类型：名称-{}，sourceId-{}，保存失败，对应父级[sid-{}]在系统中不存在",
                            tmpEntity.getName(), tmpEntity.getSourceId(), subType.getParentSourceId());
                    continue;
                }
                tmpEntity.setParentId(parent.getId());
            }

            saveList.add(tmpEntity);
        }

        logger.info("本次保存数据-{}条", saveList.size());
        service.saveOrUpdateBatch(saveList, saveList.size(), false);

    }
}
