package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.erp.bean.ContractDetailEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.ContractDetailMapper;
import com.ejianc.business.zdsmaterial.erp.service.IContractDetailService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 物资合同-清单明细
 * 
 * @author generator
 * 
 */
@Service("contractDetailService")
public class ContractDetailServiceImpl extends BaseServiceImpl<ContractDetailMapper, ContractDetailEntity> implements IContractDetailService{

    @Override
    public List<ContractDetailEntity> getByAllContractId(Long contractId) {
        QueryWrapper<ContractDetailEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        return super.list(query);
    }

    @Override
    public void cancelByContractIds(List<Long> delContractIds) {
        //合同子表作废
        UpdateWrapper<ContractDetailEntity> update = new UpdateWrapper<>();
        update.in("contract_id", delContractIds);
        update.eq("dr", BaseVO.DR_UNDELETE);
        update.set("dr", 1);
        update.set("update_time", new Date());
        super.update(update);
    }
}
