package com.ejianc.business.zdsmaterial.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategorySettingsEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategorySettingsService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategorySettingsVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 采购计划控制方式
 *
 * @author generator
 */
@Controller
@RequestMapping("materialCategorySettings")
public class MaterialCategorySettingsController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IMaterialCategorySettingsService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialCategorySettingsVO> saveOrUpdate(@RequestBody MaterialCategorySettingsVO saveOrUpdateVO) {
//        if (saveOrUpdateVO.getMaxControlRation())
        if (ComputeUtil.isGreaterOrEqual(saveOrUpdateVO.getMinControlRation(),saveOrUpdateVO.getMaxControlRation())){
            throw new BusinessException("区间值有误!");
        }
        CommonResponse<Boolean> booleanCommonResponse = service.betweenMinAndMaxRation(saveOrUpdateVO);
        if (!booleanCommonResponse.isSuccess()) {
            throw new BusinessException("网络异常 请联系管理员处理！");
        }
        if (!booleanCommonResponse.getData()) {
            throw new BusinessException("控制范围开始和结束区间不允许出现在已有区间内!");
        }

        MaterialCategorySettingsEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialCategorySettingsEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            QueryWrapper<MaterialCategorySettingsEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("category_id", entity.getCategoryId());
            queryWrapper.eq("control_mode", entity.getControlMode());
            int count = service.count(queryWrapper);
            if (count > 0) {
                throw new BusinessException("一个分类不允许控制方式重复。!");
            }
        }

        service.saveOrUpdate(entity, false);
        MaterialCategorySettingsVO vo = BeanMapper.map(entity, MaterialCategorySettingsVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialCategorySettingsVO> queryDetail(Long id) {
        MaterialCategorySettingsEntity entity = service.selectById(id);
        MaterialCategorySettingsVO vo = BeanMapper.map(entity, MaterialCategorySettingsVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialCategorySettingsVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialCategorySettingsVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MaterialCategorySettingsVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialCategorySettingsVO>> queryList(@RequestBody QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<MaterialCategorySettingsEntity> page = service.queryPage(param, false);
        IPage<MaterialCategorySettingsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialCategorySettingsVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 查询物资分类树
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryCategoryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryCategoryList(@RequestBody QueryParam param) {
        return service.queryCategoryList(param);
    }


    @RequestMapping(value = "/betweenMinAndMaxRation", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> betweenMinAndMaxRation(@RequestBody MaterialCategorySettingsVO vo) {
        return service.betweenMinAndMaxRation(vo);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MaterialCategorySettingsEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialCategorySettings-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refMaterialCategorySettingsData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialCategorySettingsVO>> refMaterialCategorySettingsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                             String condition,
                                                                                             String searchObject,
                                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaterialCategorySettingsEntity> page = service.queryPage(param, false);
        IPage<MaterialCategorySettingsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialCategorySettingsVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
