package com.ejianc.business.zdsmaterial.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.bean.MatFeeApplyDetailEntity;
import com.ejianc.business.zdsmaterial.material.bean.MatFeeApplyEntity;
import com.ejianc.business.zdsmaterial.material.bean.MatFeeApplyFileDetailEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MatFeeApplyMapper;
import com.ejianc.business.zdsmaterial.material.service.IMatFeeApplyService;
import com.ejianc.business.zdsmaterial.material.vo.MatFeeApplyVO;
import com.ejianc.business.zdsmaterial.sub.subvisa.enums.InstructionStatusEnum;
import com.ejianc.business.zdsmaterial.util.PushFileUtil;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 物资费用申请
 *
 * @author generator
 */
@Service("matFeeApplyService")
public class MatFeeApplyServiceImpl extends BaseServiceImpl<MatFeeApplyMapper, MatFeeApplyEntity> implements IMatFeeApplyService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "MAT-FEE-CODE";//此处需要根据实际修改
    private final String OPERATE = "matFeeApplyBill";
    private static final String BILL_TYPE_CODE = "EJCBT202403000028";//单价类型编码规则

    @Value("${common.env.base-host}")
    private String BASE_HOST;
    private final String BILL_PUSH_PM_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/matFeeApply/syncBill";//推送接口
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private MatFeeApplyMapper mapper;

    @Autowired
    private PushFileUtil pushFileUtil;

    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public CommonResponse<String> syncBill(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);
        logger.info("接收到推送分包签章单据: {}, 当前上下文: {}", transData, authority);
        if (StringUtils.isBlank(transData)) {
            return CommonResponse.error("单据同步失败，单据内容为空！");
        }
        MatFeeApplyEntity entity = JSONObject.parseObject(transData, MatFeeApplyEntity.class);
        long id = IdWorker.getId();
        //执行新增 设置来源
        entity.setSourceId(entity.getId());
        entity.setId(id);

        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setReceiveStatus(InstructionStatusEnum.待审核.getStatus());
        //将附件关联在单据中
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        entity.setVersion(null);
        entity.setCreateUserCode(null);
        entity.setUpdateUserCode(null);

        //查询审核人信息,讲审核人(合同的录入人)作为单据的创建人
        EmployeeVO craetor = null;
        if(null != entity.getPurchaseWorkerId()) {
            CommonResponse<EmployeeVO> creatorResp = employeeApi.getById(entity.getPurchaseWorkerId());
            if(!creatorResp.isSuccess()) {
                logger.error("查询合同录入人-{}信息失败,{}", entity.getPurchaseWorkerId(), JSONObject.toJSONString(creatorResp, SerializerFeature.PrettyFormat));
                return CommonResponse.error("操作失败,查询采购工程师信息失败!");
            }

            if(null == creatorResp.getData()) {
                logger.error("查询合同录入人-{}信息为空,{}", entity.getPurchaseWorkerId(), JSONObject.toJSONString(creatorResp, SerializerFeature.PrettyFormat));
                return CommonResponse.error("操作失败,查询采购工程师信息失败!");
            }
            craetor = creatorResp.getData();
        }

        for(MatFeeApplyFileDetailEntity detail : entity.getFileList()) {
            detail.setId(IdWorker.getId());
            detail.setCreateTime(null);
            detail.setUpdateTime(null);
            detail.setTenantId(InvocationInfoProxy.getTenantid());
            detail.setUpdateUserCode(null);
            detail.setCreateUserCode(craetor.getCode());
            detail.setVersion(null);

            Long fileId = pushFileUtil.uploadFileFormNet(BILL_TYPE_CODE, detail.getId(), PlanConstant.MAT_INVOICE_FILE_SOURCE_TYPE, detail.getAttachmentId());
            detail.setAttachmentId(fileId);
        }
        for(MatFeeApplyDetailEntity detail : entity.getDetailList()) {
            detail.setId(IdWorker.getId());
            detail.setCreateTime(null);
            detail.setUpdateTime(null);
            detail.setTenantId(InvocationInfoProxy.getTenantid());
            detail.setUpdateUserCode(null);
            detail.setCreateUserCode(craetor.getCode());
            detail.setVersion(null);
        }
        entity.setCreateUserCode(craetor.getCode());
        logger.info("接收到推送分包签章转换保存单据: {}", JSONObject.toJSONString(entity));
        super.saveOrUpdate(entity,false);
        logger.info("采购费用申请向采购工程师（合同录入人）id-{}发送消息", entity.getPurchaseWorkerId().toString());
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setSubject("【采购费用申请】：【"+entity.getBillCode()+"】，【"+
                DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss",
                new Date()) +"】需要您审核！");
        StringBuilder content = new StringBuilder();
        content.append("【").append(entity.getBillCode()).append("】，【")
                .append(entity.getProjectName()).append("】，【")
                .append(entity.getContractName()).append("】，【").append(entity.getSupplierName()).append("】提交了费用申请，请您审核！");
        parameter.setContent(content.toString());
        parameter.setPcUrl(BASE_HOST + "ejc-zdsmaterial-frontend/#/purCostApply/card?id=" + entity.getId().toString());
        String[] recIds = new String[]{entity.getPurchaseWorkerId().toString()}; //验收人Id
        parameter.setReceivers(recIds);
        sendMsg(parameter, entity.getId(), "采购费用申请向采购工程师发送消息", "采购费用申请");
        return CommonResponse.success("单据同步成功！");
    }
    public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg, String notice) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType(StringUtils.isNotBlank(notice) ? notice : "提醒");
        parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS, PushMsgParameter.CHANNEL_TYPE_EMAIL});

        CommonResponse<String> sendResp = pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            logger.error("{}-发送消息失败，单据Id-{}，发送消息结果-{}", oprMsg, billId, JSONObject.toJSONString(sendResp, SerializerFeature.PrettyFormat,
                    SerializerFeature.WriteMapNullValue));
        } else {
            logger.info("{}-发送消息成功！", oprMsg);
        }
    }
    @Override
    public String pushBill(MatFeeApplyEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = OPERATE + "::" + entity.getId().toString() + "::sup";

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);
            if (!locked) {
                releaseLock(jedis, false, key, OPERATE);
                return "采购合同结算推送供应链平台失败，加锁失败！";
            }
            Map<String, String> params = new HashMap<>();
            params.put("transData", JSONObject.toJSONString(entity));
            logger.info("采购合同结算推送供应链平台: url-{}, 采购合同结算：{}", BILL_PUSH_PM_SERVER_URL, JSONObject.toJSONString(entity));
            CommonResponse<String> writeBackResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_PUSH_PM_SERVER_URL,
                    params, entity.getSupplierId().toString(), null);
            logger.error("采购合同结算推送供应链平台请求结果，{}", JSONObject.toJSONString(writeBackResp));
            if (!writeBackResp.isSuccess()) {
                releaseLock(jedis, true, key, OPERATE);
                logger.error("采购合同结算id-{}推送供应链平台发送请求失败，{}", entity.getId(), writeBackResp.getMsg());
                return "采购合同结算推送供应链平台失败";
            }
            String operateRespStr = writeBackResp.getData();
            CommonResponse<String> operateResp = JSONObject.parseObject(operateRespStr, CommonResponse.class);
            if (!operateResp.isSuccess()) {
                logger.error("采购合同结算id-{}推送供应链，平台处理失败，{}", entity.getId(), operateResp.getMsg());
                releaseLock(jedis, true, key, OPERATE);
                return "采购合同结算推送供应链平台失败";
            }
        } catch (Exception e) {
            logger.error("采购合同结算id-{}推送供应链平台失败，", entity.getId(), e);
            msg = "操作失败，采购合同结算推送供应链平台失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }

    @Override
    public int pageCount(Map<String, Object> queryParam) {
        return mapper.pageCount(queryParam);
    }

    @Override
    public List<JSONObject> pageList(Map<String, Object> queryParam) {
        return mapper.pageList(queryParam);
    }

    @Override
    public BigDecimal thisYearApplyMny(Long linkerId, String linkerSid, Long supplierId) {
        return mapper.thisYearApplyMny(linkerId, linkerSid, supplierId);
    }

    @Override
    public CommonResponse<MatFeeApplyVO> pushStatus(Long id) {
        MatFeeApplyEntity entity = super.selectById(id);
        entity.setReceiveStatus(InstructionStatusEnum.已驳回.getStatus());
        String s = pushBill(entity);
        if (StringUtils.isNotBlank(s)) {
            throw new BusinessException(s);
        }
        super.saveOrUpdate(entity,false);
        MatFeeApplyVO instructionSetVO = BeanMapper.map(entity, MatFeeApplyVO.class);
        return CommonResponse.success("驳回成功！",instructionSetVO);
    }


    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}
