package com.ejianc.business.zdsmaterial.material.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceEntity;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceService;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceDetailEntity;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceEntity;
import com.ejianc.business.zdsmaterial.material.service.IMatInvoiceDetailService;
import com.ejianc.business.zdsmaterial.material.service.IMatInvoiceService;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service("matInvoice")
public class MatInvoiceBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
	private IMatInvoiceService matInvoiceService;
    @Autowired
	private IMatInvoiceDetailService matInvoiceDetailService;
    @Autowired
	private IErpInvoiceService erpInvoiceService;

	@Autowired
	private IProjectPoolApi projectPoolApi;

	@Autowired
	private IEmployeeApi employeeApi;

	@Autowired
	private SessionManager sessionManager;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return checkInvoiceState(billId);
	};

	private CommonResponse<String> checkInvoiceState(Long billId) {
		MatInvoiceEntity entity = matInvoiceService.selectById(billId);

		if(PlanConstant.SOURCE_TYPE_SUPPLIER.equals(entity.getSourceType())) {
			QueryWrapper<MatInvoiceEntity> query = new QueryWrapper<>();
			query.eq("source_id", entity.getSourceId());
			query.eq("sign_state", PlanConstant.CHECK_STATE_FINISH);
			query.ne("id", entity.getId());
			query.in("bill_state", new Integer[]{
					BillStateEnum.COMMITED_STATE.getBillStateCode(),
					BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
					BillStateEnum.PASSED_STATE.getBillStateCode(),
					BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(),
			});
			List<MatInvoiceEntity> dbList = matInvoiceService.list(query);
			if(CollectionUtils.isNotEmpty(dbList)) {
				logger.error("采购发票登记单据-{}id-{}确认操作失败，存在重复发票号且审核中/已审核的单据【ids-{}】", entity.getId(),
						StringUtils.join(dbList.stream().map(MatInvoiceEntity::getId).collect(Collectors.toSet()), ","));
				throw new BusinessException("操作失败，存在发票号相同且已提交审核的单据【"+StringUtils.join(dbList.stream()
						.map(MatInvoiceEntity::getBillCode).collect(Collectors.toSet()), ",")+"】");
			}
		}

		if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
			List<String> numbers = new ArrayList<>(entity.getDetailList().stream().filter(item -> StringUtils.isNotBlank(item.getInvoiceNumber())).map(MatInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toSet()));
			//查询发票
			if(CollectionUtils.isNotEmpty(numbers)) {
				List<ErpInvoiceEntity> list = erpInvoiceService.getAllByInvoiceNums(numbers);
				logger.info("采购: 根据发票号：{}, EL查询到发票数：{}", JSONObject.toJSONString(numbers), list.size());
				Set<String> quoteNumList = new HashSet<>();
				for(ErpInvoiceEntity e : list) {
					logger.info("采购发票id-{},number-{}, ERP引用标识：{}", e.getId(), e.getNumber(), e.getErpQuoteFlag());
					if(PlanConstant.STRING_YES.equals(e.getErpQuoteFlag())) {
						quoteNumList.add(e.getNumber());
					}
				}

				if(CollectionUtils.isNotEmpty(quoteNumList)) {
					return CommonResponse.error("操作失败，号码为["+quoteNumList.stream().collect(Collectors.joining(","))+"]的发票已被引用");
				}
			}

			List<String> invIdList = entity.getDetailList().stream().map(MatInvoiceDetailEntity::getErpId).collect(Collectors.toList());
			LambdaQueryWrapper<ErpInvoiceEntity> queryWrapper = new LambdaQueryWrapper<>();
			queryWrapper.in(ErpInvoiceEntity::getSourceId, invIdList);
			List<ErpInvoiceEntity> invoiceEntities = erpInvoiceService.list(queryWrapper);

			Set<String> rightSet = new HashSet<>();
			Set<String> errSet = new HashSet<>();
			Set<String> errNumSet = new HashSet<>();
			if (CollectionUtils.isNotEmpty(invoiceEntities)) {
				for (ErpInvoiceEntity invoiceEntity : invoiceEntities) {
					if ("0".equals(invoiceEntity.getStatusCode())) {
						rightSet.add(invoiceEntity.getSourceId());
					}else {
						errSet.add(invoiceEntity.getSourceId());
						errNumSet.add(invoiceEntity.getNumber());
					}
				}
			}
			for (String id : invIdList) {
				if (!rightSet.contains(id)) {
					errSet.add(id);
				}
			}

			//根据项目查询项目主管会计
			CommonResponse<ProjectPoolSetVO> projectResp = projectPoolApi.getById(entity.getProjectId());
			if(!projectResp.isSuccess()) {
				logger.error("根据项目Id-{}获取项目信息失败：{}", entity.getProjectId(), JSONObject.toJSONString(projectResp));
				return CommonResponse.error("操作失败，获取所属项目信息失败！");
			}
			ProjectPoolSetVO project = projectResp.getData();
			if(null == project.getChiefAccountantId()) {
				return CommonResponse.error("项目【"+entity.getProjectName()+"】未查询到对应主管会计信息！");
			}

			CommonResponse<EmployeeVO> empResp = employeeApi.getById(project.getChiefAccountantId());
			if(!empResp.isSuccess()) {
				logger.error("根据人员Id-{}获取人员信息失败：{}", project.getChiefAccountantId(), JSONObject.toJSONString(empResp));
				return CommonResponse.error("操作失败，获取项目主管会计人员信息失败！");
			}
			EmployeeVO emp = empResp.getData();
			if(null == emp) {
				return CommonResponse.error("操作失败，未查询到项目对应的主管会计信息！");
			}

			LambdaUpdateWrapper<MatInvoiceEntity> mainUpdate = new LambdaUpdateWrapper<>();
			mainUpdate.eq(MatInvoiceEntity::getId, entity.getId());
			mainUpdate.set(MatInvoiceEntity::getChiefAccountantId, emp.getId());
			mainUpdate.set(MatInvoiceEntity::getChiefAccountantName, emp.getName());
			matInvoiceService.update(mainUpdate);

			if (CollectionUtils.isNotEmpty(rightSet)) {
				LambdaUpdateWrapper<MatInvoiceDetailEntity> update = new LambdaUpdateWrapper<>();
				update.in(MatInvoiceDetailEntity::getErpId, new ArrayList<>(rightSet));
				update.set(MatInvoiceDetailEntity::getInvoiceState, "正常");
				matInvoiceDetailService.update(update);
			}
			if (CollectionUtils.isNotEmpty(errSet)) {
				LambdaUpdateWrapper<MatInvoiceDetailEntity> update = new LambdaUpdateWrapper<>();
				update.in(MatInvoiceDetailEntity::getErpId, new ArrayList<>(errSet));
				update.set(MatInvoiceDetailEntity::getInvoiceState, "异常");
				matInvoiceDetailService.update(update);
				return CommonResponse.error("号码为["+StringUtils.join(errNumSet,",")+"]的发票状态不是正常状态，无法启动流程！");
			}
		}
		return CommonResponse.success();
	}


	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		MatInvoiceEntity e = matInvoiceService.selectById(billId);
		UserContext user = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(user.getUserCode());
		e.setCommitUserCode(user.getUserName());

		matInvoiceService.saveOrUpdate(e, false);

		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		MatInvoiceEntity e = matInvoiceService.selectById(billId);

		//驳回时把申请状态改为待审核
		LambdaUpdateWrapper<MatInvoiceEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(MatInvoiceEntity::getId, Long.valueOf(billId));
		if(PlanConstant.SOURCE_TYPE_SUPPLIER.equals(e.getSourceType())) {
			updateWrapper.set(MatInvoiceEntity::getSignState,  PlanConstant.CHECK_STATE_UN);
		}
		updateWrapper.set(MatInvoiceEntity::getCommitDate, null);
		updateWrapper.set(MatInvoiceEntity::getCommitUserCode, null);
		updateWrapper.set(MatInvoiceEntity::getCommitUserName, null);
		updateWrapper.set(MatInvoiceEntity::getFinalApproveUserId, null);
		updateWrapper.set(MatInvoiceEntity::getFinalApproveUserName, null);
		updateWrapper.set(MatInvoiceEntity::getFinalApproveUserCode, null);

		matInvoiceService.update(updateWrapper);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(state)) {
			return checkInvoiceState(billId);
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		MatInvoiceEntity e = matInvoiceService.selectById(billId);
		UserContext user = sessionManager.getUserContext();
		if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
			e.setCommitDate(new Date());
			e.setCommitUserCode(user.getUserCode());
			e.setCommitUserCode(user.getUserName());
		}
		e.setEffectiveDate(new Date());
		e.setFinalApproveUserId(user.getUserId());
		e.setFinalApproveUserName(user.getUserName());
		e.setFinalApproveUserCode(user.getUserCode());

		matInvoiceService.saveOrUpdate(e, false);

		//推送采购发票至ERP
		matInvoiceService.syncToErp(billId, user.getUserId());

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}


//	@Override
//	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
//		MatInvoiceEntity entity = matInvoiceService.selectById(billId);
//		//根据项目查询项目主管会计
//		CommonResponse<ProjectPoolSetVO> projectResp = projectPoolApi.getById(entity.getProjectId());
//		if(!projectResp.isSuccess()) {
//			logger.error("根据项目Id-{}获取项目信息失败：{}", entity.getProjectId(), JSONObject.toJSONString(projectResp));
//			return CommonResponse.error("操作失败，获取所属项目信息失败！");
//		}
//		ProjectPoolSetVO project = projectResp.getData();
//		if(null == project.getChiefAccountantId()) {
//			return CommonResponse.error("项目【"+entity.getProjectName()+"】未查询到对应主管会计信息！");
//		}
//
//		JSONArray resp = new JSONArray();
//		CommonResponse<EmployeeVO> empResp = employeeApi.getById(project.getChiefAccountantId());
//		if(!empResp.isSuccess()) {
//			logger.error("根据人员Id-{}获取人员信息失败：{}", project.getChiefAccountantId(), JSONObject.toJSONString(empResp));
//			return CommonResponse.error("操作失败，获取项目主管会计人员信息失败！");
//		}
//		EmployeeVO emp = empResp.getData();
//
//		JSONObject obj = new JSONObject();
//		obj.put("userId", emp.getId());
//		obj.put("userName", emp.getName());
//		resp.add(obj);
//
//		return CommonResponse.success("查询成功", resp);
//	}

}
