package com.ejianc.business.zdsmaterial.material.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.asynchandler.QueueUtils;
import com.ejianc.business.zdsmaterial.asynchandler.bean.MaPushErpRecordsEntity;
import com.ejianc.business.zdsmaterial.asynchandler.consumer.PushErpRecordListener;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.erp.vo.DataPushErpParam;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertyEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertySubItemEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MaterialCategoryMapper;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertyService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertySubItemService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.constants.ReferConstant;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.base.Stopwatch;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 材料分类
 * 
 * @author generator
 * 
 */
@Service("materialCategoryService")
public class MaterialCategoryServiceImpl extends BaseServiceImpl<MaterialCategoryMapper, MaterialCategoryEntity> implements IMaterialCategoryService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private MaterialCategoryMapper mapper;

    @Autowired
    private IMaterialCategoryPropertySubItemService materialCategoryPropertySubItemService;

    @Lazy
    @Autowired
    private IMaterialService materialService;

    @Autowired
    private IMaterialCategoryPropertyService propertyService;

    private final String MATERIAL_CATEGORY_SYNC_URL = "/cefoc/yql/ReceiveGoodTypeList";

    @Autowired
    private IUserApi userApi;

    @Autowired
    private EnvironmentTools environmentTools;

    @Autowired
    private QueueUtils queueUtils;

    @Value("${spring.cloud.config.profile}")
    private String profile;

    @Override
    public List<MaterialCategoryVO> queryList(Map<String, Object> params) {
        return mapper.queryList(params);
    }
    @Override
    public List<MaterialCategoryVO> queryListAndRuledFlag(Map<String, Object> params) {
        return mapper.queryListAndRuledFlag(params);
    }
    @Override
    public MaterialCategoryEntity selectByCode(String code) {
        QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
        query.eq("code", code);
        return super.getOne(query);
    }

    @Override
    public MaterialCategoryVO saveOrUpdateCategory(MaterialCategoryEntity entity) {
        String newCategoryName = null; //需要更新物资明细的分类名称
        List<MaterialCategoryPropertySubItemEntity> propertyValueList = new ArrayList<>();
        boolean newPropertyFlag = false; //本次有新增的属性
        Integer enabled = null; //物资启用标识：0-停用，1-启用
        Integer blockFlag = null; //物资封存标识 0-正常，1-封存
        //新的停用属性分类
        List<MaterialCategoryPropertyEntity> newNotEnabledProperty = new ArrayList<>();
        List<MaterialCategoryPropertyEntity> changedProperty = new ArrayList<>();

        //待删除的分类属性Id
        List<Long> delPropertyValueIds = new ArrayList<>();
        //发生变化的属性值列表
        List<MaterialCategoryPropertySubItemEntity> changeNameValues = new ArrayList<>();
        List<MaterialCategoryPropertySubItemEntity> neweValues = new ArrayList<>();
        MaterialCategoryEntity dbEntity = null;
        if(null == entity.getId()) {
            entity.setId(IdWorker.getId());

            if(null != entity.getParentId()) {
                MaterialCategoryEntity parent = super.selectById(entity.getParentId());
                entity.setInnerCode(parent.getInnerCode() + "|" + entity.getId());
                entity.setCoordinationFlag(parent.getCoordinationFlag());
            } else {
                entity.setCoordinationFlag(0); //默认不协同
                entity.setInnerCode(entity.getId().toString());
            }
        }

        if(entity.getPropertyFlag() == 1) { //如果分类设置了属性
            //判断名称是否变化，若发生变化，则刷新明细中的名称数据
            Map<Long, MaterialCategoryPropertyEntity> oldProperty = new HashMap<>();
            dbEntity = super.selectById(entity.getId());
            if(null != dbEntity) {
                if(!dbEntity.getName().equals(entity.getName())) {
                    newCategoryName = entity.getName();
                }
                //拿到已停用的属性分类列表
                if(CollectionUtils.isNotEmpty(dbEntity.getPropertyList())) {
                    oldProperty.putAll(dbEntity.getPropertyList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
                }
            }

            //处理分类下属性 及属性值
            if(CollectionUtils.isNotEmpty(entity.getPropertyList())) {
                //新增的属性分类
                List<MaterialCategoryPropertyEntity> newProperty = new ArrayList<>();

                List<MaterialCategoryPropertyEntity> pList = new ArrayList<>();

                //停用、删除的属性分类 只更改对应的状态，其字段信息与属性值信息保持元数据不做更新
                //只更新启用的属性分类信息及其属性值信息
                entity.getPropertyList().stream().forEach(item -> {
                    if(oldProperty.containsKey(item.getId()) && ZDSMaterialCommonEnums.停启用_停用.getCode().equals(oldProperty.get(item.getId()).getEnabled())) {
                        //若之前已停用，则不做更新
                        pList.add(oldProperty.get(item.getId()));
                    } else if("del".equals(item.getRowState())) {
                        //删除的属性分类只更新删除标识，字段不做更新
                        oldProperty.get(item.getId()).setRowState("del");
                        pList.add(oldProperty.get(item.getId()));
                        //若属性分类删除，则属性分类下属性值也做逻辑删除
                        delPropertyValueIds.addAll(item.getItemList().stream().map(MaterialCategoryPropertySubItemEntity::getId).collect(Collectors.toSet()));
                    } else {
                        //停用只更新状态
                        if(ZDSMaterialCommonEnums.停启用_停用.getCode().equals(item.getEnabled())) {
                            if(oldProperty.containsKey(item.getId())) {
                                oldProperty.get(item.getId()).setEnabled(ZDSMaterialCommonEnums.停启用_停用.getCode());
                                pList.add(oldProperty.get(item.getId()));
                                newNotEnabledProperty.add(item);
                            } else if(null == item.getId()) {
                                item.setId(IdWorker.getId());
                                //默认使用名称作为编码
                                item.setCode(item.getName());
                                newProperty.add(item);
                            }
                        } else {
                            if(item.getId() == null) {//属性分类编辑、新增项
                                item.setId(IdWorker.getId());
                                //默认使用名称作为编码
                                item.setCode(item.getName());
                                newProperty.add(item);
                            }
                            if((StringUtils.isNotBlank(item.getOldName()) && !item.getName().equals(item.getOldName())) ||
                                    (null != item.getOldSequence() && !item.getOldSequence().equals(item.getSequence())) ||
                                    (null != item.getOldProductCodeFlag() && !item.getOldProductCodeFlag().equals(item.getProductCodeFlag()))) {
                                //属性分类的名称、 排序、产品代码停启用发生变化
                                changedProperty.add(item);
                            }
                            pList.add(item);
                            //只更新启用状态分类属性的属性值信息
                            //存入属性值更新列表
                            propertyValueList.addAll(item.getItemList().stream().map(sub -> {
                                if(null == sub.getId()) {
                                    sub.setCategoryId(entity.getId());
                                    sub.setPropertyId(item.getId());
                                }
                                return sub;
                            }).collect(Collectors.toList()));
                        }
                    }
                });

                //分类属性名展示拼接
                entity.setPropertyShowName(pList.stream().filter(item -> !"del".equals(item.getRowState())).sorted(new Comparator<MaterialCategoryPropertyEntity>() {
                    @Override
                    public int compare(MaterialCategoryPropertyEntity o1, MaterialCategoryPropertyEntity o2) {
                        return o1.getSequence() - o2.getSequence();
                    }
                }).map(item -> item.getName()).collect(Collectors.joining("-")));

                if(CollectionUtils.isNotEmpty(newProperty)) {
                    //若存在新的属性分类，那么改物料分类下所有的明细做封存处理
                    newPropertyFlag = true;
                }
            }

            //属性保存校验
            if(CollectionUtils.isNotEmpty(propertyValueList)) {
                //获取物料分类下 所有的属性值
                List<MaterialCategoryPropertySubItemVO> dbPropertyValues = materialCategoryPropertySubItemService.getAllByCategoryId(entity.getId());
                //Map<propertyId, Map<propertyValue, propertySubItemVO>>
                Map<Long, Map<String, MaterialCategoryPropertySubItemVO>> propertyValueMap = dbPropertyValues.stream()
                        .collect(Collectors.groupingBy(MaterialCategoryPropertySubItemVO::getPropertyId,
                                Collectors.toMap(item -> item.getName(), item -> item)));

                Set<String> validPropertyValues = null;
                Map<String, MaterialCategoryPropertySubItemVO> propertySubItemNameMap = new HashMap<>();
                Map<Long, Set<String>> propertyValuesMap = new HashMap<>();
                for(MaterialCategoryPropertySubItemEntity item : propertyValueList) {
                    validPropertyValues = propertyValuesMap.get(item.getPropertyId());
                    if(null == validPropertyValues) {
                        validPropertyValues = new HashSet<>();
                        propertyValuesMap.put(item.getPropertyId(), validPropertyValues);
                    }

                    propertySubItemNameMap = propertyValueMap.get(item.getPropertyId());
                    if("del".equals(item.getRowState())) {
                        //属性值删除：1、未被引用的物料明细：改为停用、正常，修改属性值后可启用。2、已被引用的物料明细：改为停用、封存。
                        delPropertyValueIds.add(item.getId());
                    } else {
                        if((null != item.getOldName() && !item.getName().equals(item.getOldName())) ||
                                (null != item.getOldProductCode()) && !item.getOldProductCode().equals(item.getProductCode())) {
                            //属性值、产品代码发生了变化: 1、未被引用的物料明细：直接对应修改属性值。2、已被引用的物料明细：改为停用、封存。
                            changeNameValues.add(item);
                        } else {
                            neweValues.add(item);
                        }
                        if(validPropertyValues.contains(item.getName())) {
                            throw new BusinessException("保存失败, 属性值重复！");
                        }
                        if(null != propertySubItemNameMap && propertySubItemNameMap.containsKey(item.getName())
                                && !propertySubItemNameMap.get(item.getName()).getId().equals(item.getId())) {
                            if(ZDSMaterialCommonEnums.分类设置属性值是否生效_否.getCode().equals(propertySubItemNameMap.get(item.getName()).getValidFlag())
                                    && neweValues.contains(item)) {
                                //判断是否存在重复的属性值，则判断重复的属性值在数据库中是否为未生效 并且（当前属性值必须为新增项），若是，则将未生效的属性值置为生效态
                                neweValues.remove(item);
                                propertySubItemNameMap.get(item.getName()).setSequence(item.getSequence());
                                propertySubItemNameMap.get(item.getName()).setValidFlag(ZDSMaterialCommonEnums.分类设置属性值是否生效_是.getCode());
                                neweValues.add(BeanMapper.map(propertySubItemNameMap.get(item.getName()), MaterialCategoryPropertySubItemEntity.class));
                            }
                        }
                        validPropertyValues.add(item.getName());
                    }
                }


                if(CollectionUtils.isNotEmpty(changeNameValues)) {
                    materialCategoryPropertySubItemService.saveOrUpdateBatch(changeNameValues, changeNameValues.size(), false);
                }
                if(CollectionUtils.isNotEmpty(delPropertyValueIds)) {
                    materialCategoryPropertySubItemService.removeByIds(delPropertyValueIds);
                }
                if(CollectionUtils.isNotEmpty(neweValues)) {
                    materialCategoryPropertySubItemService.saveOrUpdateBatch(neweValues, neweValues.size(), false);
                }
            }

            //物资明细更新逻辑：先更新物资明细的属性名以及属性值，最后更新物资明细的停启用、封存状态
            List<Long> excludeMaterialIds = new ArrayList<>();
            if(newPropertyFlag || newNotEnabledProperty.size() > 0) {
                //如果有新增分类属性或者有属性分类停用，那么分类下所有物料明细全部封存
                enabled = ZDSMaterialCommonEnums.停启用_停用.getCode();
                blockFlag = ZDSMaterialCommonEnums.封存_封存.getCode();
            }

            if(changedProperty.size() > 0 || changeNameValues.size() > 0) {
                //如果有属性值或者属性修改，那么对应的物资单独做调整
                excludeMaterialIds.addAll(materialService.updatePropertyAndValues(changedProperty, changeNameValues, delPropertyValueIds, newCategoryName));
            } else if(delPropertyValueIds.size() > 0) {
                excludeMaterialIds.addAll(materialService.updateByPropertyValueDel(delPropertyValueIds));
            }

            if(null != enabled || null != blockFlag) {
                List<Long> categoryIds = new ArrayList<>();
                categoryIds.add(entity.getId());
                materialService.updateMaterialStatusByCategory(categoryIds, blockFlag,
                        enabled, ZDSMaterialCommonEnums.封存_正常.getCode(), newCategoryName, excludeMaterialIds);
            } else if(StringUtils.isNotBlank(newCategoryName)) {
                //若需要更新分类名称
                materialService.updateCategoryName(entity.getId(), newCategoryName, excludeMaterialIds);
            }
        } else {
            entity.setPropertyShowName(null);
        }

        super.saveOrUpdate(entity, false);

        Map<String, Object> syncParams = new HashedMap();
        syncParams.put("categoryId", entity.getId());
        syncToErp(syncParams);
        return BeanMapper.map(entity, MaterialCategoryVO.class);
    }

    @Override
    public List<MaterialCategoryEntity> queryByCodes(List<String> codes) {
        QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
        query.in("code", codes);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);
        return super.list(query);
    }

    @Override
    public List<MaterialCategoryVO> queryAllByPid(Long categoryId, Integer enabledStatus) {
        List<MaterialCategoryVO> resp = new ArrayList<>();

        MaterialCategoryEntity parent = super.selectById(categoryId);

        if(null != parent) {
            QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
            query.likeRight("inner_code", parent.getInnerCode());
            query.eq("tenant_id", InvocationInfoProxy.getTenantid());
            if(null != enabledStatus) {
                query.eq("enabled", enabledStatus);
            }
            query.eq("dr", BaseVO.DR_UNDELETE);

            List<MaterialCategoryEntity> children = super.list(query);
            if(CollectionUtils.isNotEmpty(children)) {
                resp = BeanMapper.mapList(children, MaterialCategoryVO.class);
            }
        }

        return resp;
    }

    @Override
    public void updateEnabledStatus(MaterialCategoryEntity dbEntity) {
        List<MaterialCategoryEntity> updateList = new ArrayList<>();
        MaterialCategoryEntity parent = null;
        if(ZDSMaterialCommonEnums.停启用_停用.getCode().equals(dbEntity.getEnabled())) {
            //查询 本下所有启用的分类Id
            List<MaterialCategoryVO> categoryVOS = queryAllByPid(dbEntity.getId(), ZDSMaterialCommonEnums.停启用_启用.getCode());
            List<Long> categoryIds = categoryVOS.stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());

            //判断当前分类是否存在父级，若存在则判断父级下分类是否存在其他启用子分类，若不存在则停用该父分类
            if(null != dbEntity.getParentId()) {
                List<MaterialCategoryVO> childsByParent = queryAllByPid(dbEntity.getParentId(), ZDSMaterialCommonEnums.停启用_启用.getCode());
                if(CollectionUtils.isEmpty(childsByParent) || childsByParent.size() <= 1) {
                    parent = super.selectById(dbEntity.getParentId());
                    parent.setEnabled(ZDSMaterialCommonEnums.停启用_停用.getCode());
                }
            }

            //停用时，将分类下所有的物资设置为停用状态 封村状态的物料明细不做处理
            materialService.updateMaterialStatusByCategory(categoryIds,
                    null,
                    ZDSMaterialCommonEnums.停启用_停用.getCode(),
                    ZDSMaterialCommonEnums.封存_正常.getCode(), null, null);
        } else {
            //查询 本下所有启用的分类Id
            List<MaterialCategoryVO> categoryVOS = queryAllByPid(dbEntity.getId(), ZDSMaterialCommonEnums.停启用_停用.getCode());
            List<Long> categoryIds = categoryVOS.stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());

            //判断当前分类是否存在父分类，若存在父分类，则启用该父分类
            if(null != dbEntity.getParentId()) {
                parent = super.selectById(dbEntity.getParentId());
                parent.setEnabled(ZDSMaterialCommonEnums.停启用_启用.getCode());
            }

            //启用时，将分类下所有的物资设置为启用状态 封村状态的物料明细不做处理
            materialService.updateMaterialStatusByCategory(categoryIds,
                    null,
                    ZDSMaterialCommonEnums.停启用_启用.getCode(),
                    ZDSMaterialCommonEnums.封存_正常.getCode(), null, null);
        }

        updateList.add(dbEntity);
        if(null != parent) {
            updateList.add(parent);
        }

        super.saveOrUpdateBatch(updateList, updateList.size(), false);
    }

    @Override
    public List<Long> queryChildrenIdsByPIds(List<Long> ids) {
        QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
        query.in("id", ids);
        query.orderByDesc("inner_code");
        List<MaterialCategoryEntity> categorys = super.list(query);

        QueryWrapper<MaterialCategoryEntity> listQuery = new QueryWrapper<>();
        listQuery.select("id");
        listQuery.eq("dr", BaseVO.DR_UNDELETE);
        listQuery.and( q -> {
            for(MaterialCategoryEntity m : categorys) {
                q.or(iq -> iq.likeRight("inner_code", m.getInnerCode()));
            }
           return q;
        });

        List<Object> idList = super.listObjs(listQuery);

        return idList.stream().map(item -> Long.valueOf(item.toString())).collect(Collectors.toList());
    }

    @Override
    public List<MaterialCategoryEntity> selectByName(String name, Long id) {
        QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
        query.eq("name", name);
        if(null != id) {
            query.ne("id", id);
        }
        return super.list(query);
    }

    @Override
    public String generateBillCode(String code) {
        QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper();
        query.likeRight("code", code);
        List<MaterialCategoryEntity> codeList = super.list(query);
        String billCode = null;
        List<String> codes = codeList.stream().map(MaterialCategoryEntity::getCode).collect(Collectors.toList());


        MaterialCategoryEntity codeEntity = selectByCode(code);
        long curSize = codeList.stream().filter(item -> item.getInnerCode().indexOf(codeEntity.getId().toString()) >= 0).count();

        curSize++;
        billCode = code + (curSize < 10 ? "0"+curSize : curSize);
        if(CollectionUtils.isNotEmpty(codes)) {
            List<String> codeStr = codes.parallelStream().map(item -> item.toString()).collect(Collectors.toList());
            while (codeStr.contains(billCode)) {
                curSize++;
                billCode = code + (curSize < 10 ? "0"+curSize : curSize);
            }
        }
        return billCode;
    }

    @Override
    public List<MaterialCategoryEntity> queryByCode(String code) {
        QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
        query.eq("code", code);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        return super.list(query);
    }

    @Override
    public MaterialCategoryVO queryDetail(Long id) {
        MaterialCategoryVO resp = null;
        MaterialCategoryEntity e = super.selectById(id);
        if(null != e) {
           resp = BeanMapper.map(e, MaterialCategoryVO.class);
        }

        return resp;
    }

    @Override
    public Map<Long, List<MaterialCategoryVO>> queryCategoryListByMaterialId(List<Long> ids) {
        List<MaterialVO> materials = materialService.queryDetailList(ids, false);

        Map<Long, List<MaterialCategoryVO>> resMap = new HashMap<>();
        Map<String, Object> params = new HashMap<>();

        QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("enabled", ZDSMaterialCommonEnums.停启用_启用.getCode());
        List<MaterialCategoryEntity> materialCategoryList = super.list(query);

        if(materialCategoryList != null && materialCategoryList.size() > 0) {
            List<MaterialCategoryVO> materialCategoryVOS =  BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
            Map<Long, MaterialCategoryVO> categoryVOMap = materialCategoryVOS.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
            for(MaterialVO materialVO : materials){
                Long categoryId = materialVO.getCategoryId();
                MaterialCategoryVO categoryVO = categoryVOMap.get(categoryId);
                String innerCode = categoryVO.getInnerCode();
                String[] keyArray = innerCode.split("\\|");
                List<MaterialCategoryVO> result = new ArrayList<>();
                for(int i = keyArray.length - 1; i >= 0; i --){
                    Long key = Long.valueOf(keyArray[i]);
                    if(categoryVOMap.containsKey(key)) {
                        result.add(categoryVOMap.get(key));
                    }
                }
                resMap.put(materialVO.getId(), result);
            }
        }

        return null;
    }

    @Override
    public List<MaterialCategoryVO> queryCategoryListByIds(List<Long> ids) {
        List<MaterialCategoryVO> resp = new ArrayList<>();
        QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
        query.in("id", ids);

        List<MaterialCategoryEntity> list = super.list(query);
        if(CollectionUtils.isNotEmpty(list)) {
            resp = BeanMapper.mapList(list, MaterialCategoryVO.class);
        }

        return resp;
    }

    @Override
    public List<MaterialCategoryVO> queryCategoryListByChildren(List<Long> ids) {

        List<MaterialCategoryVO> result = new ArrayList<>();
        Map<String, Object> params = new HashMap<>();

        QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("enabled", ZDSMaterialCommonEnums.停启用_启用.getCode());
        List<MaterialCategoryEntity> materialCategoryList = super.list(query);
        if(CollectionUtils.isNotEmpty(materialCategoryList)) {
            Set<Long> keySet = new HashSet<>();
            List<MaterialCategoryVO> materialCategoryVOS =  BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
            Map<Long, MaterialCategoryVO> categoryVOMap = materialCategoryVOS.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
            for(Long id : ids){
                MaterialCategoryVO categoryVO = categoryVOMap.get(id);
                if(null == categoryVO) {
                    continue;
                }
                String innerCode = categoryVO.getInnerCode();
                String[] keyArray = innerCode.split("\\|");
                for(String keyStr : keyArray){
                    Long key = Long.valueOf(keyStr);
                    if(!keySet.contains(key) && categoryVOMap.containsKey(key)){
                        keySet.add(key);
                        result.add(categoryVOMap.get(key));
                    }
                }
            }
        }

        return result;
    }

    @Override
    public List<MaterialCategoryEntity> getAllCategoryByLeafNodeId(Long categoryId) {
        MaterialCategoryEntity category = selectById(categoryId);

        QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.likeRight("inner_code", category.getInnerCode().split("\\|")[0]);
        query.eq("enabled", ZDSMaterialCommonEnums.停启用_启用.getCode());
        query.orderByAsc("inner_code");

        return super.list(query);
    }

    @Override
    public long countCategory(Map<String, Object> params) {
        return mapper.countCategory(params);
    }

    @Override
    public List<Map> getSyncList(Map<String, Object> params) {
        return mapper.getSyncList(params);
    }

    @Override
    public void updateCoordination(MaterialCategoryVO materialCategoryVO) {
        MaterialCategoryEntity categoryEntity = super.selectById(materialCategoryVO.getId());

        if(null != categoryEntity) {
            UpdateWrapper<MaterialCategoryEntity> update = new UpdateWrapper<>();
            if(ZDSMaterialCommonEnums.协同验收_是.getCode().equals(materialCategoryVO.getCoordinationFlag())) {
                //开启协同，将本下所有分类的协同设置为是
                update.likeRight("inner_code", categoryEntity.getInnerCode());
                update.eq("coordination_flag", ZDSMaterialCommonEnums.协同验收_否.getCode());
                update.set("coordination_flag", ZDSMaterialCommonEnums.协同验收_是.getCode());
            } else {
                //关闭协同，将本上所有分类的协同设置为否
                update.in("id", Arrays.asList(categoryEntity.getInnerCode().split("\\|")).stream().map(item -> Long.valueOf(item)).collect(Collectors.toList()));
                update.eq("coordination_flag", ZDSMaterialCommonEnums.协同验收_是.getCode());
                update.set("coordination_flag", ZDSMaterialCommonEnums.协同验收_否.getCode());
            }
            update.set("update_user_code", InvocationInfoProxy.getUsercode());
            update.set("update_time", new Date());
            super.update(update);
        }
    }

    @Override
    public List<MaterialCategoryEntity> getAllLeafByPids(List<Long> ids, Integer enabledStatus) {
        QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
        query.in("id", ids);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("enabled", enabledStatus);
        query.orderByDesc("inner_code");
        List<MaterialCategoryEntity> categorys = super.list(query);

        QueryWrapper<MaterialCategoryEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("dr", BaseVO.DR_UNDELETE);
        listQuery.eq("property_flag", ZDSMaterialCommonEnums.分类设置属性_是.getCode());
        listQuery.and( q -> {
            for(MaterialCategoryEntity m : categorys) {
                q.or(iq -> iq.likeRight("inner_code", m.getInnerCode()));
            }
            return q;
        });

        return super.list(listQuery);
    }

    @Override
    public void syncToErp(Map<String, Object> queryParams) {
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + MATERIAL_CATEGORY_SYNC_URL;
        List<Map> syncList = getSyncList(queryParams);
        Map<String, String> headers = null;
        try {
            if(CollectionUtils.isEmpty(syncList)) {
                logger.info("待推送ERP物料档案分类为空，同步任务执行结束！！！");
                return;
            }

            logger.info("本次待推送ERP物料档案数据：{}条", syncList.size());
            String reqResp = null;

            logger.error("物料档案推送ERP，：请求地址-{},参数-{}", reqUrl, JSONObject.toJSONString(syncList));

            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            reqResp = HttpTookit.postByJson(reqUrl,
                    JSONObject.toJSONString(syncList), headers, ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);
            logger.info("物料分类推送 ERP结果：{}", reqResp);
            JSONObject syncResultJson = JSONObject.parseObject(reqResp);

            if("ok".equals(syncResultJson.getString("Status"))) {
                logger.error("物料分类推送ERP，请求结果返回成功，处理结果：{}", syncResultJson.getString("info"));
            }else {
                logger.error("物料分类推送ERP失败：请求地址-{},参数-{},header-{},结果-{}",
                        reqUrl, JSONObject.toJSONString(syncList), JSONObject.toJSONString(headers, SerializerFeature.PrettyFormat), reqResp);
            }
        } catch (Exception e) {
            logger.error("物料档案推送ERP异常，：请求地址-{},参数-{},header-{}",
                    reqUrl, JSONObject.toJSONString(syncList), JSONObject.toJSONString(headers, SerializerFeature.PrettyFormat), e);
        }
    }

    @Override
    public List<MaterialCategoryVO> getAllByIds(List<Long> ids) {
        List<MaterialCategoryVO> resp = new ArrayList<>();

        QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
        query.in("id", ids);
        List<MaterialCategoryEntity> dbList = super.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            resp = BeanMapper.mapList(dbList, MaterialCategoryVO.class);
        }

        return resp;
    }

    @Override
    public String queryPidCodeByCode(String code) {
        MaterialCategoryEntity codeEntity = selectByCode(code);
        MaterialCategoryEntity materialCategoryEntity = super.selectById(codeEntity.getParentId());
        return materialCategoryEntity.getCode();
    }

    @Override
    public List<MaterialCategoryVO> getAllBySourceIds(List<String> sourceIds, Integer propertyFlag) {
        List<MaterialCategoryVO> resp = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(sourceIds)) {
            QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
            query.in("source_id", sourceIds);
            if(null != propertyFlag) {
                query.eq("property_flag", propertyFlag);
            }
            List<MaterialCategoryEntity> dbList = super.list(query);
            if(CollectionUtils.isNotEmpty(dbList)) {
                resp = BeanMapper.mapList(dbList, MaterialCategoryVO.class);
            }
        }

        return resp;
    }

    @Override
    public List<MaterialCategoryEntity> getParentsByChildId(Long id) {
        MaterialCategoryEntity category = super.selectById(id);

        QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("id", Arrays.stream(category.getInnerCode().split("\\|")).map(Long::parseLong).collect(Collectors.toList()));
        return super.list(query);
    }

    @Override
    public List<MaterialCategoryEntity> getChildrenByPid(Long id) {
        MaterialCategoryEntity category = super.selectById(id);

        QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.likeRight("inner_code", category.getInnerCode());
        return super.list(query);
    }

    @Override
    @Async(value = "maContextCommonTask")
    public void pushToErp(DataPushErpParam pushParam) {
        logger.info("物料分类推送ERP-------------开始----------------");
        logger.info("本次推送ERP物料分类：{}, 推送类型: {}", JSONObject.toJSONString(pushParam.getPushCategory()), pushParam.getBillType());
        //上下文准备
        if(null == InvocationInfoProxy.getUserid() && null != pushParam.getOperatorId()) {
            initContext(pushParam.getOperatorId());
        }

        String pushResult = null;
        //推送地址
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + MATERIAL_CATEGORY_SYNC_URL;

        CommonResponse<UserVO> userResp = userApi.findUserByUserId(pushParam.getOperatorId());
        if(!userResp.isSuccess() || null == userResp.getData()) {
            logger.error("查询人员id-{}信息失败，{}", pushParam.getOperatorId(), JSONObject.toJSONString(userResp));
            throw new BusinessException("查询人员信息失败");
        }
        UserVO user = userResp.getData();

        //推送参数记录
        MaPushErpRecordsEntity record = new MaPushErpRecordsEntity();
        record.setData(JSONObject.toJSONString(pushParam.getPushData()));
        record.setOperatorId(pushParam.getOperatorId());
        record.setOperatorName(user.getUserName());
        record.setBillType(pushParam.getBillType());
        record.setPushDate(new Date());
        record.setUrl(reqUrl);

        //组装推送参数
        List<JSONObject> pushParams = new ArrayList<>();
        JSONObject syncItem = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for(MaterialCategoryVO categoryVO : pushParam.getPushCategory()) {
            syncItem = new JSONObject();
            if(null != categoryVO.getParentId() && !PlanConstant.INTEGER_YES.equals(categoryVO.getPropertyFlag())) {
                //只推送二级分类
                syncItem.put("C_SD_GoodsTypeOID", categoryVO.getSourceId()); //ERP sid
                syncItem.put("SYS_LAST_UPD", null != categoryVO.getCreateTime() || null != categoryVO.getUpdateTime() ?
                        sdf.format(null != categoryVO.getUpdateTime() ? categoryVO.getUpdateTime() : categoryVO.getCreateTime()) : null); //最后更新时间
                syncItem.put("Long_code", categoryVO.getCode()); //编码
                syncItem.put("Title", categoryVO.getName()); //名称
                syncItem.put("IsEnable", categoryVO.getEnabled()); //停启用
                syncItem.put("sequence", categoryVO.getSequence());//排序号
                syncItem.put("IsEnableBrand", categoryVO.getBrandControlFlag());//排序号
                syncItem.put("ParentOID", StringUtils.isBlank(categoryVO.getParentSourceId()) ? PlanConstant.EMPTY_STR : categoryVO.getParentSourceId());//父级分类SID
                syncItem.put("parentName", StringUtils.isNotBlank(categoryVO.getParentName()) ? categoryVO.getParentName() : "");//父级分类名称
                syncItem.put("parentCode", StringUtils.isNotBlank(categoryVO.getParentCode()) ? categoryVO.getParentCode() : ""); //父级分类编码
                syncItem.put("GoodsTypeLevel", categoryVO.getInnerCode().length() - categoryVO.getInnerCode().replaceAll("\\|","").length() + 1); //分类级别
                pushParams.add(syncItem);
            }
        }
        if(CollectionUtils.isEmpty(pushParams)) {
            logger.info("物料分类推送ERP-------------结束,本次没有可推送的二级分类信息 ----------------");
            return;
        }

        //推送ERP
        Map<String, String> headers = null;
        try {
            Stopwatch start = Stopwatch.createStarted();
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(pushParams),
                    headers, ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);

            logger.info("物料分类推送ERP：url-{}, 参数：{}，结果：{}", reqUrl,
                    JSONObject.toJSONString(pushParams, SerializerFeature.PrettyFormat), reqResp);
            Stopwatch stop = start.stop();

            record.setErpResult(reqResp);
            record.setErpHandleSeconds(stop.elapsed(TimeUnit.SECONDS));
            logger.info("物料分类推送ERP耗时：{}秒", record.getErpHandleSeconds());

            JSONObject reqJson = JSONObject.parseObject(reqResp);
            if("ok".equals(reqJson.getString("Status"))) {
                pushResult = PlanConstant.STRING_YES;
            } else {
                pushResult = PlanConstant.STRING_NO;
                record.setFailType("ERP数据处理失败！");
            }
            record.setSucFlag(pushResult);

        } catch (Exception e) {
            logger.error("物料分类同步ERP异常，", e);
            record.setSucFlag(PlanConstant.STRING_NO);
            pushResult = PlanConstant.STRING_NO;
            record.setFailType("物料分类同步ERP，请求异常！");
        }

        //推送记录放入待处理队列中
        queueUtils.sendMq(PushErpRecordListener.PUSH_ERP_RECORD_QUEUE +"_"+profile, JSONObject.toJSONString(record));
        logger.info("物料分类推送ERP-------------结束----------------");
    }

    @Override
    public List<Map> queryListMap(Map<String, Object> condition) {
        return mapper.queryListMap(condition);
    }

    @Override
    public List<MaterialCategoryVO> getMaterialSecondCategoryList() {
        QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
        query.isNotNull("parent_id");
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("property_flag", 0);
        query.eq("enabled", ZDSMaterialCommonEnums.停启用_启用.getCode());
        List<MaterialCategoryEntity> categorys = super.list(query);
        return BeanMapper.mapList(categorys, MaterialCategoryVO.class);
    }

    private void initContext(Long userId) {
        String initContextUrl = environmentTools.getBaseHost() + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        initContextUrl = initContextUrl + "&userId="+userId.toString();
        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);

        CommonResponse<JSONObject> userContextResponse = JSON.parseObject(responseStr, CommonResponse.class);
        try {
            if(userContextResponse.isSuccess()) {
                JSONObject userContext =userContextResponse.getData().getJSONObject("userContext");
                StringBuilder authtoken = new StringBuilder();
                if(null != userContext) {
                    authtoken.append("userType=").append(userContext.get("userType"))
                            .append(";userCode=").append(userContext.get("userCode"))
                            .append(";orgId=").append(userContext.get("orgId"))
                            .append(";tenantid=").append(userContext.get("tenantid"))
                            .append(";token=").append(userContext.get("token"))
                            .append(";u_logints=").append(userContext.get("u_logints"))
                            .append(";u_usercode=").append(userContext.get("u_usercode"))
                            .append(";userId=").append(userContext.get("userId"));
                }
                if(authtoken.length() > 0) {
                    InvocationInfoProxy.setExtendAttribute("authority", authtoken.toString());
                    InvocationInfoProxy.setParameter(ReferConstant.HEAD_authority, authtoken.toString());
                }
                if(null != userContext) {
                    InvocationInfoProxy.setTenantid(userContext.getLong("tenantid"));
                    InvocationInfoProxy.setUserid(userContext.getLong("userId"));
                    InvocationInfoProxy.setUsercode(userContext.getString("userCode"));
                    InvocationInfoProxy.setOrgId(userContext.getLong("orgId"));
                }
            }
        } catch (Exception e) {
            logger.error("初始化异步任务上下文异常：",e);
        }

    }
}
