package com.ejianc.business.zdsmaterial.plan.control.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 物资总控计划汇总
 *
 * @author generator
 *
 */
 @TableName("ejc_material_control_plan_sum")
public class ControlPlanSumEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_name")
    private String billName; // 单据名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="engineer_id")
    private Long engineerId; // 主责工程师
    @TableField(value="engineer_name")
    private String engineerName; // 主责工程师名称
    @TableField(value="manager_id")
    private Long managerId; // 项目总工
    @TableField(value="manager_name")
    private String managerName; // 项目总工名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="new_mat_flag")
    private Integer newMatFlag; // 是否有新增材料编码：0-否，1-是
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="project_manager_id")
    private Long projectManagerId; // 项目经理主键
    @TableField(value="project_manager_name")
    private String projectManagerName; // 项目经理名称
    @TableField(value="create_user_name")
    private String createUserName; // 创建者名称
    @TableField(value="first_time")
    private Date firstTime; // 初始签订日期
    @TableField(value="last_time")
    private Date lastTime; // 最新汇总日期
    @TableField(value="change_time")
    private Date changeTime; // 变更日期
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态：1-未变更，2-变更中，3-已变更
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="material_type_names")
    private String materialTypeNames; // 材料分类
    @TableField(value = "create_user_id")
    private Long createUserId;// 制单人Id

    @TableField(value="exe_org_id")
    private Long exeOrgId; // 执行总部id
    @TableField(value="exe_org_code")
    private String exeOrgCode; // 执行总部编码
    @TableField(value="exe_org_name")
    private String exeOrgName; // 执行总部名称


    @TableField(exist=false)
    @SubEntity(serviceName="controlPlanSumDetailService", pidName = "planId")
    private List<ControlPlanSumDetailEntity> detailList = new ArrayList<>(); // 物资总控计划汇总明细


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getBillName() {
        return billName;
    }

    public void setBillName(String billName) {
        this.billName = billName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getEngineerId() {
        return engineerId;
    }

    public void setEngineerId(Long engineerId) {
        this.engineerId = engineerId;
    }
    public String getEngineerName() {
        return engineerName;
    }

    public void setEngineerName(String engineerName) {
        this.engineerName = engineerName;
    }
    public Long getManagerId() {
        return managerId;
    }

    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }
    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getNewMatFlag() {
        return newMatFlag;
    }

    public void setNewMatFlag(Integer newMatFlag) {
        this.newMatFlag = newMatFlag;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectManagerId() {
        return projectManagerId;
    }

    public void setProjectManagerId(Long projectManagerId) {
        this.projectManagerId = projectManagerId;
    }
    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Date getFirstTime() {
        return firstTime;
    }

    public void setFirstTime(Date firstTime) {
        this.firstTime = firstTime;
    }
    public Date getLastTime() {
        return lastTime;
    }

    public void setLastTime(Date lastTime) {
        this.lastTime = lastTime;
    }
    public Date getChangeTime() {
        return changeTime;
    }

    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public String getMaterialTypeNames() {
        return materialTypeNames;
    }

    public void setMaterialTypeNames(String materialTypeNames) {
        this.materialTypeNames = materialTypeNames;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public Long getExeOrgId() {
        return exeOrgId;
    }

    public void setExeOrgId(Long exeOrgId) {
        this.exeOrgId = exeOrgId;
    }

    public String getExeOrgCode() {
        return exeOrgCode;
    }

    public void setExeOrgCode(String exeOrgCode) {
        this.exeOrgCode = exeOrgCode;
    }

    public String getExeOrgName() {
        return exeOrgName;
    }

    public void setExeOrgName(String exeOrgName) {
        this.exeOrgName = exeOrgName;
    }

    public List<ControlPlanSumDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ControlPlanSumDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
