package com.ejianc.business.zdsmaterial.pricelib.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.pricelib.bean.MaterialPriceCalcEntity;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcService;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 价格公式设置主实体
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("materialPriceCalc")
public class MaterialPriceCalcController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMaterialPriceCalcService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMaterialCategoryService categoryService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialPriceCalcVO> saveOrUpdate(@RequestBody MaterialPriceCalcVO saveOrUpdateVO) {
    	MaterialPriceCalcEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialPriceCalcEntity.class);
    	service.saveOrUpdate(entity, false);
    	MaterialPriceCalcVO vo = BeanMapper.map(entity, MaterialPriceCalcVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialPriceCalcVO> queryDetail(Long id) {
    	MaterialPriceCalcEntity entity = service.selectById(id);
    	MaterialPriceCalcVO vo = BeanMapper.map(entity, MaterialPriceCalcVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialPriceCalcVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MaterialPriceCalcVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MaterialPriceCalcVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    @PostMapping(value = "/changeBaseMaterial")
    public CommonResponse<MaterialPriceCalcVO> changeBaseMaterial(@RequestBody MaterialPriceCalcVO materialPriceCalcVO) {
        MaterialPriceCalcEntity calc = service.selectByCategoryId(materialPriceCalcVO.getId());
        if(null != materialPriceCalcVO.getEnabled()) {
            calc.setEnabled(materialPriceCalcVO.getEnabled());
        } else {
            calc.setMaterialTypeId(materialPriceCalcVO.getMaterialTypeId());
            calc.setMaterialTypeName(materialPriceCalcVO.getMaterialTypeName());
            calc.setMaterialTypeName(materialPriceCalcVO.getMaterialTypeName());
        }

        service.saveOrUpdate(calc, false);

        return CommonResponse.success(BeanMapper.map(calc, MaterialPriceCalcVO.class));
    }

    @GetMapping(value = "/getCategoryTree")
    public CommonResponse<List<Map<String, Object>>> getCategoryTree(@RequestParam(required = false) String categoryCode,
                                                                     @RequestParam(required = false) String categoryName) {
        QueryParam query = new QueryParam();
        if(StringUtils.isNotBlank(categoryCode)) {
            query.getParams().put("categoryCode", new Parameter(QueryParam.LIKE, categoryCode));
        }
        if(StringUtils.isNotBlank(categoryName)) {
            query.getParams().put("categoryName", new Parameter(QueryParam.LIKE, categoryName));
        }

        List<MaterialPriceCalcEntity> dataList = service.queryList(query);

        if(CollectionUtils.isNotEmpty(dataList)) {
            Map<Long, MaterialPriceCalcEntity> detailMap = dataList.stream().collect(Collectors.toMap(MaterialPriceCalcEntity::getCategoryId, Function.identity()));

            List<Long> categoryIds = dataList.stream().map(MaterialPriceCalcEntity::getCategoryId).collect(Collectors.toList());
            List<MaterialCategoryVO> categoryVOS = categoryService.queryCategoryListByChildren(categoryIds);
            categoryVOS.stream().filter(item -> detailMap.containsKey(item.getId())).forEach(item -> {
                item.setMaterialType(detailMap.get(item.getId()).getMaterialType());
                item.setMaterialTypeId(detailMap.get(item.getId()).getMaterialTypeId());
                item.setMaterialTypeName(detailMap.get(item.getId()).getMaterialTypeName());
                item.setEnabled(detailMap.get(item.getId()).getEnabled());
                item.setCalcFields(detailMap.get(item.getId()).getCalcFields());
            });
            return CommonResponse.success("操作成功！", ResultAsTree.createTreeData(BeanMapper.mapList(categoryVOS, Map.class)));
        }
        return CommonResponse.success( "查询成功", new ArrayList<>());
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialPriceCalcVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<MaterialPriceCalcEntity> page = service.queryPage(param,false);
        IPage<MaterialPriceCalcVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialPriceCalcVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<MaterialPriceCalcEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialPriceCalc-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMaterialPriceCalcData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialPriceCalcVO>> refMaterialPriceCalcData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaterialPriceCalcEntity> page = service.queryPage(param,false);
        IPage<MaterialPriceCalcVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialPriceCalcVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
