package com.ejianc.business.zdsmaterial.sub.setting.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.zdsmaterial.sub.setting.bean.SubCheckerSettingEntity;
import com.ejianc.business.zdsmaterial.sub.setting.service.ISubCheckerSettingService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.zdsmaterial.sub.setting.bean.SubOrgSettingEntity;
import com.ejianc.business.zdsmaterial.sub.setting.service.ISubOrgSettingService;
import com.ejianc.business.zdsmaterial.sub.setting.vo.SubOrgSettingVO;

/**
 * 分包发票审核人员设置-执行部门
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subOrgSetting")
public class SubOrgSettingController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;


    @Autowired
    private ISubOrgSettingService service;

    @Autowired
    private ISubCheckerSettingService subCheckerSettingService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubOrgSettingVO> saveOrUpdate(@RequestBody SubOrgSettingVO saveOrUpdateVO) {
        LambdaQueryWrapper<SubOrgSettingEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SubOrgSettingEntity::getOrgId, saveOrUpdateVO.getOrgId());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), SubOrgSettingEntity::getId, saveOrUpdateVO.getId());
        if(service.count(queryWrapper) > 0){
            throw new BusinessException("该组织已添加过执行部门,不允许重复添加!");
        }
    	SubOrgSettingEntity entity = BeanMapper.map(saveOrUpdateVO, SubOrgSettingEntity.class);
    	service.saveOrUpdate(entity, false);
    	SubOrgSettingVO vo = BeanMapper.map(entity, SubOrgSettingVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubOrgSettingVO> queryDetail(Long id) {
    	SubOrgSettingEntity entity = service.selectById(id);
    	SubOrgSettingVO vo = BeanMapper.map(entity, SubOrgSettingVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubOrgSettingVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SubOrgSettingVO vo : vos) {
                SubOrgSettingEntity entity = service.selectById(vo.getId());
                LambdaQueryWrapper<SubCheckerSettingEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(SubCheckerSettingEntity::getOrgId, entity.getOrgId());
                if (subCheckerSettingService.count(queryWrapper) > 0) {
                    CommonResponse<OrgVO> response = iOrgApi.getOneById(entity.getOrgId());
                    throw new BusinessException("组织名称[" + response.getData().getName() + "]下存在审核人员，不允许删除!");
                }
            }
        }
        service.removeByIds(vos.stream().map(SubOrgSettingVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubOrgSettingVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<SubOrgSettingEntity> page = service.queryPage(param,false);
        IPage<SubOrgSettingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubOrgSettingVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubOrgSettingEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubOrgSetting-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubOrgSettingData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubOrgSettingVO>> refSubOrgSettingData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubOrgSettingEntity> page = service.queryPage(param,false);
        IPage<SubOrgSettingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubOrgSettingVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
