package com.ejianc.business.zdsmaterial.erp.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 订单明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_order_detail")
public class OrderDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="order_id")
    private Long orderId; // 订单Id
    @TableField(value="source_order_id")
    private String sourceOrderId; // ERP订单Id
    @TableField(value="source_order_detail_id")
    private String sourceOrderDetailId; // ERP订单子表Id
    @TableField(value="contract_detail_id")
    private Long contractDetailId; // 对应合同子表主键，只有总价合同有值
    @TableField(value="material_id")
    private Long materialId; // 物资id
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="material_code")
    private String materialCode; // 物资编码
    @TableField(value="material_type_name")
    private String materialTypeName; // 物资分类名称
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物资分类id
    @TableField(value="material_serial_no")
    private String materialSerialNo; // 物资流水号
    @TableField(value="source_contract_id")
    private String sourceContractId; // ERP合同id
    @TableField(value="source_contract_detail_id")
    private String sourceContractDetailId; // ERP合同明细id, 仅合同为总价合同是有值
    @TableField(value="contract_num")
    private BigDecimal contractNum; // 合同量，注：总价合同量等于该值，单价合同时为空
    @TableField(value="detail_num")
    private BigDecimal detailNum; // 采购量
    @TableField(value="detail_tax_price")
    private BigDecimal detailTaxPrice; // 采购单价(含税)
    @TableField(value="detail_price")
    private BigDecimal detailPrice; // 采购单价
    @TableField(value="detail_tax_rate")
    private BigDecimal detailTaxRate; // 税率
    @TableField(value="detail_tax_mny")
    private BigDecimal detailTaxMny; // 采购金额(含税)
    @TableField(value="detail_mny")
    private BigDecimal detailMny; // 采购金额
    @TableField(value="detail_tax")
    private BigDecimal detailTax; // 税额
    @TableField(value="detail_unit_name")
    private String detailUnitName; // 计量单位
    @TableField(value="detail_unit_id")
    private Long detailUnitId; // 计量单位id
    @TableField(value="delivered_num")
    private BigDecimal deliveredNum; // 已发货量
    @TableField(value = "accepted_num")
    private BigDecimal acceptedNum; //已验收量
    @TableField(value="hand_accept_num")
    private BigDecimal handAcceptNum; // 自制验收量
    @TableField(value="property_value")
    private String propertyValue; // 属性
    @TableField(value="memo")
    private String memo; // 备注

    @TableField(value = "product_code")
    private String productCode;

    @TableField(value = "brand_id")
    private Long brandId; //品牌主键
    @TableField(value = "brand_sid")
    private String brandSid; //品牌ERP主键
    @TableField(value = "brand_name")
    private String brandName; // 品牌名称
    @TableField(value="material_type_code")
    private String materialTypeCode; // 物资分类编码

    public String getBrandSid() {
        return brandSid;
    }

    public void setBrandSid(String brandSid) {
        this.brandSid = brandSid;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }
    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public BigDecimal getAcceptedNum() {
        return acceptedNum;
    }

    public void setAcceptedNum(BigDecimal acceptedNum) {
        this.acceptedNum = acceptedNum;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    public String getSourceOrderId() {
        return sourceOrderId;
    }

    public void setSourceOrderId(String sourceOrderId) {
        this.sourceOrderId = sourceOrderId;
    }
    public String getSourceOrderDetailId() {
        return sourceOrderDetailId;
    }

    public void setSourceOrderDetailId(String sourceOrderDetailId) {
        this.sourceOrderDetailId = sourceOrderDetailId;
    }
    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialSerialNo() {
        return materialSerialNo;
    }

    public void setMaterialSerialNo(String materialSerialNo) {
        this.materialSerialNo = materialSerialNo;
    }
    public String getSourceContractId() {
        return sourceContractId;
    }

    public void setSourceContractId(String sourceContractId) {
        this.sourceContractId = sourceContractId;
    }
    public String getSourceContractDetailId() {
        return sourceContractDetailId;
    }

    public void setSourceContractDetailId(String sourceContractDetailId) {
        this.sourceContractDetailId = sourceContractDetailId;
    }
    public BigDecimal getContractNum() {
        return contractNum;
    }

    public void setContractNum(BigDecimal contractNum) {
        this.contractNum = contractNum;
    }
    public BigDecimal getDetailNum() {
        return detailNum;
    }

    public void setDetailNum(BigDecimal detailNum) {
        this.detailNum = detailNum;
    }
    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }
    public BigDecimal getDetailPrice() {
        return detailPrice;
    }

    public void setDetailPrice(BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }
    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }
    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }
    public String getDetailUnitName() {
        return detailUnitName;
    }

    public void setDetailUnitName(String detailUnitName) {
        this.detailUnitName = detailUnitName;
    }
    public Long getDetailUnitId() {
        return detailUnitId;
    }

    public void setDetailUnitId(Long detailUnitId) {
        this.detailUnitId = detailUnitId;
    }
    public BigDecimal getDeliveredNum() {
        return deliveredNum;
    }

    public void setDeliveredNum(BigDecimal deliveredNum) {
        this.deliveredNum = deliveredNum;
    }
    public BigDecimal getHandAcceptNum() {
        return handAcceptNum;
    }

    public void setHandAcceptNum(BigDecimal handAcceptNum) {
        this.handAcceptNum = handAcceptNum;
    }
    public String getPropertyValue() {
        return propertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
