package com.ejianc.business.zdsmaterial.pricelib.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 价格公式设置主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_price_calc_setting")
public class MaterialPriceCalcEntity extends BaseEntity {

    private static final long serialVersionUID = -7283001781394926295L;
    @TableField(value="create_user_name")
    private String createUserName; // 创建人名称
    @TableField(value="modify_user_name")
    private String modifyUserName; // 修改人名称
    @TableField(value="enabled")
    private Integer enabled; // 停启用：0-停用，1-启用

    @TableField(value = "material_type_id")
    private Long materialTypeId;//材料类型Id
    @TableField(value="material_type")
    private String materialType; // 材料类型编码:Tong-铜，Lv-铝,Gang-钢材，Bxg-不锈钢
    @TableField(value="material_type_name")
    private String materialTypeName; // 材料类型
    @TableField(value="category_id")
    private Long categoryId; // 物料分类Id

    @TableField(value = "category_code")
    private String categoryCode; // 物料分类编码

    @TableField(value = "category_name")
    private String categoryName; // 物料分类名称

    @TableField(value = "calc_fields")
    private String calcFields; //辅助计算字段 JsonArr

    @SubEntity(serviceName = "materialPriceCalcSubConditionService")
    @TableField(exist = false)
    private List<MaterialPriceCalcSubConditionEntity> conditionList = new ArrayList<>(); // 计算公式条件列表

    public String getCalcFields() {
        return calcFields;
    }

    public void setCalcFields(String calcFields) {
        this.calcFields = calcFields;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public List<MaterialPriceCalcSubConditionEntity> getConditionList() {
        return conditionList;
    }

    public void setConditionList(List<MaterialPriceCalcSubConditionEntity> conditionList) {
        this.conditionList = conditionList;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }
    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }
    public String getMaterialType() {
        return materialType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    
}
