/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.asynchandler.service.impl;

import com.ejianc.business.zdsmaterial.asynchandler.bean.SyncJobExecRecordsEntity;
import com.ejianc.business.zdsmaterial.asynchandler.mapper.SyncJobExecRecordMapper;
import com.ejianc.business.zdsmaterial.asynchandler.service.ISyncJobExecRecordService;
import com.ejianc.business.zdssupplier.material.api.IMatLinkerApi;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.business.zdssupplier.sub.api.ISubLinkerApi;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="syncJobExecRecordService")
public class SyncJobExecRecordServiceImpl
extends BaseServiceImpl<SyncJobExecRecordMapper, SyncJobExecRecordsEntity>
implements ISyncJobExecRecordService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMatLinkerApi matLinkerApi;
    @Autowired
    private ISubLinkerApi subLinkerApi;

    @Override
    @Async(value="maContextCommonTask")
    public String linkerAccCoo(String linkerType, Long linkerId) {
        this.logger.info("*********INFO*********\u8054\u7cfb\u4eba\u7cfb\u7edf\u8d26\u53f7\u5f00\u901a\uff0c\u8054\u7cfb\u4eba\u7c7b\u578b:{}\uff0c\u8054\u7cfb\u4ebaID:{}********INFO********", (Object)linkerType, (Object)linkerId.toString());
        String execErrMsg = null;
        SyncJobExecRecordsEntity records = new SyncJobExecRecordsEntity();
        try {
            records.setReqParam(linkerId.toString());
            records.setExecTime(new Date());
            if ("material".equals(linkerType)) {
                records.setReqUrl("/api/matLinkerApi/accCoordination");
                MatLinkerVO matLinkerVO = new MatLinkerVO();
                matLinkerVO.setId(linkerId);
                CommonResponse resp = this.matLinkerApi.accCoordination(matLinkerVO);
                records.setExecResult(resp.isSuccess() ? "2" : "1");
                records.setErpErrResult(resp.getMsg());
                if (!resp.isSuccess()) {
                    execErrMsg = StringUtils.isNotBlank((CharSequence)resp.getMsg()) ? resp.getMsg() : "\u7f51\u7edc\u95ee\u9898\uff0c\u534f\u540c\u8d26\u53f7\u5f00\u901a\u5931\u8d25\uff01";
                }
            } else {
                records.setReqUrl("/api/subLinkerApi/accCoordination");
                LinkerVO linkerVO = new LinkerVO();
                linkerVO.setId(linkerId);
                CommonResponse resp = this.subLinkerApi.accCoordination(linkerVO);
                records.setExecResult(resp.isSuccess() ? "2" : "1");
                records.setErpErrResult(resp.getMsg());
                if (!resp.isSuccess()) {
                    execErrMsg = StringUtils.isNotBlank((CharSequence)resp.getMsg()) ? resp.getMsg() : "\u7f51\u7edc\u95ee\u9898\uff0c\u534f\u540c\u8d26\u53f7\u5f00\u901a\u5931\u8d25\uff01";
                }
            }
        }
        catch (Exception e) {
            this.logger.error("*********ERROR*********\u8054\u7cfb\u4eba\u7cfb\u7edf\u8d26\u53f7\u5f00\u901a \u5f02\u5e38\uff0c\u8054\u7cfb\u4eba\u7c7b\u578b:{}\uff0c\u8054\u7cfb\u4ebaID:{}********ERROR********", (Object)linkerType, (Object)linkerId.toString());
            this.logger.error("*********ERROR*********\u8054\u7cfb\u4eba\u7cfb\u7edf\u8d26\u53f7\u5f00\u901a \u5f02\u5e38\uff0c********ERROR********", (Throwable)e);
            execErrMsg = "\u7f51\u7edc\u95ee\u9898\uff0c\u534f\u540c\u8d26\u53f7\u5f00\u901a\u5931\u8d25\uff01";
        }
        super.saveOrUpdate((Object)records, false);
        return execErrMsg;
    }
}

