/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.erp.vo.DataPushErpParam;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertyEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertySubItemEntity;
import com.ejianc.business.zdsmaterial.material.service.IInvalidMatExaminerService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertyService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertySubItemService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"materialCategory"})
public class MaterialCategoryController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "ZDS_MASTERIAL_CATEGORY";
    @Autowired
    private IMaterialCategoryService service;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryPropertySubItemService materialCategoryPropertySubItemService;
    @Autowired
    private IMaterialCategoryPropertyService propertyService;
    @Autowired
    private IInvalidMatExaminerService invalidMatExaminerService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialCategoryVO> saveOrUpdate(@RequestBody MaterialCategoryVO saveOrUpdateVO) {
        MaterialCategoryEntity codeDbEntity;
        MaterialCategoryEntity entity = (MaterialCategoryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialCategoryEntity.class));
        if (entity.getPropertyFlag() == 1 && CollectionUtils.isNotEmpty(entity.getPropertyList())) {
            Integer maxSequence = 0;
            ArrayList<MaterialCategoryPropertyEntity> empSeq = new ArrayList<MaterialCategoryPropertyEntity>();
            HashMap propertySequenceMap = new HashMap();
            for (MaterialCategoryPropertyEntity property : entity.getPropertyList()) {
                String itemCheckMsg;
                if ("del".equals(property.getRowState())) continue;
                if (CollectionUtils.isNotEmpty(property.getItemList()) && StringUtils.isNotBlank((CharSequence)(itemCheckMsg = this.checkPropertyItem(property.getItemList())))) {
                    return CommonResponse.error((String)("\u5c5e\u6027\u3010" + property.getName() + "\u3011\u4e0b\u5b58\u5728\u5e8f\u53f7\u91cd\u590d\u7684\u5c5e\u6027\u503c\u3010" + itemCheckMsg + "\u3011"));
                }
                if (null == property.getSequence()) {
                    empSeq.add(property);
                    continue;
                }
                if (maxSequence < property.getSequence()) {
                    maxSequence = property.getSequence();
                }
                if (!propertySequenceMap.containsKey(property.getSequence())) {
                    propertySequenceMap.put(property.getSequence(), new ArrayList());
                }
                ((List)propertySequenceMap.get(property.getSequence())).add(property);
            }
            String repeatPropertyNames = propertySequenceMap.values().stream().filter(item -> item.size() > 1).flatMap(Collection::stream).map(item -> item.getName()).collect(Collectors.joining("\u3001"));
            if (StringUtils.isNotBlank((CharSequence)repeatPropertyNames)) {
                return CommonResponse.error((String)("\u5b58\u5728\u6392\u5e8f\u91cd\u590d\u7684\u5c5e\u6027\uff1a\u3010" + repeatPropertyNames + "\u3011"));
            }
            if (!empSeq.isEmpty()) {
                for (MaterialCategoryPropertyEntity property : empSeq) {
                    maxSequence = maxSequence + 1;
                    property.setSequence(maxSequence);
                }
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            if (StringUtils.isBlank((CharSequence)entity.getCode())) {
                String billCode = null;
                if (StringUtils.isNotBlank((CharSequence)saveOrUpdateVO.getParentCode())) {
                    billCode = this.service.generateBillCode(saveOrUpdateVO.getParentCode());
                } else {
                    BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                    CommonResponse billCodeResp = this.billCodeApi.generateBillCode(billCodeParam);
                    if (!billCodeResp.isSuccess()) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    billCode = (String)billCodeResp.getData();
                }
                entity.setCode(billCode);
            } else {
                codeDbEntity = this.service.selectByCode(entity.getCode());
                if (null != codeDbEntity) {
                    return CommonResponse.error((String)"\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u586b\u5199");
                }
            }
            entity.setSourceType("2");
            entity.setSourceId(UUID.randomUUID().toString());
        } else {
            codeDbEntity = this.service.selectByCode(entity.getCode());
            if (null != codeDbEntity && !codeDbEntity.getId().equals(entity.getId())) {
                return CommonResponse.error((String)"\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u586b\u5199");
            }
        }
        this.service.saveOrUpdateCategory(entity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.queryDetail(entity.getId()).getData());
    }

    private String checkPropertyItem(List<MaterialCategoryPropertySubItemEntity> itemList) {
        Integer maxSequence = 0;
        ArrayList<MaterialCategoryPropertySubItemEntity> empSeq = new ArrayList<MaterialCategoryPropertySubItemEntity>();
        HashMap propertySequenceMap = new HashMap();
        for (MaterialCategoryPropertySubItemEntity item2 : itemList) {
            if ("del".equals(item2.getRowState())) continue;
            if (null == item2.getSequence()) {
                empSeq.add(item2);
                continue;
            }
            if (maxSequence < item2.getSequence()) {
                maxSequence = item2.getSequence();
            }
            if (!propertySequenceMap.containsKey(item2.getSequence())) {
                propertySequenceMap.put(item2.getSequence(), new ArrayList());
            }
            ((List)propertySequenceMap.get(item2.getSequence())).add(item2);
        }
        String repeatPropertyNames = propertySequenceMap.values().stream().filter(item -> item.size() > 1).flatMap(Collection::stream).map(item -> item.getName()).collect(Collectors.joining("\u3001"));
        if (StringUtils.isNotBlank((CharSequence)repeatPropertyNames)) {
            return repeatPropertyNames;
        }
        if (!empSeq.isEmpty()) {
            for (MaterialCategoryPropertySubItemEntity item3 : empSeq) {
                maxSequence = maxSequence + 1;
                item3.setSequence(maxSequence);
            }
        }
        return null;
    }

    @GetMapping(value={"/generateBillCode"})
    public CommonResponse<String> generateBillCode(String code) {
        String billCode = this.service.generateBillCode(code);
        return CommonResponse.success((String)"\u7f16\u7801\u751f\u6210\u6210\u529f\uff01", (Object)billCode);
    }

    @PostMapping(value={"/findAllLeafIdsByCodes"})
    public CommonResponse<List<Long>> findAllLeafIdsByCategoryIds(@RequestBody String codes) {
        List<String> codeList = Arrays.asList(codes.split(","));
        List<MaterialCategoryEntity> categoryVOS = this.service.queryByCodes(codeList);
        List<MaterialCategoryEntity> childList = this.service.getAllLeafByPids(categoryVOS.stream().map(BaseEntity::getId).collect(Collectors.toList()), 1);
        return CommonResponse.success(childList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
    }

    @RequestMapping(value={"/updateEnabledStatus"}, method={RequestMethod.POST})
    public CommonResponse<String> updateEnabled(@RequestBody MaterialCategoryVO saveOrUpdateVO) {
        MaterialCategoryEntity dbEntity = (MaterialCategoryEntity)((Object)this.service.selectById(saveOrUpdateVO.getId()));
        dbEntity.setEnabled(saveOrUpdateVO.getEnabled());
        this.service.updateEnabledStatus(dbEntity);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialCategoryVO> queryDetail(Long id) {
        List<MaterialCategoryPropertySubItemVO> subVos;
        HashMap subOrderMap = new HashMap();
        LinkedHashMap<String, String> subTabOrderMap = new LinkedHashMap<String, String>();
        subTabOrderMap.put("sequence", "asc");
        subTabOrderMap.put("id", "asc");
        subOrderMap.put("propertyList", subTabOrderMap);
        MaterialCategoryEntity entity = (MaterialCategoryEntity)((Object)this.service.selectById(id, subOrderMap));
        MaterialCategoryVO vo = (MaterialCategoryVO)BeanMapper.map((Object)((Object)entity), MaterialCategoryVO.class);
        List<MaterialCategoryVO> children = this.service.queryAllByPid(id, ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
        vo.setLeafFlag(Boolean.valueOf(children.size() == 1));
        if (CollectionUtils.isNotEmpty((Collection)vo.getPropertyList())) {
            vo.getPropertyList().stream().forEach(item -> {
                item.setOldName(item.getName());
                item.setOldSequence(item.getSequence());
                item.setOldEnabled(item.getEnabled());
                item.setOldProductCodeFlag(item.getProductCodeFlag());
            });
        }
        if (CollectionUtils.isNotEmpty(subVos = this.materialCategoryPropertySubItemService.getAllByCategoryId(id))) {
            Map<String, List<MaterialCategoryPropertySubItemVO>> subMap = subVos.stream().map(item -> {
                item.setOldName(item.getName());
                item.setOldProductCode(item.getProductCode());
                return item;
            }).collect(Collectors.groupingBy(item -> item.getPropertyId().toString()));
            vo.getPropertyList().stream().filter(item -> subMap.containsKey(item.getId().toString())).forEach(item -> item.setItemList(((List)subMap.get(item.getId().toString())).stream().sorted(new Comparator<MaterialCategoryPropertySubItemVO>(){

                @Override
                public int compare(MaterialCategoryPropertySubItemVO o1, MaterialCategoryPropertySubItemVO o2) {
                    return o1.getSequence() - o2.getSequence();
                }
            }).collect(Collectors.toList())));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            List<Long> categoryIds = this.service.queryChildrenIdsByPIds(ids);
            List<MaterialVO> materialList = this.materialService.queryListByCategoryId(categoryIds);
            if (CollectionUtils.isNotEmpty(materialList)) {
                Set categoryNames = materialList.stream().map(MaterialVO::getCategoryName).collect(Collectors.toSet());
                return CommonResponse.error((String)("\u5206\u7c7b\u3010" + StringUtils.join(categoryNames, (String)",") + "\u3011\u4e0b\u5b58\u5728\u7269\u6599\u660e\u7ec6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664"));
            }
            this.service.removeByIds(ids, false);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject jsonObject = new JSONObject();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        Map params = param.getParams();
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
            QueryWrapper query = new QueryWrapper();
            query.like((Object)"name", (Object)param.getSearchText());
            query.orderByAsc((Object)"inner_code");
            List searchList = this.service.list((Wrapper)query);
            if (CollectionUtils.isEmpty((Collection)searchList)) {
                jsonObject.put("data", new ArrayList());
                return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)jsonObject);
            }
            HashMap<String, MaterialCategoryEntity> innerCodeMap = new HashMap<String, MaterialCategoryEntity>();
            for (MaterialCategoryEntity m : searchList) {
                if (innerCodeMap.containsKey(m.getInnerCode().split("\\|")[0])) continue;
                innerCodeMap.put(m.getInnerCode(), m);
            }
            List<Long> pids = innerCodeMap.values().stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<Long> childrenIds = this.service.queryChildrenIdsByPIds(pids);
            for (MaterialCategoryEntity m : searchList) {
                for (String idStr : m.getInnerCode().split("\\|")) {
                    if (childrenIds.contains(Long.valueOf(idStr))) continue;
                    childrenIds.add(Long.valueOf(idStr));
                }
            }
            condition.put("ids", childrenIds);
        }
        if (null != params.get("leafNode")) {
            MaterialCategoryEntity leftNode = (MaterialCategoryEntity)((Object)this.service.selectById(Long.valueOf(((Parameter)params.get("leafNode")).getValue().toString())));
            Long topId = Long.valueOf(leftNode.getInnerCode().split("\\|")[0]);
            List<MaterialCategoryVO> categorys = this.service.queryAllByPid(topId, ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
            if (null != leftNode) {
                params.put("includeIds", new Parameter("in", categorys.stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
            params.remove("leafNode");
        }
        for (String key : params.keySet()) {
            condition.put(key, ((Parameter)params.get(key)).getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<Map> resultMapList = this.service.queryListMap(condition);
        resultMapList.forEach(l -> {
            if ("0".equals(String.valueOf(l.get("leafFlag")))) {
                l.put("children", new ArrayList());
            }
        });
        jsonObject.put("data", (Object)ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)jsonObject);
    }

    @GetMapping(value={"/lazyCategoryTree"})
    public List<Map<String, Object>> lazyCategoryTree(@RequestParam(required=false) String condition, @RequestParam(required=false) Long pid, @RequestParam(required=false) String propertyFlag, @RequestParam(required=false) String searchText) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            params.put("searchText", searchText);
        }
        if (null != pid) {
            params.put("parentId", pid);
        }
        if (StringUtils.isNotBlank((CharSequence)propertyFlag)) {
            params.put("propertyFlag", propertyFlag);
        }
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (null != _con.get((Object)"topCategory")) {
                params.put("topCategory", true);
            }
            if (null != _con.get((Object)"secCategory")) {
                params.put("secCategory", true);
            }
            if (null != _con.get((Object)"propertyFlag")) {
                params.put("propertyFlag", _con.get((Object)"propertyFlag"));
            }
            if (null != _con.get((Object)"enabled")) {
                params.put("enabled", _con.get((Object)"enabled"));
            }
        }
        List<MaterialCategoryVO> dataList = this.service.queryList(params);
        List map = BeanMapper.mapList(dataList, Map.class);
        map.forEach(l -> {
            if (l.get("leafFlag").equals(false)) {
                l.put("children", new ArrayList());
                l.put("isLeaf", false);
            } else {
                l.put("isLeaf", true);
                l.put("children", null);
            }
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                l.put("parentId", null);
            }
        });
        return ResultAsTree.createTreeData((List)map);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/refMaterialCategoryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialCategoryVO>> refMaterialCategoryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (_con = JSONObject.parseObject((String)condition)).get((Object)"topCategory")) {
            param.getParams().put("parentId", new Parameter("sql", (Object)"parent_id is null"));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"zdsmaterial-category-import.xlsx", (String)"\u6750\u6599\u5206\u7c7b\u5bfc\u5165\u6a21\u677f");
    }

    @PostMapping(value={"/excelImport"})
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<MaterialCategoryVO> successList = new ArrayList<MaterialCategoryVO>();
        ArrayList<MaterialCategoryVO> processList = new ArrayList<MaterialCategoryVO>();
        ArrayList<MaterialCategoryVO> errorList = new ArrayList<MaterialCategoryVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5206\u7c7b\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap<String, MaterialCategoryVO> codeMapCache = new HashMap<String, MaterialCategoryVO>();
            MaterialCategoryVO importVo = null;
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                importVo = new MaterialCategoryVO();
                importVo.setId(Long.valueOf(com.ejianc.support.idworker.util.IdWorker.getId()));
                importVo.setCode((String)datas.get(0));
                importVo.setParentCode((String)datas.get(1));
                importVo.setName((String)datas.get(2));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    importVo.setDescription("\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a\uff01");
                    errorList.add(importVo);
                    continue;
                }
                if (codeMapCache.containsKey(importVo.getCode())) {
                    importVo.setDescription("\u5206\u7c7b\u540d\u79f0\u91cd\u590d\uff01");
                    errorList.add(importVo);
                    continue;
                }
                importVo.setId(Long.valueOf(IdWorker.getId()));
                importVo.setEnabled(Integer.valueOf(1));
                importVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                importVo.setCreateTime(new Date());
                importVo.setTenantId(InvocationInfoProxy.getTenantid());
                processList.add(importVo);
                codeMapCache.put(importVo.getCode(), importVo);
            }
            if (ListUtil.isNotEmpty(processList)) {
                List<MaterialCategoryEntity> parentListByCode;
                List<MaterialCategoryEntity> codeList = this.service.queryByCodes(new ArrayList<String>(codeMapCache.keySet()));
                Set pCodes = processList.stream().map(MaterialCategoryVO::getParentCode).collect(Collectors.toSet());
                Map<Object, Object> parentCodeMap = new HashMap();
                if (CollectionUtils.isNotEmpty(pCodes) && CollectionUtils.isNotEmpty(parentListByCode = this.service.queryByCodes(new ArrayList<String>(pCodes)))) {
                    parentCodeMap = parentListByCode.stream().collect(Collectors.toMap(MaterialCategoryEntity::getCode, item -> item));
                }
                if (CollectionUtils.isNotEmpty(codeList)) {
                    for (MaterialCategoryEntity repeatCode : codeList) {
                        importVo = (MaterialCategoryVO)codeMapCache.get(repeatCode.getCode());
                        codeMapCache.remove(repeatCode.getCode());
                        processList.remove(importVo);
                        importVo.setDescription("\u5206\u7c7b\u540d\u79f0\u91cd\u590d\uff01");
                        errorList.add(importVo);
                    }
                }
                for (MaterialCategoryVO item2 : processList) {
                    if (StringUtils.isNotBlank((CharSequence)item2.getParentCode())) {
                        if (parentCodeMap.containsKey(item2.getParentCode())) {
                            item2.setInnerCode(((MaterialCategoryEntity)((Object)parentCodeMap.get(item2.getParentCode()))).getInnerCode() + "|" + item2.getId());
                            item2.setParentId(((MaterialCategoryEntity)((Object)parentCodeMap.get(item2.getParentCode()))).getId());
                        } else if (codeMapCache.containsKey(item2.getParentCode())) {
                            item2.setInnerCode(((MaterialCategoryVO)codeMapCache.get(item2.getParentCode())).getInnerCode() + "|" + item2.getId());
                            item2.setParentId(((MaterialCategoryVO)codeMapCache.get(item2.getParentCode())).getId());
                        }
                        item2.setSourceType("1");
                        if (null == item2.getParentId()) {
                            item2.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u5bf9\u5e94\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
                            errorList.add(importVo);
                            continue;
                        }
                    } else {
                        item2.setInnerCode(item2.getId().toString());
                    }
                    successList.add(item2);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @PostMapping(value={"/saveImportExcelCategory"})
    public CommonResponse<String> saveImportExcelCategory(@RequestBody List<MaterialCategoryVO> saveImportVos) {
        if (ListUtil.isEmpty(saveImportVos)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        saveImportVos.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getCode())).forEach(item -> {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)item);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            item.setCode((String)billCode.getData());
        });
        List saveList = BeanMapper.mapList(saveImportVos, MaterialCategoryEntity.class);
        this.service.saveOrUpdateBatch(saveList, saveList.size(), false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @GetMapping(value={"/getCategoryProperties"})
    public CommonResponse<MaterialCategoryVO> getCategoryProperties(@RequestParam Long categoryId, @RequestParam(required=false, defaultValue="1") Integer enabled, @RequestParam(required=false, defaultValue="false") Boolean includeUnValid) {
        MaterialCategoryEntity category = (MaterialCategoryEntity)((Object)this.service.selectById(categoryId));
        MaterialCategoryVO resp = (MaterialCategoryVO)BeanMapper.map((Object)((Object)category), MaterialCategoryVO.class);
        resp.setPropertyList(this.propertyService.getAllPropertiesAndValue(categoryId, enabled, includeUnValid));
        return CommonResponse.success((Object)resp);
    }

    @GetMapping(value={"/getInvalidMaterialCategoryTree"})
    public CommonResponse<List<Map<String, Object>>> getInvalidMaterialCategoryTree(@RequestParam(required=false) String categoryName) {
        List<Long> childIds;
        List map = new ArrayList();
        List<Long> categoryIds = this.invalidMatExaminerService.getLastCategoryIdsByEmpId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        if (CollectionUtils.isNotEmpty(categoryIds) && CollectionUtils.isNotEmpty(childIds = this.materialService.getAllInvalidMaterialCategoryIds(categoryName))) {
            childIds.retainAll(categoryIds);
            if (CollectionUtils.isNotEmpty(childIds)) {
                List<MaterialCategoryVO> allCategory = this.service.queryCategoryListByChildren(childIds);
                map = BeanMapper.mapList(allCategory, Map.class);
            }
        }
        return CommonResponse.success((Object)ResultAsTree.createTreeData(map));
    }

    @GetMapping(value={"/getAllCategoryByLeafNodeId"})
    public CommonResponse<List<Map<String, Object>>> getAllCategoryByLeafNodeId(@RequestParam Long categoryId) {
        List<MaterialCategoryEntity> categoryList = this.service.getAllCategoryByLeafNodeId(categoryId);
        return CommonResponse.success((Object)ResultAsTree.createTreeData((List)BeanMapper.mapList(categoryList, Map.class)));
    }

    @PostMapping(value={"materialCategorySync"})
    public CommonResponse<String> materialCategorySync(@RequestBody JSONObject param) {
        String endDate;
        String startDate = null != param.get((Object)"startDate") ? param.getString("startDate") : null;
        String string = endDate = null != param.get((Object)"endDate") ? param.getString("endDate") : null;
        if (StringUtils.isBlank((CharSequence)startDate) && StringUtils.isBlank((CharSequence)endDate)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            startDate = sdf.format(DateUtil.addDays((Date)new Date(), (int)-1));
            endDate = startDate + " 23:59:59";
            startDate = startDate + " 00:00:00";
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("startDate", startDate);
        queryParams.put("endDate", endDate);
        if (null != param.get((Object)"categoryIds")) {
            queryParams.put("categoryIds", param.getJSONArray("categoryIds"));
        }
        this.service.syncToErp(queryParams);
        return CommonResponse.success((String)"\u7269\u6599\u5206\u7c7b\u540c\u6b65ERP\u4efb\u52a1\u6267\u884c\u6210\u529f!");
    }

    @PostMapping(value={"/updateCoordination"})
    @ResponseBody
    public CommonResponse<String> updateCoordination(@RequestBody MaterialCategoryVO materialCategoryVO) {
        this.service.updateCoordination(materialCategoryVO);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @GetMapping(value={"/getCategoryTree"})
    public CommonResponse<List<Map<String, Object>>> getCategoryTree(@RequestParam Long categoryId) {
        List<MaterialCategoryVO> categoryVOS = this.service.queryAllByPid(categoryId, ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
        List map = BeanMapper.mapList(categoryVOS, Map.class);
        return CommonResponse.success((Object)ResultAsTree.createTreeData((List)map));
    }

    @PostMapping(value={"/getDirectParentCategoryIds"})
    public CommonResponse<JSONObject> getDirectParentCategoryIds(@RequestBody List<Long> categoryIds) {
        JSONObject resp = new JSONObject();
        List<MaterialCategoryVO> childs = this.service.getAllByIds(categoryIds);
        ArrayList<Long> parentIds = new ArrayList<Long>(childs.stream().filter(item -> null != item.getParentId()).map(MaterialCategoryVO::getParentId).collect(Collectors.toSet()));
        HashMap<Long, MaterialCategoryVO> parentMap = new HashMap<Long, MaterialCategoryVO>();
        if (CollectionUtils.isNotEmpty(parentIds)) {
            List<MaterialCategoryVO> parents = this.service.getAllByIds(parentIds);
            for (MaterialCategoryVO p : parents) {
                parentMap.put(p.getId(), p);
            }
        }
        for (MaterialCategoryVO c : childs) {
            resp.put(String.valueOf(c.getId()), parentMap.get(c.getParentId()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"updateBrandControl"})
    public CommonResponse<String> updateBrandControl(@RequestBody MaterialCategoryVO categoryVO) {
        List<MaterialCategoryEntity> updateList = null;
        Map<Long, MaterialCategoryEntity> categoryEntityMap = null;
        if ("1".equals(categoryVO.getBrandControlFlag())) {
            updateList = this.service.getParentsByChildId(categoryVO.getId());
            categoryEntityMap = updateList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        } else {
            MaterialCategoryEntity parent;
            updateList = this.service.getChildrenByPid(categoryVO.getId());
            categoryEntityMap = updateList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            Long parentId = ((MaterialCategoryEntity)((Object)updateList.stream().filter(item -> item.getId().equals(categoryVO.getId())).collect(Collectors.toList()).get(0))).getParentId();
            if (null != parentId && null != (parent = (MaterialCategoryEntity)((Object)this.service.selectById(parentId)))) {
                categoryEntityMap.put(parent.getId(), parent);
            }
        }
        for (MaterialCategoryEntity item2 : updateList) {
            item2.setBrandControlFlag(categoryVO.getBrandControlFlag());
            if (!categoryEntityMap.containsKey(item2.getParentId())) continue;
            item2.setParentCode(categoryEntityMap.get(item2.getParentId()).getCode());
            item2.setParentName(categoryEntityMap.get(item2.getParentId()).getName());
            item2.setParentSourceId(categoryEntityMap.get(item2.getParentId()).getSourceId());
        }
        this.service.saveOrUpdateBatch(updateList, updateList.size(), false);
        this.service.pushToErp(new DataPushErpParam(null, BeanMapper.mapList(updateList, MaterialCategoryVO.class), InvocationInfoProxy.getUserid(), "\u7269\u6599\u54c1\u724c\u7ba1\u63a7\u8c03\u6574", "EJCBT202311000002"));
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

