package com.ejianc.business.zdsmaterial.pricelib.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.pricelib.bean.MaterialPriceCalcEntity;
import com.ejianc.business.zdsmaterial.pricelib.mapper.MaterialPriceCalcMapper;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcService;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcSubConditionService;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceSubConditionDetailService;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcSubConditionVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceSubConditionDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 价格公式设置主实体
 * 
 * @author generator
 * 
 */
@Service("materialPriceCalcService")
public class MaterialPriceCalcServiceImpl extends BaseServiceImpl<MaterialPriceCalcMapper, MaterialPriceCalcEntity> implements IMaterialPriceCalcService{

    @Autowired
    private IMaterialPriceCalcSubConditionService conditionService;

    @Autowired
    private IMaterialPriceSubConditionDetailService conditionDetailService;


    @Override
    public MaterialPriceCalcVO getOneByCategoryId(Long categoryId) {
        return BeanMapper.map(selectByCategoryId(categoryId), MaterialPriceCalcVO.class);
    }

    @Override
    public MaterialPriceCalcEntity selectByCategoryId(Long categoryId) {
        QueryWrapper<MaterialPriceCalcEntity> query = new QueryWrapper<>();
        query.eq("category_id", categoryId);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.getOne(query);
    }

    @Override
    public List<MaterialPriceCalcVO> getAllByCategoryIds(List<Long> categoryIds) {
        List<MaterialPriceCalcVO> resp = new ArrayList<>();

        QueryWrapper<MaterialPriceCalcEntity> query = new QueryWrapper<>();
        query.in("category_id", categoryIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        List<MaterialPriceCalcEntity> list = super.list(query);

        if(CollectionUtils.isNotEmpty(list)){
            return BeanMapper.mapList(list, MaterialPriceCalcVO.class);
        }
        return resp;
    }

    @Override
    public Map<Long, List<MaterialPriceCalcSubConditionVO>> getConditionMapByCategoryIds(List<Long> categoryIds) {
        Map<Long, List<MaterialPriceCalcSubConditionVO>> resp = new HashMap<>();

        QueryWrapper<MaterialPriceCalcEntity> query = new QueryWrapper<>();
        query.in("category_id", categoryIds);
        query.eq("enabled", "1");

        List<MaterialPriceCalcEntity> list = super.list(query);

        if(CollectionUtils.isNotEmpty(list)) {
            Map<Long, Long> categoryPidMap = list.stream().collect(Collectors.toMap(item -> item.getId(), item -> item.getCategoryId()));
            List<MaterialPriceCalcSubConditionVO> conList = conditionService.getAllByPids(new ArrayList<>(categoryPidMap.keySet()), "1", true);

            if(CollectionUtils.isNotEmpty(conList)) {
                //查询条件元素
                Map<Long, List<MaterialPriceSubConditionDetailVO>> detailMap = conditionDetailService.getAllByConditionIds(conList.stream().map(MaterialPriceCalcSubConditionVO::getId).collect(Collectors.toList()));
                conList.stream().filter(c -> detailMap.containsKey(c.getId())).forEach(c -> {
                    c.setDetailList(detailMap.get(c.getId()));
                });

                return conList.stream().collect(Collectors.groupingBy(c -> categoryPidMap.get(c.getPid())));
            }
        }

        return resp;
    }


}
