package com.ejianc.business.zdsmaterial.asynchandler.consumer;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.asynchandler.bean.SyncJobExecRecordsEntity;
import com.ejianc.business.zdsmaterial.asynchandler.service.ISyncJobExecRecordService;
import com.ejianc.business.zdsmaterial.erp.vo.SyncJobExecRecordsVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author CJ
 * @Description:
 * @date 2024/4/24 11:31
 */
@Component
public class SyncJobExecRecordListener extends BaseConsumer {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${spring.cloud.config.profile}")
    private String profile;

    @Autowired
    private ISyncJobExecRecordService service;

    @Override
    protected void doConsumeMsg(MqMessage mqMessage) {
        logger.info("接收到同步任务执行情况：{}", mqMessage.getBody());
        try {
            SyncJobExecRecordsVO vo = JSONObject.parseObject(mqMessage.getBody().toString(), SyncJobExecRecordsVO.class);

            service.saveOrUpdate(BeanMapper.map(vo, SyncJobExecRecordsEntity.class), false);

        } catch (Exception e) {
            logger.error("处理同步任务执行情况: ", e);
        }
    }

    @Override
    protected String[] getQueueNames() {
        return new String[]{SyncJobExecRecordsVO.QUEUE_NAME+"_1"+profile};
    }
}
