package com.ejianc.business.zdsmaterial.erp.controller.api;

import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2024/5/15 18:58
 */
@RestController
@RequestMapping(value = "/api/zdsBrand")
public class BrandApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBrandService service;

    @PostMapping(value = "/getAllByIds")
    CommonResponse<List<BrandVO>> getAllByIds(@RequestBody List<Long> ids) {
        List<BrandVO> resp = service.getAllByIds(ids);

        return CommonResponse.success("查询成功！",resp);
    }

    @PostMapping(value = "/getAllMapBySourceIds")
    CommonResponse<Map<String, BrandVO>> getAllMapBySourceIds(@RequestBody List<String> sourceIds) {
        Map<String, BrandVO> resp = new HashMap<>();
        if(CollectionUtils.isNotEmpty(sourceIds)) {
            List<BrandEntity> dbList = service.getAllBySourceIds(sourceIds);
            if(CollectionUtils.isNotEmpty(dbList)) {
                List<BrandVO> vos = BeanMapper.mapList(dbList, BrandVO.class);
                for(BrandVO v : vos) {
                    resp.put(v.getSourceId(), v);
                }
            }
        }

        return CommonResponse.success("查询成功！",resp);
    }

    @PostMapping(value = "/getAllMapByNames")
    CommonResponse<Map<String, BrandVO>> getAllMapByNames(@RequestBody List<String> names) {
        Map<String, BrandVO> resp = new HashMap<>();
        if(CollectionUtils.isNotEmpty(names)) {
            resp.putAll(service.getAllVoMapByNames(names));
        }

        return CommonResponse.success("查询成功！",resp);
    }
}
