package com.ejianc.business.zdsmaterial.erp.mapper;

import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 物资合同
 * 
 * @author generator
 * 
 */
@Mapper
public interface ContractMapper extends BaseCrudMapper<ContractEntity> {

    List<ContractEntity> queryNowYearList(@Param("linkerId") Long linkerId, @Param("linkerSid") String linkerSid, @Param("supplierId")   Long supplierId);

    int countContractAndOrder(@Param("queryParam") Map<String, Object> queryParam);

    List<Map> pageContractAndOrder(@Param("queryParam") Map<String, Object> queryParam);

    BigDecimal thisYearContractMny(@Param("linkerId") Long linkerId, @Param("linkerSid") String linkerSid, @Param("supplierId")  Long supplierId);

    List<String> getSyncList();

    void updateSyncResult(@Param(value = "sourceContractId") String sourceContractId, @Param(value = "syncFlag") String result);
}
