package com.ejianc.business.zdsmaterial.erp.service;

import com.ejianc.business.zdsmaterial.erp.bean.SubContractEntity;
import com.ejianc.business.zdsmaterial.sub.fee.vo.AuditorSetVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 分包合同
 * 
 * @author generator
 * 
 */
public interface ISubContractService extends IBaseService<SubContractEntity> {
    List<SubContractEntity> getAllBySourceIds(List<String> sourceIds);
    void AuditorSetStatus(AuditorSetVO vo);

    /**
     * 履约中
     * @return
     */
    Integer performanceNum(Long linkerId, String linkerSid, Long supplierId);
    /**
     * 已完工待结算
     * @return
     */
    Integer finishSettleNum(Long linkerId, String linkerSid, Long supplierId);

    /**
     * 已结算
     * @param linkerId
     * @param linkerSid
     * @param supplierId
     * @return
     */
    Integer settleNum(Long linkerId, String linkerSid, Long supplierId);
    /**
     * 本年度新签合同额
     * @return
     */
    BigDecimal thisYearContractMny(Long linkerId, String linkerSid, Long supplierId);

    void cancelContract(List<Long> delContractIds);

    List<SupplierVO> getAllSubSupInfoBySourceIds(List<String> supSourceIds);

    List<String> getSyncList();

    void updateSyncResult(String sourceContractId, String result);

    SupplierVO getSubSupInfoByTenant(Long supTenant);

    SupplierVO getSubSupInfoById(Long supplierId);
}
