package com.ejianc.business.zdsmaterial.material.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.material.bean.MatFeeApplyEntity;
import com.ejianc.business.zdsmaterial.material.vo.MatFeeApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 物资费用申请
 * 
 * @author generator
 * 
 */
public interface IMatFeeApplyService extends IBaseService<MatFeeApplyEntity> {

    /**
     *
     * 接收
     * @param request
     * @return
     */
    CommonResponse<String> syncBill(HttpServletRequest request);

    CommonResponse<MatFeeApplyVO> pushStatus(Long id);


    /**
     * 驳回 提交确认
     * @param entity
     * @return
     */
    String pushBill(MatFeeApplyEntity entity);

    int pageCount(Map<String, Object> queryParam);

    List<JSONObject> pageList(Map<String, Object> queryParam);

    /**
     * 采购费用申请自然年内的申请金额汇总
     *
     * @param linkerId
     * @param linkerSid
     * @param supplierId
     * @return
     */
    BigDecimal thisYearApplyMny(Long linkerId, String linkerSid, Long supplierId);
}
