package com.ejianc.business.zdsmaterial.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertySubItemEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MaterialCategoryPropertySubItemMapper;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertyService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertySubItemService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 材料分类属性可选值
 * 
 * @author generator
 * 
 */
@Service("materialCategoryPropertySubItemService")
public class MaterialCategoryPropertySubItemServiceImpl extends BaseServiceImpl<MaterialCategoryPropertySubItemMapper, MaterialCategoryPropertySubItemEntity> implements IMaterialCategoryPropertySubItemService{

    @Autowired
    private MaterialCategoryPropertySubItemMapper mapper;

    @Override
    public List<MaterialCategoryPropertySubItemVO> getAllByCategoryId(Long categoryId) {
       return getAllByCategoryId(categoryId, false);
    }

    @Autowired
    private IMaterialCategoryPropertyService materialCategoryPropertyService;


    @Override
    public List<MaterialCategoryPropertySubItemVO> getAllByCategoryId(Long categoryId, Boolean includeUnValid) {
        List<MaterialCategoryPropertyVO> pList = materialCategoryPropertyService.getAllByCategoryId(categoryId, 1);
        List<Long> propertyIds = pList.stream().map(MaterialCategoryPropertyVO::getId).collect(Collectors.toList());
        List<MaterialCategoryPropertySubItemVO> resp = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(propertyIds)) {
            QueryWrapper<MaterialCategoryPropertySubItemEntity> query = new QueryWrapper<>();
            query.eq("category_id", categoryId);
            query.eq("dr", BaseVO.DR_UNDELETE);
            query.eq("enabled", ZDSMaterialCommonEnums.停启用_启用.getCode());
            query.in("property_id", propertyIds);
            if(null != includeUnValid) {
                if(!includeUnValid) {
                    query.eq("valid_flag", ZDSMaterialCommonEnums.分类设置属性值是否生效_是.getCode());
                } else {
                    query.and(q -> q.eq("valid_flag", ZDSMaterialCommonEnums.分类设置属性值是否生效_是.getCode()).or(qi -> qi.eq("valid_flag",
                            ZDSMaterialCommonEnums.分类设置属性值是否生效_否.getCode()).like("related_user_ids", InvocationInfoProxy.getUserid())));
                }
            }

            query.orderByAsc("sequence");

            List<MaterialCategoryPropertySubItemEntity> eList = super.list(query);
            if(CollectionUtils.isNotEmpty(eList)) {
                resp = BeanMapper.mapList(eList, MaterialCategoryPropertySubItemVO.class);
            }
        }

        return resp;
    }

    @Override
    public List<Long> getInValidPropertyItemIds(List<Long> materialIds) {
        return mapper.getInValidPropertyItemIds(materialIds);
    }

    @Override
    public void validPropertyItems(List<Long> getInValidPropertyItemIds) {
        UpdateWrapper<MaterialCategoryPropertySubItemEntity> update = new UpdateWrapper<>();
        update.in("id", getInValidPropertyItemIds);
        update.set("valid_flag", ZDSMaterialCommonEnums.分类设置属性值是否生效_是.getCode());
        update.set("update_time", new Date());
        update.set("update_user_code", InvocationInfoProxy.getUsercode());

        super.update(update);
    }

    @Override
    public List<MaterialCategoryPropertySubItemVO> searchList(MaterialCategoryPropertySubItemVO searchVO) {
        return mapper.searchList(searchVO);
    }

    @Override
    public Map<Long, List<MaterialCategoryPropertySubItemVO>> getAllByCategoryIds(List<Long> categoryIds) {
        Map<Long, List<MaterialCategoryPropertySubItemVO>> result = new HashMap<>();
        QueryWrapper<MaterialCategoryPropertySubItemEntity> query = new QueryWrapper<>();
        query.in("category_id", categoryIds);
        query.orderByAsc("sequence");
        List<MaterialCategoryPropertySubItemEntity> eList = super.list(query);

        if(CollectionUtils.isNotEmpty(eList)) {
            result.putAll(BeanMapper.mapList(eList, MaterialCategoryPropertySubItemVO.class).stream().collect(Collectors.groupingBy(MaterialCategoryPropertySubItemVO::getPropertyId, Collectors.toList())));
        }

        return result;
    }
    @Override
    public Map<Long, List<MaterialCategoryPropertySubItemVO>> getAllByCategoryIds(List<Long> categoryIds, Integer enabled) {
        Map<Long, List<MaterialCategoryPropertySubItemVO>> result = new HashMap<>();
        QueryWrapper<MaterialCategoryPropertySubItemEntity> query = new QueryWrapper<>();
        query.in("category_id", categoryIds);
        query.eq("enabled", enabled);
        query.orderByAsc("sequence");
        List<MaterialCategoryPropertySubItemEntity> eList = super.list(query);

        if(CollectionUtils.isNotEmpty(eList)) {
            result.putAll(BeanMapper.mapList(eList, MaterialCategoryPropertySubItemVO.class).stream().collect(Collectors.groupingBy(MaterialCategoryPropertySubItemVO::getPropertyId, Collectors.toList())));
        }

        return result;
    }

    @Override
    public Map<Long, List<MaterialCategoryPropertySubItemVO>> getCategoryItemMap(List<Long> categoryIds, Integer enabled) {
        Map<Long, List<MaterialCategoryPropertySubItemVO>> result = new HashMap<>();
        QueryWrapper<MaterialCategoryPropertySubItemEntity> query = new QueryWrapper<>();
        query.in("category_id", categoryIds);
        query.eq("enabled", enabled);
        query.orderByAsc("sequence");
        List<MaterialCategoryPropertySubItemEntity> eList = super.list(query);

        if(CollectionUtils.isNotEmpty(eList)) {
            result.putAll(BeanMapper.mapList(eList, MaterialCategoryPropertySubItemVO.class).stream()
                    .collect(Collectors.groupingBy(MaterialCategoryPropertySubItemVO::getCategoryId, Collectors.toList())));
        }

        return result;
    }

    @Override
    public List<MaterialCategoryPropertySubItemEntity> queryByNames(ArrayList<String> names, Long propertyId) {
        QueryWrapper<MaterialCategoryPropertySubItemEntity> query = new QueryWrapper<>();
        query.in("name", names);
        if(null != propertyId) {
            query.eq("property_id", propertyId);
        }
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);
        return super.list(query);
    }

    @Override
    public void updatePropertyItemsValidFlag(List<Long> validPropertyValIds, Integer code) {
        UpdateWrapper<MaterialCategoryPropertySubItemEntity> update = new UpdateWrapper<>();
        update.in("id", validPropertyValIds);
        update.set("valid_flag", code);

        super.update(update);
    }

}
