package com.ejianc.business.zdsmaterial.out.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.out.bean.DisposeDetailEntity;
import com.ejianc.business.zdsmaterial.out.bean.DisposeEntity;
import com.ejianc.business.zdsmaterial.out.service.IDisposeDetailService;
import com.ejianc.business.zdsmaterial.out.service.IDisposeService;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.business.zdsmaterial.util.DateUtil;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2024/5/21 15:32
 */
@RestController
@RequestMapping("dispose/erp")
public class DisposeErpController {

    Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IDisposeService service;

    @Autowired
    private IDisposeDetailService detailService;

    @Autowired
    private IMaterialCategoryService categoryService;

    @Autowired
    private IEmployeeApi employeeApi;

    private final String SYNC_ERP_REC_MNY_URL = "/cefoc/yql/getCollectionList";

    @PostMapping(value = "/pageList")
    public CommonResponse<JSONObject> pageSyncList(@RequestBody JSONObject param) {
        JSONObject resp = new JSONObject();

        logger.info("ERP查询废旧物料处置申请参数：{}", JSONObject.toJSONString(param, SerializerFeature.PrettyFormat));
        Integer pageSize = null != param && null != param.getInteger("PageSize") ? param.getInteger("PageSize") : 10;
        Integer pageNum = null != param && null != param.getInteger("PageNum") ? param.getInteger("PageNum") : 1;
        String BeginDateTime = null != param && null != param.getString("BeginDateTime") ? param.getString("BeginDateTime") : null;
        String EndDateTime = null != param && null != param.getString("EndDateTime") ? param.getString("EndDateTime") : null;

        Map<String, Object> queryParam = new HashMap<>();
        if(StringUtils.isNotBlank(BeginDateTime)) {
            queryParam.put("beginDateTime", BeginDateTime);
        }
        if(StringUtils.isNotBlank(EndDateTime)) {
            queryParam.put("endDateTime", EndDateTime);
        }

        int count = service.pageCount(queryParam);
        resp.put("total", count);
        resp.put("pageSize", pageSize);
        resp.put("pageNum", pageNum);

        if (count == 0) {
            resp.put("records", new ArrayList<>());
            return CommonResponse.success("查询成功！", resp);
        }

        Integer startLine = pageNum - 1 < 0 ? pageSize : (pageNum - 1) * pageSize;
        queryParam.put("startLine", startLine);
        queryParam.put("pageSize", pageSize);

        List<JSONObject> pageList = service.pageList(queryParam);
        List<Long> projectIds = new ArrayList<>();
        List<Long> pIds = new ArrayList<>();
        List<Long> empIds = new ArrayList<>();
        List<String> empCodes = new ArrayList<>();
        pageList.stream().forEach(item -> {
            if (!projectIds.contains(item.getLong("projectId"))) {
                projectIds.add(item.getLong("projectId"));
            }
            if (!pIds.contains(item.getLong("YQL_SID"))) {
                pIds.add(item.getLong("YQL_SID"));
            }
            if (!empIds.contains(item.getLong("ApplyHumanId"))) {
                empIds.add(item.getLong("ApplyHumanId"));
            }
            if (!empCodes.contains(item.getString("ApprHumanCode"))) {
                empCodes.add(item.getString("ApprHumanCode"));
            }
            item.put("DisposalMode", "1".equals(item.getString("DisposalMode")) ? "战略" : "询比价");
        });

        //查询项目信息
        CommonResponse<JSONArray> projectResp = projectPoolApi.queryProjectByIds(projectIds);
        if (!projectResp.isSuccess()) {
            logger.error("分包结算查询失败，根据项目Id列表-{}查询项目信息失败，{}", JSONObject.toJSONString(projectIds),
                    JSONObject.toJSONString(projectResp, SerializerFeature.PrettyFormat));
            return CommonResponse.error("查询失败，获取项目信息失败！");
        }

        Map<Long, String> projectSidMap = new HashMap<>();
        List<ProjectPoolSetVO> projectList = JSONArray.parseArray(JSONObject.toJSONString(projectResp.getData()), ProjectPoolSetVO.class);
        if (CollectionUtils.isNotEmpty(projectList)) {
            projectSidMap.putAll(projectList.stream().collect(Collectors.toMap(ProjectPoolSetVO::getId, ProjectPoolSetVO::getSourceId)));
        }

        //查询人员信息
        Map<Long, EmployeeVO> empIdMap = new HashMap<>();
        Map<String, EmployeeVO> empCodeMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(empIds)) {
            CommonResponse<List<EmployeeVO>> empResp = employeeApi.getByIds(empIds);
            if(!empResp.isSuccess()) {
                logger.error("分包结算查询失败，根据人员id列表-{}查询人员信息失败，{}", JSONObject.toJSONString(empIds),
                        JSONObject.toJSONString(empResp, SerializerFeature.PrettyFormat));
                return CommonResponse.error("查询失败，获取人员信息失败！");
            }

            List<EmployeeVO> empList = empResp.getData();
            if(CollectionUtils.isNotEmpty(empList)) {
                empIdMap.putAll(empList.stream().collect(Collectors.toMap(EmployeeVO::getId, Function.identity())));
            }
        }
        if(CollectionUtils.isNotEmpty(empCodes)) {
            CommonResponse<List<EmployeeVO>> empResp = employeeApi.getAllByEmployeeCodes(empCodes);
            if(!empResp.isSuccess()) {
                logger.error("分包结算查询失败，根据人员工号列表-{}查询人员信息失败，{}", JSONObject.toJSONString(empCodes),
                        JSONObject.toJSONString(empResp, SerializerFeature.PrettyFormat));
                return CommonResponse.error("查询失败，获取人员信息失败！");
            }
            List<EmployeeVO> empList = empResp.getData();
            if(CollectionUtils.isNotEmpty(empList)) {
                empCodeMap.putAll(empList.stream().collect(Collectors.toMap(EmployeeVO::getCode, Function.identity())));
            }
        }

        //查询费用子表
        Map<Long, List<DisposeDetailEntity>> subDetailMap = detailService.getAllBySettleIds(pIds);

        //查询物料分类信息
        Map<Long, String> categorySidMap = new HashMap<>();
        List<Long> categoryIds = new ArrayList<>(subDetailMap.values().stream().flatMap(List::stream).map(DisposeDetailEntity::getMaterialTypeId).collect(Collectors.toSet()));
        if(CollectionUtils.isNotEmpty(categoryIds)) {
            List<MaterialCategoryVO> categorys = categoryService.getAllByIds(categoryIds);
            if(CollectionUtils.isNotEmpty(categorys)) {
                categorySidMap.putAll(categorys.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, MaterialCategoryVO::getSourceId)));
            }
        }

        EmployeeVO emp = null;
        for(JSONObject settle : pageList) {
            //获取项目信息
            settle.put("Account_Project_Sid", projectSidMap.get(settle.getLong("projectId")));
            settle.remove("projectId");

            //获取申请人信息
            emp = empIdMap.get(settle.getLong("ApplyHumanId"));
            settle.put("ApplyHuman_Sid", emp.getSourceId());
            settle.put("ApplyHuman", emp.getName());
            settle.remove("ApplyHumanId");
            //获取审核人信息
            emp = empCodeMap.get(settle.getString("ApprHumanCode"));
            settle.put("ApprHuman_Sid", emp.getSourceId());
            settle.put("ApprHuman", emp.getName());

            //审核日期
            settle.put("ApprDate", DateFormatUtil.formatDate("yyyy-MM-dd", settle.getDate("ApprDate"))); //审核时间
            //申请日期
            settle.put("AppliyDate", DateFormatUtil.formatDate("yyyy-MM-dd", settle.getDate("AppliyDate"))); //审核时间

            //子表信息
            JSONArray subDetailArr = new JSONArray();
            settle.put("SubDetailList", subDetailArr);
            if (null != subDetailMap.get(settle.getLong("YQL_SID"))) {
                JSONObject detailJson = null;
                int idx = 1;
                for (DisposeDetailEntity detail : subDetailMap.get(settle.getLong("YQL_SID"))) {
                    detailJson = new JSONObject();
                    detailJson.put("Number", idx++); //序号
                    detailJson.put("MaterialType", detail.getMaterialTypeName()); //物料分类
                    detailJson.put("MaterialType_Sid", categorySidMap.get(detail.getMaterialTypeId())); //物料分类Sid
                    detailJson.put("MaterialCode", detail.getMaterialCode()); //物料编码
                    detailJson.put("MaterialName", detail.getMaterialName()); //物料名称
//                    detailJson.put("ProductName", ); //产品名称
                    detailJson.put("ProductCode", detail.getProductCode()); //产品代码
                    detailJson.put("SpecificationsModels", detail.getPropertyValue()); //规格型号
                    detailJson.put("MeteringUnit", StringUtils.isNotBlank(detail.getUnitName()) ? detail.getUnitName() : ""); //单位
                    detailJson.put("MeteringUnitSid", null != detail.getUnitId() ? ZDSInterfaceCommonUtil.changeLongToGUID(detail.getUnitId()) : PlanConstant.EMPTY_STR); //单位Sid
                    detailJson.put("BrandName", detail.getBrandName()); //品牌
                    detailJson.put("Num", detail.getNum().toPlainString()); //本次处置数量
                    detailJson.put("EstimatedDisposalTaxMny", detail.getTaxMny().toPlainString()); //预估处置金额
                    detailJson.put("Quantity", null != detail.getSurplusNum() ? detail.getSurplusNum().toPlainString() : 0); //剩余可处理数量
                    detailJson.put("YQL_SID", detail.getId()); //EL主键

                    subDetailArr.add(detailJson);
                }
            }
        }
        resp.put("records", pageList);

        return CommonResponse.success("查询成功！", resp);
    }

    @PostMapping(value = "syncZdsDisposeRecMny")
    public CommonResponse<String> syncZdsDisposeRecMny(@RequestBody JSONObject params) {
        logger.info("*********************中电四-现场收款信息同步任务 开始,参数：{}*********************", params.toString(SerializerFeature.PrettyFormat));
        Map<String, String> param = new HashMap<>();
        boolean noDate = null != params && null != params.get("noDate") ? params.getBoolean("noDate") : false;
        Integer pageNum = null != params.get("pageNum") ? params.getInteger("pageNum") : 1;
        Integer pageSize = null != params.get("pageSize") ? params.getInteger("pageSize") :
                Integer.valueOf(ZDSInterfaceCommonUtil.getErpDataBatchSize());

        String reqDateStr = null;
        String startDateStr = null;
        String endDateStr = null;
        if (null != params && null != params.get("startDate")) {
            startDateStr = params.getString("startDate");
            endDateStr = params.getString("endDate");
            param.put("BeginDateTime", startDateStr);
            param.put("EndDateTime", endDateStr);
        } else if(!noDate) {
            //同步当天数据
            startDateStr = DateFormatUtil.formatDate("yyyy-MM-dd", DateUtil.addDays(new Date(), -1)) + " 00:00:00";
            endDateStr = DateFormatUtil.formatDate("yyyy-MM-dd", new Date()) + " 23:59:59";
            param.put("BeginDateTime", startDateStr);
            param.put("EndDateTime", endDateStr);
        }

        JSONObject reqJson = null;
        JSONArray pageData = null;
        boolean hasNext = true;
        try {
            Map<String, String> headers = ZDSInterfaceCommonUtil.getErpHeaders();
            param.put("PageSize", pageSize.toString());
            param.put("PageNum", pageNum.toString());

            while (hasNext) {
                headers = ZDSInterfaceCommonUtil.getErpHeaders();
                logger.info("请求ERP现场收款：url-{},参数-{}", ZDSInterfaceCommonUtil.getErpReqHost()+SYNC_ERP_REC_MNY_URL, JSONObject.toJSONString(param));
                String reqResp = HttpTookit.postByJson(ZDSInterfaceCommonUtil.getErpReqHost()+SYNC_ERP_REC_MNY_URL, JSONObject.toJSONString(param), headers,
                        ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);
                reqJson = JSONObject.parseObject(reqResp);
                if ("ok".equals(reqJson.getString("status"))) {
                    pageData = reqJson.getJSONArray("data");
                    if (null != pageData && pageData.size() > 0) {
                        logger.info("中电现场收款同步，处理第{}页, {}条数据", pageNum, pageData.size());
                        handleErpPage(pageData);
                        if(pageData.size() < pageNum) {
                            hasNext = false;
                        }
                    } else {
                        logger.info("中电四现场收款同步 处理数据完成！！！总共{}页数据！", pageNum);
                        hasNext = false;
                    }
                } else {
                    logger.error("请求中电四现场收款结果返回失败：请求地址-{},参数-{},header-{},结果-{}", SYNC_ERP_REC_MNY_URL, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
                }
                pageNum++;
            }


        } catch (Exception e) {
            logger.error("获取中电四现场收款信息异常, 请求地址：{}, 请求参数：{}", SYNC_ERP_REC_MNY_URL, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat), e);
            return CommonResponse.error("同步中电四现场收款信息异常");
        }

        logger.info("*********************中电四-现场收款信息同步任务 结束*********************");
        return CommonResponse.success("现场收款同步任务执行成功！");
    }

    private void handleErpPage(JSONArray reqJsonArr) {
        JSONObject tmp = null;

        Map<Long, BigDecimal> applyIdMap = new HashMap<>();
        if(null != reqJsonArr && reqJsonArr.size() > 0) {
            for(Object obj : reqJsonArr) {
                tmp = (JSONObject) obj;
                applyIdMap.put(tmp.getLong("YQL_SID"), ComputeUtil.safeAdd(tmp.getBigDecimal("EstimatedDisposalAmount"), applyIdMap.get(tmp.getLong("YQL_SID"))));
            }

            List<DisposeEntity> dbEntities = service.getAllByIds(new ArrayList<>(applyIdMap.keySet()));

            List<DisposeEntity> saveList = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(dbEntities)) {
                for(DisposeEntity item : dbEntities) {
                    if(applyIdMap.containsKey(item.getId())) {
                        item.setRecDate(new Date()); //收款状态更新日期
                        item.setRecMny(applyIdMap.get(item.getId())); //收款金额
                        item.setRecMnyFlag(PlanConstant.STRING_YES); //收款状态
                        saveList.add(item);
                    }
                }
            }

            logger.info("本次更新处置申请：{}条", saveList.size());
            if(CollectionUtils.isNotEmpty(saveList)) {
                service.saveOrUpdateBatch(saveList, saveList.size(), false);
            }
        }
    }
}
