package com.ejianc.business.zdsmaterial.pick.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.pick.bean.ProPickSettingEntity;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubContractorEntity;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubPickerEntity;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubRangeEntity;
import com.ejianc.business.zdsmaterial.pick.service.IProPickSettingService;
import com.ejianc.business.zdsmaterial.pick.service.IProSubContractorService;
import com.ejianc.business.zdsmaterial.pick.service.IProSubPickerService;
import com.ejianc.business.zdsmaterial.pick.service.IProSubRangeService;
import com.ejianc.business.zdsstore.api.IStoreFlowApi;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author yqls
 * @Description:
 * @date 2024/01/13 18:02
 */
@RestController
@RequestMapping(value = "/api/pickset/")
public class ZdsPicksetApi {

    @Autowired
    private IProPickSettingService settingService;

    @Autowired
    private IProSubContractorService contractorService;

    @Autowired
    private IProSubPickerService pickerService;

    @Autowired
    private IProSubRangeService rangeService;

    @Autowired
    private IMaterialCategoryService categoryService;

    @Autowired
    private IStoreFlowApi flowApi;

    /**
     * 根据项目+合同，查询分包领料设置范围，过滤末级分类
     * @Author yqls
     * @param projectId
     * @param contractId
     * @return
     */
    @GetMapping("filterMaterialTypeIds")
    public CommonResponse<List<Long>> filterMaterialTypeIds(@RequestParam("projectId") Long projectId,
            @RequestParam("contractId") Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        List<ProPickSettingEntity> list = settingService.queryList(param);
        if(CollectionUtils.isEmpty(list)){
            return CommonResponse.success("查询成功！", new ArrayList<>());
        }
//        QueryParam cparam = new QueryParam();
//        cparam.getParams().put("settingId", new Parameter(QueryParam.EQ, list.get(0).getId()));
//        cparam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
//        List<ProSubContractorEntity> contList = contractorService.queryList(cparam);
//        if(CollectionUtils.isEmpty(contList)){
//            return CommonResponse.success("查询成功！", new ArrayList<>());
//        }
        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("settingSubcontractorId", new Parameter(QueryParam.EQ, contList.get(0).getId()));
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        List<ProSubRangeEntity> rangeList = rangeService.queryList(queryParam);
        if(CollectionUtils.isEmpty(rangeList)){
            return CommonResponse.success("查询成功！", new ArrayList<>());
        }

        List<Long> typeIds = rangeList.stream().map(ProSubRangeEntity::getMaterialTypeId).collect(Collectors.toList());
        QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
        query.in("id", typeIds);
        query.orderByDesc("inner_code");
        List<MaterialCategoryEntity> categorys = categoryService.list(query);
        if(CollectionUtils.isEmpty(categorys)){
            return CommonResponse.success("查询成功！", new ArrayList<>());
        }

        QueryWrapper<MaterialCategoryEntity> listQuery = new QueryWrapper<>();
        listQuery.select("id");
        listQuery.eq("dr", BaseVO.DR_UNDELETE);
        listQuery.eq("enabled", 1);// 启用
        listQuery.eq("property_flag", 1);// 设置属性，末级
        listQuery.and( q -> {
            for(MaterialCategoryEntity m : categorys) {
                q.or(iq -> iq.likeRight("inner_code", m.getInnerCode()));
            }
            return q;
        });
        List<Object> idList = categoryService.listObjs(listQuery);
        List<Long> ids = idList.stream().map(item -> Long.valueOf(item.toString())).collect(Collectors.toList());
        return CommonResponse.success("查询成功！", ids);
    }

//    /**
//     * 根据项目+仓库+领料人，扫码领料出库
//     * @Author yqls
//     * @return
//     */
//    @PostMapping(value = "scanOutStoreByPost")
//    public CommonResponse<JSONObject> scanOutStore(HttpServletRequest request){
//        String transData = request.getParameter("transData");
//        JSONObject json = JSON.parseObject(transData);
//        return this.scanOutStore(json.getLong("projectId"), json.getLong("storeId"), json.getLong("employeeId"));
//    }

    /**
     * 根据项目+仓库+领料人，扫码领料出库
     * @Author yqls
     * @param projectId
     * @param storeId
     * @param employeeId
     * @return
     */
    @GetMapping(value = "scanOutStore")
    public CommonResponse<JSONObject> scanOutStore(@RequestParam("projectId") Long projectId, @RequestParam("storeId") Long storeId,
            @RequestParam("employeeId") Long employeeId){
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        List<ProPickSettingEntity> list = settingService.queryList(param);
        if(CollectionUtils.isEmpty(list)){
            return CommonResponse.error("该项目未设置分包领料设置，请先设置后操作！");
        }
        ProPickSettingEntity entity = settingService.selectById(list.get(0).getId());

        List<ProSubContractorEntity> contList = entity.getProSubContractorList().stream().filter(x-> new Integer(1).equals(x.getEnabled())).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(contList)){
            return CommonResponse.error("该领料设置未设置启用的分包合同设置，请先设置后操作！");
        }

//        List<Long> contIds = contList.stream().map(ProSubContractorEntity::getId).collect(Collectors.toList());
        List<Long> contIds = contList.stream().map(ProSubContractorEntity::getContractId).collect(Collectors.toList());
        List<Long> finalContIds = contIds;
//        List<ProSubPickerEntity> pickerList = entity.getProSubPickerList().stream().filter(x-> finalContIds.contains(x.getSettingSubcontractorId())
        List<ProSubPickerEntity> pickerList = entity.getProSubPickerList().stream().filter(x-> finalContIds.contains(x.getContractId())
                && employeeId.equals(x.getSupUserId())).collect(Collectors.toList());;
        if(CollectionUtils.isEmpty(pickerList)){
            return CommonResponse.error("该领料人没有领料权限，请先设置后操作！");
        }
        ProSubPickerEntity picker = pickerList.get(0);

        // 分包合同受领料人过滤
//        contIds = pickerList.stream().map(ProSubPickerEntity::getSettingSubcontractorId).collect(Collectors.toList());
        contIds = pickerList.stream().map(ProSubPickerEntity::getContractId).collect(Collectors.toList());
        List<Long> finalContIds1 = contIds;
//        contList = contList.stream().filter(x-> finalContIds1.contains(x.getId())).collect(Collectors.toList());
        contList = contList.stream().filter(x-> finalContIds1.contains(x.getContractId())).collect(Collectors.toList());

        List<Long> finalContIds2 = contIds;
//        List<ProSubRangeEntity> rangeList = entity.getProSubRangeList().stream().filter(x-> finalContIds2.contains(x.getSettingSubcontractorId())).collect(Collectors.toList());
        List<ProSubRangeEntity> rangeList = entity.getProSubRangeList().stream().filter(x-> finalContIds2.contains(x.getContractId())).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(rangeList)){
            return CommonResponse.error("该领料人未设置领料范围，请先设置后操作！");
        }

        JSONArray contractList = JSONArray.parseArray(JSON.toJSONString(contList));
        for(Object vo : contractList){
            JSONObject obj = (JSONObject) vo;
            List<Long> typeIds = rangeList.stream().filter(x->obj.getLong("contractId").equals(x.getContractId())).
                    map(ProSubRangeEntity::getMaterialTypeId).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(typeIds)){
                // 根据领料范围+仓库查询末级物料分类库存列表
                List<SurplusVO> surplusList = this.querySurplusList(typeIds, storeId);
                obj.put("surplusList", surplusList);
            }
        }

        JSONObject result = JSONObject.parseObject(JSON.toJSONString(entity));
        result.put("supplierEmpId", picker.getSupUserId());// 分包商领料人Id
        result.put("supplierEmpName", picker.getSupplierEmpName());// 分包商领料人名称
        result.put("supplierEmpCode", picker.getSupplierEmpCode());// 分包商领料人编码
        result.put("supplierEmpPhone", picker.getSupplierEmpPhone());// 分包商领料人电话

        result.put("contractList", contractList);
//        result.put("surplusList", surplusList);
        return CommonResponse.success("查询成功！", result);
    }

    /**
     * 根据领料范围+仓库查询末级物料分类库存列表
     * @param typeIds
     * @return
     */
    private List<SurplusVO> querySurplusList(List<Long> typeIds, Long storeId) {
        QueryWrapper<MaterialCategoryEntity> query = new QueryWrapper<>();
        query.in("id", typeIds);
        query.orderByDesc("inner_code");
        List<MaterialCategoryEntity> categorys = categoryService.list(query);

        QueryWrapper<MaterialCategoryEntity> listQuery = new QueryWrapper<>();
        listQuery.select("id");
        listQuery.eq("dr", BaseVO.DR_UNDELETE);
        listQuery.eq("enabled", 1);// 启用
        listQuery.eq("property_flag", 1);// 设置属性，末级
        listQuery.and( q -> {
            for(MaterialCategoryEntity m : categorys) {
                q.or(iq -> iq.likeRight("inner_code", m.getInnerCode()));
            }
            return q;
        });
        List<Object> idList = categoryService.listObjs(listQuery);
        List<Long> ids = idList.stream().map(item -> Long.valueOf(item.toString())).collect(Collectors.toList());

        CommonResponse<List<SurplusVO>> resp = flowApi.refSurplusData(storeId);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        List<SurplusVO> result = resp.getData().stream().filter(x->ids.contains(x.getMaterialCategoryId())).collect(Collectors.toList());
        return result;
    }

}
