package com.ejianc.business.zdsmaterial.plan.conjecture.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.constants.ConjectureConstants;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.ConjectureEditVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureHisVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialSimpleConjectureVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 物料识别历史匹配记录实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialConjecture")
public class MaterialConjectureController implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialConjectureService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialConjectureVO> saveOrUpdate(@RequestBody MaterialConjectureVO saveOrUpdateVO) {
        MaterialConjectureEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialConjectureEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        MaterialConjectureVO vo = BeanMapper.map(entity, MaterialConjectureVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @PostMapping(value = "materialConjecture")
    @ResponseBody
    public CommonResponse<List<MaterialSimpleConjectureVO>> materialConjecture(@RequestBody List<MaterialConjectureVO> conjectureDescList, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        MaterialConjectureEntity tmp = null;
        List<MaterialConjectureEntity> saveList = new ArrayList<>();
        String uuid = UUID.randomUUID().toString();
        for(MaterialConjectureVO vo : conjectureDescList) {
            tmp = new MaterialConjectureEntity();
            if(null == vo.getSourceMaterialSpec()) {
                continue;
            }
            tmp.setSourceMaterialName(StringUtils.isNotBlank(vo.getSourceMaterialName()) ? vo.getSourceMaterialName() : vo.getSourceMaterialSpec());
            tmp.setSourceMaterialSpec(vo.getSourceMaterialSpec());
            tmp.setIdentificationId(uuid);
            tmp.setMateType("4");
            tmp.setIdentificationDate(new Date());

            saveList.add(tmp);
        }
        if(CollectionUtils.isEmpty(saveList)) {
            return CommonResponse.success(new ArrayList<>());
        }

        //保存入库
        service.saveOrUpdateBatch(BeanMapper.mapList(saveList, MaterialConjectureEntity.class), saveList.size(), false);

        //同步物料识别
        List<MaterialConjectureVO> result= service.materialConjecture(saveList, authority);

        List<MaterialSimpleConjectureVO> resultCodeList = BeanMapper.mapList(new ArrayList<>(result.stream().filter(item ->
                StringUtils.equals("2",item.getMateType())).collect(Collectors.toSet())), MaterialSimpleConjectureVO.class);
        return CommonResponse.success(resultCodeList);
    }


    /**
     *
     * @param materialVO
     * @return
     */
    @PostMapping(value = "/saveConjecture")
    @ResponseBody
    public CommonResponse<MaterialConjectureVO> saveConjecture(@RequestBody ConjectureEditVO materialVO) {
        MaterialConjectureEntity entity = service.selectById(materialVO.getConjectureId());
        entity.setActualMaterialId(materialVO.getMaterialId()); //最终物料Id
        entity.setActualCategoryId(materialVO.getCategoryId()); //最终物料分类Id
        entity.setActualCategoryName(materialVO.getCategoryName()); //最终物料分类名称
        entity.setActualMaterialSpec(materialVO.getPropertyShowName()); //最终规格型号
        entity.setActualMaterialCode(materialVO.getCode()); //最终物料编码
        if(CollectionUtils.isNotEmpty(materialVO.getRelationList())) {
            JSONArray specArr = new JSONArray();
            JSONObject json = null;
            for(MaterialPropertyRelationVO s : materialVO.getRelationList()) {
                json = BeanMapper.map(s, JSONObject.class);
                json.put("propertyItemId", s.getPropertyItemId().toString());
                json.put("id", s.getPropertyItemId().toString());
                json.put("categoryId", s.getCategoryId().toString());
                json.put("propertyId", s.getPropertyId().toString());
                specArr.add(json);
            }

            entity.setActualMaterialSpecs(specArr.toJSONString());
        }
        entity.setActualNum(materialVO.getNum());
        entity.setActualUnitId(materialVO.getUnitId());
        entity.setActualUnitName(materialVO.getUnitName());
        entity.setActualMaterialName(materialVO.getName());
        entity.setAdjustFlag(PlanConstant.INTEGER_YES); //是否调整：已调整
        entity.setMateType("2"); //调整为完全匹配

        service.saveOrUpdate(entity, false);

        return CommonResponse.success("操作成功!", BeanMapper.map(entity, MaterialConjectureVO.class));
    }

    @PostMapping(value = "/changeLoadStatus")
    @ResponseBody
    public CommonResponse<String> changeLoadStatus(@RequestBody List<Long> ids, @RequestParam String loadState) {
        UpdateWrapper<MaterialConjectureEntity> update = new UpdateWrapper<>();
        update.in("id", ids);
        update.set("load_state", loadState);
        update.set("update_user_code", InvocationInfoProxy.getUsercode());
        update.set("update_time", new Date());

        service.update(update);

        return CommonResponse.success("操作成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialConjectureVO> queryDetail(Long id) {
        MaterialConjectureEntity entity = service.selectById(id);
        MaterialConjectureVO vo = BeanMapper.map(entity, MaterialConjectureVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialConjectureVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MaterialConjectureVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MaterialConjectureVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<MaterialConjectureHisVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("createUserCode", new Parameter(QueryParam.NE, "adminscmm"));
        param.getParams().put("mateType", new Parameter(QueryParam.NE, ConjectureConstants.MATE_TYPE_TODO));
        param.getParams().put("conjectureMateType", new Parameter(QueryParam.NE, ConjectureConstants.MATE_TYPE_TODO));


        List<MaterialConjectureEntity> page = service.queryList(param,false);
        List<MaterialConjectureHisVO> pageData = new ArrayList<>();
//  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialConjectureVO.class));
        pageData.addAll(BeanMapper.mapList(page, MaterialConjectureHisVO.class));

        pageData.stream().filter(item -> StringUtils.isNotBlank(item.getActualMaterialSpecs())).forEach(item -> {
            List<MaterialPropertyRelationVO> relations = JSONArray.parseArray(item.getActualMaterialSpecs(), MaterialPropertyRelationVO.class);
            JSONObject propertyJson = new JSONObject();
            relations.stream().forEach(relationItem -> {
                propertyJson.put(relationItem.getPropertyName(), new String[]{StringUtils.isNotBlank(relationItem.getPropertyValue()) ? relationItem.getPropertyValue():"", relationItem.getPropertyId().toString(),
                        null != relationItem.getPropertyItemId() ? relationItem.getPropertyItemId().toString() : ""});
            });
            item.setAdjustFlag("1".equals(item.getAdjustFlag()) ? "已修订" : "未修订");
            item.setActualMaterialSpecs(propertyJson.toJSONString());
            item.setConjectureMateType(ConjectureConstants.MATE_TYPE_PARTIAL_MATCH.equals(item.getConjectureMateType()) ? "部分匹配" :
                    ConjectureConstants.MATE_TYPE_COMPLETE_MATCH.equals(item.getConjectureMateType()) ?
                            "全部匹配" : ConjectureConstants.MATE_TYPE_FAIL_MATCH.equals(item.getConjectureMateType()) ? "不匹配" : "匹配失败");
        });


        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MaterialConjectureEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialConjecture-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMaterialConjectureData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialConjectureVO>> refMaterialConjectureData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                 String condition,
                                                                                 String searchObject,
                                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaterialConjectureEntity> page = service.queryPage(param,false);
        IPage<MaterialConjectureVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialConjectureVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }
}
