package com.ejianc.business.zdsmaterial.plan.conjecture.handler.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertySubItemEntity;
import com.ejianc.business.zdsmaterial.material.service.*;
import com.ejianc.business.zdsmaterial.material.vo.*;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.constants.ConjectureConstants;
import com.ejianc.business.zdsmaterial.plan.conjecture.handler.IMaterialConjectureHandler;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.sub.settle.utils.HttpTookit;
import com.ejianc.foundation.ai.vo.material.AiMaterialParam;
import com.ejianc.foundation.ai.vo.material.AiMaterialVO;
import com.ejianc.foundation.ai.vo.material.ExtProperty;
import com.ejianc.foundation.ai.vo.material.MatchProperty;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.refer.constants.ReferConstant;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.base.Stopwatch;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 益企联
 * @Author: caojie
 * @CreateTime:2025-02-10 15:42
 * @Version: 1.0
 */
@Component("yQLHandler")
public class YQLHandler implements IMaterialConjectureHandler {

    public static final int connTimeout = 300000;
    public static final int readTimeout = 300000;
    private static final String BILL_TYPE_CODE = "EJCBT202311000003";
    private final String propertySeparator = "；";
    private final String propertyNameValueSep = "：";
    /**
     * 物料智能识别
     */
    private final String CONJECTURE_SINGLE_MATERIAL_URL = "/extract_item_attr";
    /**
     * 价格库智能查询
     */
    private final String SEARCH_MATERIAL_URL = "/similar_item_search";
    private final String reqUrl = "https://portal.17elian.com/ejc-ai-web/ai/material/recognize";
    @Autowired
    private ICommonSNService commonSNService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${material.ai.host:http://58.19.19.195:17011}")
    private String reqHost;
    @Value("${material.ai.similarLimit:100}")
    private Integer similarLimit;
    @Value("${material.ai.similarThreshold:0}")
    private BigDecimal similarThreshold;
    @Autowired
    private IMaterialCategoryPropertyService propertyService;
    @Autowired
    private IMaterialConjectureService conjectureService;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private EnvironmentTools environmentTools;

    private final String SYS_PARAM_CONFIG = "P-Fw47U70005";
    private final String ADD_PROPERTY_ITEM_KEY_PREFIX = "AI_CONJECTURE_ADD_ITEM::";
    private final String PROPERTY_ITEM_MAX_SEQ_KEY_PREFIX = "AI_CONJECTURE_ITEM_MAX_SEQ::";
    @Autowired
    private IMaterialCategoryPropertySubItemService propertySubItemService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private JedisPool jedisPool;

    @Override
    public Future<List<MaterialConjectureVO>> conjecture(List<MaterialConjectureVO> sourceList, String authority) {
        setContextInfo(authority);
        boolean saveNewPropertyItem = false;

        List<AiMaterialParam> conjectureParams =  sourceList.stream().map(item -> {
            AiMaterialParam tmp = new AiMaterialParam();
            tmp.setId(item.getId().toString());
            tmp.setItemName(item.getSourceMaterialName());
            tmp.setItemDesc(item.getSourceMaterialSpec());
            return tmp;
        }).collect(Collectors.toList());
        Map<Long, MaterialConjectureVO> sourceMap = sourceList.stream().collect(Collectors.toMap(MaterialConjectureVO::getId, Function.identity()));

        List<AiMaterialVO> conjectureData = null;
        try {

            //系统参数查询
            CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(SYS_PARAM_CONFIG);
            if (!response.isSuccess() || response.getData() == null) {
                logger.error("查询 AI识别属性自动入库 配置失败或为空 ，走默认不新增逻辑******", JSONObject.toJSONString(response, SerializerFeature.PrettyFormat));
            } else if(StringUtils.equals("1", response.getData().getValueData())) {
                saveNewPropertyItem = true;
            }

//            CommonResponse<List<AiMaterialVO>> conjectureResult = materialAiApi.aiMaterialRecognize(conjectureParams);
            Stopwatch start = Stopwatch.createStarted();
            //请求URL
            String url =  reqUrl; //environmentTools.getBaseHost() +
            Map<String, String> headers = new HashMap<>();
            headers.put("Content-Type", "application/json;charset=UTF-8");
            headers.put("authority", authority);

            String reqResult = HttpTookit.postByJson(url, JSONObject.toJSONString(conjectureParams), headers, connTimeout, readTimeout);
//
            Stopwatch end = start.stop();
            logger.info("************ 物料AI识别，耗时：{} 秒", end.elapsed(TimeUnit.SECONDS));
            logger.info("************ 物料AI识别，结果：{} ", JSONObject.toJSONString(reqResult));

            CommonResponse<List<AiMaterialVO>> conjectureResult = JSONObject.parseObject(reqResult, CommonResponse.class);
            if(!conjectureResult.isSuccess()) {
                //识别失败
                logger.error("************ 物料AI识别失败，参数：{}, 结果：{}", JSONObject.toJSONString(conjectureParams), JSONObject.toJSONString(conjectureResult));

                sourceList.stream().forEach(item -> item.setMateType(ConjectureConstants.MATE_TYPE_FAIL_MATCH));
                conjectureService.saveOrUpdateBatch(BeanMapper.mapList(sourceList, MaterialConjectureEntity.class), sourceList.size(), false);
                return new AsyncResult<>(sourceList);
            }

//            conjectureData = conjectureResult.getData();
            conjectureData = JSONArray.parseArray(JSONObject.toJSONString(conjectureResult.getData()), AiMaterialVO.class);

            //识别成功
            Map<Long, MaterialCategoryVO> categoryMap = new HashMap<>();
            Set<Long> categoryIds = conjectureData.stream().filter(item -> null != item.getCategory() && StringUtils.isNotBlank(item.getCategory().getCategoryId()))
                    .map(item -> Long.valueOf(item.getCategory().getCategoryId())).collect(Collectors.toSet());
            if(CollectionUtils.isNotEmpty(categoryIds)) {
                List<MaterialCategoryVO> categoryList = categoryService.getAllByIds(new ArrayList<>(categoryIds));
                categoryMap.putAll(categoryList.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity())));
            }

            MaterialConjectureVO source = null;
            MaterialCategoryVO category = null;
            Map<Long, List<MaterialCategoryPropertyVO>> propertyCache = new HashMap<>();
            MaterialCategoryPropertyVO tmpProperty = null;
            MaterialCategoryPropertySubItemVO tmpItem = null;
            List<Long> secCategoryId = new ArrayList<>();
            for(AiMaterialVO ma : conjectureData) {
                source = sourceMap.get(Long.valueOf(ma.getId()));
                sourceMap.remove(Long.valueOf(ma.getId()));
                if(null == ma.getCategory() || StringUtils.isBlank(ma.getCategory().getCategoryId())) {
                    //标记为不匹配
                    source.setMateType(ConjectureConstants.MATE_TYPE_MIS_MATCH);
                    source.setConjectureMateType(ConjectureConstants.MATE_TYPE_MIS_MATCH);
                    continue;
                }

                //请求处理且识别成功
                source.setConjectureMaterialSpecs(JSONObject.toJSONString(ma));

                //处理
                category = categoryMap.get(Long.valueOf(ma.getCategory().getCategoryId()));
                if(null == category) {
                    //标记为不匹配
                    source.setMateType("0");
                    source.setConjectureMateType("0");
                    continue;
                }
                source.setConjectureCategoryId(category.getId());
                source.setActualSecCategoryId(category.getParentId());
                if(!secCategoryId.contains(category.getParentId())) {
                    secCategoryId.add(category.getParentId());
                }
                source.setConjectureCategoryName(category.getName());
                source.setConjectureMaterialName(category.getName());
                source.setActualCategoryId(category.getId());
                source.setActualCategoryName(category.getName());
                source.setActualMaterialName(category.getName());

                //查询物料分类下所有属性及属性值
                List<MaterialCategoryPropertyVO> propertyList = null;
                if(CollectionUtils.isEmpty(ma.getMatchProperties())) {
                    //标记为部分匹配
                    source.setMateType(ConjectureConstants.MATE_TYPE_PARTIAL_MATCH);
                    source.setConjectureMateType(ConjectureConstants.MATE_TYPE_PARTIAL_MATCH);
                    continue;
                }

                if(propertyCache.containsKey(category.getId())) {
                    propertyList = propertyCache.get(category.getId());
                } else {
                    propertyList = propertyService.getAllPropertiesAndValue(source.getConjectureCategoryId(), null, null);
                    propertyCache.put(category.getId(), propertyList);
                }

                Map<Long, MaterialCategoryPropertyVO> propertyVOMap = propertyList.parallelStream().collect(Collectors.toMap(MaterialCategoryPropertyVO::getId, Function.identity()));
                Map<String, MaterialCategoryPropertyVO> propertyNameVOMap = propertyList.parallelStream().collect(Collectors.
                        toMap(MaterialCategoryPropertyVO::getName, Function.identity(), (v1,v2) -> v1));
                Map<Long, MaterialCategoryPropertySubItemVO> itemMap = propertyList.stream()
                        .flatMap(item -> item.getItemList().stream()).collect(Collectors.toMap(MaterialCategoryPropertySubItemVO::getId,
                                Function.identity(), (v1,v2) -> v1));

                for(MatchProperty p : ma.getMatchProperties()) {
                    if(StringUtils.isBlank(p.getPropertyId()) || "null".equals(p.getPropertyId()) || !propertyVOMap.containsKey(Long.valueOf(p.getPropertyId()))) {
                        continue;
                    }
                    if(StringUtils.isBlank(p.getPropertyValueId()) || "null".equals(p.getPropertyValueId()) || !itemMap.containsKey(Long.valueOf(p.getPropertyValueId()))) {
                        continue;
                    }
                    tmpProperty = propertyVOMap.get(Long.valueOf(p.getPropertyId()));
                    tmpItem = new MaterialCategoryPropertySubItemVO();

                    //分类属性
                    tmpItem.setCategoryId(category.getId());
                    tmpItem.setHasNewPropertyVal(0);
                    //属性名
                    tmpItem.setPropertyName(tmpProperty.getName());
                    //属性值
                    tmpItem.setId(Long.valueOf(p.getPropertyValueId()));
                    tmpItem.setName(itemMap.get(tmpItem.getId()).getName());
                    tmpItem.setPropertyId(tmpProperty.getId());

                    tmpItem.setSequence(itemMap.get(tmpItem.getId()).getSequence());
                    tmpItem.setProductCode(itemMap.get(tmpItem.getId()).getProductCode());
                    tmpItem.setPropertySeq(tmpProperty.getSequence());
                    tmpItem.setProductCodeFlag(tmpProperty.getProductCodeFlag());
                    tmpItem.setRequiredFlag(tmpProperty.getRequiredFlag());
                    tmpItem.setKeyPropertyFlag(tmpProperty.getKeyPropertyFlag());

                    source.getSpecList().add(tmpItem);
                    //去掉已匹配的属性
                    propertyVOMap.remove(tmpItem.getPropertyId());
                }

                if(CollectionUtils.isNotEmpty(ma.getExtProperties()) && saveNewPropertyItem) {
                    //新增不在库的属性
                    for(ExtProperty exp : ma.getExtProperties()) {
                        tmpItem = null;
                        tmpProperty = propertyNameVOMap.get(exp.getPropertyKey());
                        if(null != tmpProperty) {
                            try {
                                if(CollectionUtils.isNotEmpty(tmpProperty.getItemList())) {
                                    //根据名称 判断属性是否已在库
                                    List<MaterialCategoryPropertySubItemVO> matchList = tmpProperty.getItemList().stream().filter(item -> item.getName().toLowerCase()
                                            .equals(exp.getPropertyValue().toLowerCase())).collect(Collectors.toList());
                                    if(CollectionUtils.isNotEmpty(matchList)) {
                                        tmpItem = matchList.get(0);
                                        tmpItem.setPropertyName(tmpProperty.getName());
                                        tmpItem.setPropertySeq(tmpProperty.getSequence());
                                        tmpItem.setRequiredFlag(tmpProperty.getRequiredFlag());
                                        tmpItem.setKeyPropertyFlag(tmpProperty.getKeyPropertyFlag());
                                    }
                                }

                                if(null == tmpItem) {
                                    tmpItem = generateNewPropertyItem(tmpProperty, exp.getPropertyValue());
                                }

                                tmpProperty.getItemList().add(tmpItem);
                                itemMap.put(tmpItem.getId(), tmpItem);

                                source.getSpecList().add(tmpItem);

                                //去掉已匹配的属性
                                propertyVOMap.remove(tmpItem.getPropertyId());
                            } catch (Exception e) {
                                logger.error("物料AI:{}识别，新增属性:{}失败：", JSONObject.toJSONString(ma), JSONObject.toJSONString(exp));
                            }
                        }
                    }
                }

                if(ConjectureConstants.MATE_TYPE_TODO.equals(source.getMateType())) {

                    //验证是否所有必填属性都已匹配 且有值
                    if(propertyVOMap.values().stream().filter(item -> null != item.getRequiredFlag() && Integer.valueOf(1).equals(item.getRequiredFlag())).count() > 0) {
                        //存在必填属性未匹配或描述中未填写 设置为部分匹配
                        source.setMateType("1");
                        source.setConjectureMateType("1");
                    } else {
                        //若物料属性都已匹配，则标记为完全匹配
                        source.setMateType("2");
                        source.setConjectureMateType("2");

                        //查询是否匹配已在库的物料档案
                        MaterialVO checkVo = new MaterialVO();
                        checkVo.setUnitId(source.getActualUnitId());
                        checkVo.setPropertyShowName(source.getActualMaterialSpec());
                        checkVo.setCategoryId(source.getActualCategoryId());
                        List<MaterialVO> checkList = materialService.checkUnitAndProperty(Collections.singletonList(checkVo), false);
                        if(CollectionUtils.isNotEmpty(checkList)) {
                            source.setActualMaterialCode(checkList.get(0).getCode());
                        }
                    }
                }

                //若缺少物料编码，则生成物料编码
                if(StringUtils.isBlank(source.getActualMaterialCode())) {
                    //生成物料编码
                    MaterialVO tmp = generateMaterial(source);
                    materialService.generateMaterialCodeBatchNew(Collections.singletonList(tmp));
                    source.setActualMaterialCode(tmp.getCode());
                }

                if(CollectionUtils.isNotEmpty(source.getSpecList())) {
                    //按照属性排序 组装物料规格型号
                    source.setConjectureMaterialSpec(source.getSpecList().stream().filter(item -> null != item.getId()).sorted((v1,v2) -> {
                        return (null != v1.getPropertySeq() ? v1.getPropertySeq() : 0) - (null != v2.getPropertySeq() ? v2.getPropertySeq() : 0);
                    }).map(item -> item.getPropertyName() + propertyNameValueSep + item.getName()).collect(Collectors.joining(propertySeparator)));
                    source.setActualMaterialSpec(source.getConjectureMaterialSpec());
                }
                //存储规格型号集合
                if(CollectionUtils.isNotEmpty(source.getSpecList())) {
                    JSONArray specArr = new JSONArray();
                    JSONObject json = null;
                    for(MaterialCategoryPropertySubItemVO s : source.getSpecList()) {
                        json = BeanMapper.map(s, JSONObject.class);
                        json.put("id", s.getId().toString());
                        json.put("propertyItemId", s.getId().toString());
                        json.put("categoryId", s.getCategoryId().toString());
                        json.put("propertyId", s.getPropertyId().toString());
                        specArr.add(json);
                    }
                    source.setActualMaterialSpecs(specArr.toJSONString());
                }
            }

            //设置二级物料分类信息
            if(CollectionUtils.isNotEmpty(secCategoryId)) {
                List<MaterialCategoryVO> secList= categoryService.queryCategoryListByIds(secCategoryId);
                Map<Long, MaterialCategoryVO> secMap = secList.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (v1,v2) -> v1));
                for(MaterialConjectureVO s :sourceList) {
                    if(null != s.getActualSecCategoryId() && secMap.containsKey(s.getActualSecCategoryId())) {
                        s.setActualSecCategoryCode(secMap.get(s.getActualSecCategoryId()).getCode());
                        s.setActualSecCategoryName(secMap.get(s.getActualSecCategoryId()).getName());
                    }
                }
            }

            if(!sourceMap.isEmpty()) {
                //当前批次未 返回的项标记为不匹配
                sourceMap.values().stream().forEach(item -> item.setMateType(ConjectureConstants.MATE_TYPE_MIS_MATCH));
            }

            conjectureService.saveOrUpdateBatch(BeanMapper.mapList(sourceList, MaterialConjectureEntity.class), sourceList.size(), false);
        } catch (Exception e) {
            logger.error("************ 物料AI识别失败异常", e);
            sourceList.stream().filter(item -> sourceMap.containsKey(item.getId())).forEach(item -> item.setMateType(ConjectureConstants.MATE_TYPE_FAIL_MATCH));
            logger.error("将当前：｛｝条物料 识别状态更新为： 识别失败. 识别批次：{}", sourceList.size(), sourceList.get(0).getIdentificationId());
            boolean saveFlag = conjectureService.saveOrUpdateBatch(BeanMapper.mapList(sourceList, MaterialConjectureEntity.class), sourceList.size(), false);
            logger.error("将当前条物料 识别状态更新为： 识别失败. 结果：{}", sourceList.size(), saveFlag);

            return new AsyncResult<>(sourceList);
        }

        return new AsyncResult<>(sourceList);
    }

    private MaterialVO generateMaterial(MaterialConjectureVO source) {
        MaterialVO resp = new MaterialVO();
        resp.setName(source.getActualMaterialName());
        resp.setCategoryId(source.getActualCategoryId());
        resp.setCategoryName(source.getActualCategoryName());
        resp.setUnitId(source.getActualUnitId());
        resp.setUnitName(source.getActualUnitName());
        resp.setUnitId(source.getActualUnitId());
        List<MaterialPropertyRelationVO> relations = new ArrayList<>();
        for(MaterialCategoryPropertySubItemVO item : source.getSpecList()) {
            MaterialPropertyRelationVO s = new MaterialPropertyRelationVO();
            s.setPropertySequence(item.getPropertySeq());
            s.setPropertyValue(item.getName());
            s.setCategoryId(item.getCategoryId());
            s.setPropertyName(item.getPropertyName());
            s.setProductCode(item.getProductCode());
            s.setPropertyId(item.getPropertyId());
            s.setProductCodeFlag(item.getProductCodeFlag());
            s.setPropertyItemId(item.getId());

            relations.add(s);
        }
        resp.setRelationList(relations);
        resp.setPropertyShowName(source.getActualMaterialSpec());
        return resp;
    }

    private MaterialCategoryPropertySubItemVO generateNewPropertyItem(MaterialCategoryPropertyVO property, String itemName) {
        MaterialCategoryPropertySubItemVO resp = null;
        Jedis jedis = jedisPool.getResource();

        try {
            //检测当前属性是否在其他地方 入库
            String itemStr = jedis.get(ADD_PROPERTY_ITEM_KEY_PREFIX+property.getId().toString()+itemName.toLowerCase());

            if(StringUtils.isNotBlank(itemStr)) {
                //已存在
                resp = JSONObject.parseObject(itemStr, MaterialCategoryPropertySubItemVO.class);
            } else {
                //不存在
                resp = new MaterialCategoryPropertySubItemVO();
                resp.setName(itemName);
                resp.setPropertyName(property.getName());
                resp.setId(IdWorker.getId());
                resp.setRequiredFlag(0);
                resp.setEnabled(1);
                resp.setProductCodeFlag(0);
                resp.setProductCode(null);
                resp.setCategoryId(property.getCategoryId());
                resp.setPropertyId(property.getId());
                resp.setPropertySeq(property.getSequence());
                resp.setValidFlag(1);

                if(null != resp) {
                    Integer maxSeq = CollectionUtils.isNotEmpty(property.getItemList()) ? property.getItemList().stream()
                            .max(Comparator.comparingInt(MaterialCategoryPropertySubItemVO::getSequence)).get().getSequence() : 0;
                    //获取最大排序号
                    String maxSeqStr = jedis.get(PROPERTY_ITEM_MAX_SEQ_KEY_PREFIX+resp.getPropertyId().toString());
                    if(StringUtils.isBlank(maxSeqStr)) {
                        maxSeqStr = "0";
                    }
                    maxSeq = maxSeq > Integer.valueOf(maxSeqStr) ? maxSeq : Integer.valueOf(maxSeqStr);
                    maxSeq = maxSeq+1;
                    jedis.setex(PROPERTY_ITEM_MAX_SEQ_KEY_PREFIX+resp.getPropertyId().toString(), 60 * 2, maxSeq.toString());
                    resp.setSequence(maxSeq);
                }

                //放入缓存
                Long setRs = jedis.setnx(ADD_PROPERTY_ITEM_KEY_PREFIX+resp.getPropertyId().toString()+resp.getName().toLowerCase(), JSONObject.toJSONString(resp));
                if(!"1".equals(setRs.toString())) {
                    //设置不成功，尝试再次获取
                    itemStr = jedis.get(ADD_PROPERTY_ITEM_KEY_PREFIX+resp.getPropertyId().toString()+resp.getName().toLowerCase());
                    if(StringUtils.isNotBlank(itemStr)) {
                        //已存在
                        resp = JSONObject.parseObject(itemStr, MaterialCategoryPropertySubItemVO.class);
                    } else {
                        setRs = jedis.setnx(ADD_PROPERTY_ITEM_KEY_PREFIX+resp.getPropertyId().toString()+resp.getName().toLowerCase(), JSONObject.toJSONString(resp));
                        if(!"1".equals(setRs.toString())) {
                            //属性添加失败
                            logger.error("物料AI识别，属性{} 值{}添加失败，{}", JSONObject.toJSONString(property), itemName);
                            return null;
                        }
                    }
                }

                //保存
                propertySubItemService.saveOrUpdate(BeanMapper.map(resp, MaterialCategoryPropertySubItemEntity.class), false);
            }
        } catch (Exception e) {
            logger.error("物料AI识别，新增属性失败：", e);
            resp = null;
        } finally {
            if (jedis != null) {
                jedis.close();
            }
        }

        return resp;
    }

    private void setContextInfo(String authority) {
        InvocationInfoProxy.setExtendAttribute("authority", authority);
        InvocationInfoProxy.setParameter(ReferConstant.HEAD_authority, authority);
        String[] authArr = authority.split(";");
        for(String item : authArr) {
            String[] authItem = item.split("=");
            switch (authItem[0]) {
                case "tenantid":
                    InvocationInfoProxy.setTenantid(Long.valueOf(authItem[1]));
                    break;
                case "orgId":
                    InvocationInfoProxy.setOrgId(Long.valueOf(authItem[1]));
                    break;
                case "userId":
                    InvocationInfoProxy.setUserid(Long.valueOf(authItem[1]));
                    break;
                case "userType":
                    InvocationInfoProxy.setUserType(authItem[1]);
                    break;
                case "userCode":
                    InvocationInfoProxy.setUsercode(authItem[1]);
                    break;
                default:;
            }
        }

    }

    @Override
    public Map<Long, MaterialConjectureVO> similarSearch(String searchText, Integer topLimit, String[] queryRange) {

        Map<Long, MaterialConjectureVO> resp = new HashMap<>();

        //请求URL
        String url = reqHost + SEARCH_MATERIAL_URL;
        JSONObject param = new JSONObject();
        Map<String, String> headers = new HashMap<>();
        String reqResult = null;

        try {
            headers.put("Content-Type", "application/json;charset=UTF-8");

            param.put("user_query", searchText); //自然语言查询语句
            param.put("query_limit", null != topLimit ? topLimit : similarLimit); //返回top k个最相似结果
            param.put("query_rang", queryRange); //物料类型限制，以数组形式传入

            reqResult = HttpTookit.postByJson(url, param.toJSONString(), headers, connTimeout, readTimeout);
            logger.info("物料AI匹配【长江云通】, 地址：{}, 参数：{}，物料识别结果：{}", url, JSONObject.toJSONString(param), reqResult);
            JSONArray matchArr = JSONArray.parseArray(reqResult);
            MaterialConjectureVO tmpVo = null;
            if(matchArr.size() > 0) {
                JSONObject tmpJson = null;
                Map<Long, BigDecimal> materialIds = new HashMap<>();
                for(Object obj : matchArr) {
                    tmpJson = (JSONObject) obj;
                    if(similarThreshold.compareTo(tmpJson.getBigDecimal("distance")) <= 0) {
                        tmpVo = new MaterialConjectureVO();
                        tmpVo.setActualMaterialId(tmpJson.getLong("id"));
                        tmpVo.setSimilarCoefficient(ComputeUtil.safeMultiply(tmpJson.getBigDecimal("distance"), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_DOWN));
                        resp.put(tmpVo.getActualMaterialId(), tmpVo);
                    }
                }
            }
        } catch (Exception e) {
            logger.error("物料AI匹配异常,", e);
        }

        return resp;
    }
}
