package com.ejianc.business.zdsmaterial.plan.control.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.material.vo.PurchaseAnalysisVo;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanSumDetailEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanDetailEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 物资总控计划汇总明细
 * 
 * @author generator
 * 
 */
public interface IControlPlanSumDetailService extends IBaseService<ControlPlanSumDetailEntity> {

    /**
     * 根据物料主键查询对应汇总明细
     * @param materialIds
     * @return
     */
    List<PurchasePlanDetailEntity> queryList(List<Long> materialIds, Long projectId);
    List<ControlPlanSumDetailEntity> queryListBySum(List<Long> materialIds, Long projectId);


    List<PurchaseAnalysisVo> getList(Map<String, Object> params);
    List<PurchaseAnalysisVo> countChangeNum(Map<String, Object> params);
    long count(Map<String, Object> params);

    List<JSONObject> querySubByPlanIds(List<Long> planIds, List<Long> projectIds);
}
