package com.ejianc.business.zdsmaterial.plan.control.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.erp.vo.SyncJobExecRecordsVO;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialSourceVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsmaterial.plan.control.bean.*;
import com.ejianc.business.zdsmaterial.plan.control.service.*;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanService;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.business.pub.utils.*;
import java.math.BigDecimal;
import java.security.MessageDigest;
import com.ejianc.business.zdsmaterial.util.DateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("controlPlan") 
public class ControlPlanBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IControlPlanService service;

	@Autowired
	private IControlPlanDetailService detailService;

	@Autowired
	private IControlPlanImportService importService;

	@Autowired
	private IPurchasePlanService purchaseService;

	@Autowired
	private IPurchasePlanDetailService purchaseDetailService;

	@Autowired
	private IControlPlanSumService sumService;

	@Autowired
	private IControlPlanSumDetailService sumDetailService;

	@Autowired
	private IMaterialService materialService;

	@Autowired
	private IMaterialCategoryService categoryService;

	@Autowired
	private IAttachmentApi attachmentApi;

	@Autowired
	private IBillTypeApi billTypeApi;

	@Value("${common.env.base-host}")
	private String baseHost;
	//ERP查询成控人员接口
	private final String ERP_INQUIRY_COSTCONTROL_URL = "/SignLogin/SignLogin";
	@Value("${erp.reqHost}")
    private String ERP_SSO_HOST;
	@Value("${erp.appId}")
    private String appId;

    @Value("${erp.secret}")
    private String secret;

    @Value("${erp.reqHost}")
    private String reqHost;

    @Value("${erp.batchSize:100}")
    private String batchSize;
	@Autowired
    private IEmployeeApi employeeApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		ControlPlanEntity entity = service.selectById(billId);
		if(CollectionUtils.isEmpty(entity.getDetailList())) {
			return CommonResponse.error("请至少添加一条清单信息！");
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		getCostcontrolInfor(billId);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ControlPlanEntity entity = service.selectById(billId);
		// 推送汇总单
		this.pushToSum(entity);

		// 推送导入清单
		this.pushToImport(entity);

		// 推送物料库
//		this.pushToMaterial(entity);
		return CommonResponse.success();
	}

	/**
	 * 推送导入清单
	 * @param entity
	 */
	private void pushToImport(ControlPlanEntity entity) {
		List<ControlPlanDetailEntity> detailList = entity.getDetailList().stream().filter(x->StringUtils.isNotEmpty(x.getDescription())).collect(Collectors.toList());
		QueryWrapper<ControlPlanImportEntity> ew = new QueryWrapper<>();
		ew.and(q -> {
			for(ControlPlanDetailEntity f : detailList) {
				q.or(iq -> iq.eq("material_id", f.getMaterialId()).eq("description", f.getDescription()));
			}
			return q;
		});
		List<ControlPlanImportEntity> list = importService.list(ew);
		Set<String> set = list.stream().map(x ->x.getMaterialId() + "@" + x.getDescription()).collect(Collectors.toSet());

		List<ControlPlanImportEntity> saveList = BeanMapper.mapList(detailList, ControlPlanImportEntity.class);
		saveList = saveList.stream().filter(x->!set.contains(x.getMaterialId() + "@" + x.getDescription())).collect(Collectors.toList());
		if(CollectionUtils.isNotEmpty(saveList)){
			saveList.forEach(vo->{
				vo.setId(null);
				vo.setCreateTime(null);
				vo.setCreateUserCode(null);
				vo.setUpdateTime(null);
				vo.setUpdateUserCode(null);
				vo.setVersion(null);
				vo.setRowState("add");
			});
			importService.saveOrUpdateBatch(saveList);
		}
	}

	/**
	 * 推送物料库
	 * @param entity
	 */
	private void pushToMaterial(ControlPlanEntity entity) {
		List<ControlPlanDetailEntity> detailList = entity.getDetailList();
		detailList = detailList.stream().filter(x->PlanConstant.SOURCE_TYPE_NEW.equals(x.getSourceType())).collect(Collectors.toList());
		if(CollectionUtils.isEmpty(detailList)){
			return;
		}
		List<Long> typeIds = detailList.stream().map(ControlPlanDetailEntity::getMaterialTypeId).distinct().collect(Collectors.toList());
		QueryParam param = new QueryParam();
		param.getParams().put("id", new Parameter(QueryParam.IN, typeIds));
		List<MaterialCategoryEntity> typeList = categoryService.queryList(param);
		Map<Long, MaterialCategoryEntity> typeMap = typeList.stream().collect(Collectors.toMap(x->x.getId(), x->x));

		List<MaterialVO> saveList = new ArrayList<>();
		detailList.forEach(data->{
			MaterialVO vo = new MaterialVO();
			vo.setId(data.getMaterialId());
			vo.setCode(data.getMaterialCode());
			vo.setName(data.getMaterialName());
			vo.setCategoryId(data.getMaterialTypeId());
			vo.setCategoryCode(typeMap.get(data.getMaterialTypeId()).getCode());
			vo.setCategoryName(data.getMaterialTypeName());
			vo.setUnitId(data.getUnitId());
			vo.setUnitName(data.getUnitName());
			vo.setEnabled(ZDSMaterialCommonEnums.停启用_启用.getCode());
			vo.setBlockedFlag(ZDSMaterialCommonEnums.封存_正常.getCode());
			vo.setSystemId("sys");
			vo.setProductCode(data.getProductCode());
			vo.setSourceId(String.valueOf(data.getId()));
			vo.setPropertyShowName(data.getPropertyValue());
			vo.setRelationList(JSONArray.parseArray(data.getProperty(), MaterialPropertyRelationVO.class));
			List<MaterialSourceVO> sourceList = new ArrayList<>();
			MaterialSourceVO materialSourceVO = new MaterialSourceVO();
			materialSourceVO.setMaterialId(data.getMaterialId());
			materialSourceVO.setBillType("EJCBT202311000004");
			materialSourceVO.setBillTypeName("物资总控计划编制");
			materialSourceVO.setSourceBillCode(entity.getBillCode());
			materialSourceVO.setSourcePid(entity.getId());
			materialSourceVO.setSourceDetailId(data.getId());
			materialSourceVO.setSourceBillPcUrl(baseHost + "ejc-zdsmaterial-frontend/#/controlPlan/card");
			materialSourceVO.setSourceCreateUserCode(entity.getCreateUserCode());
			materialSourceVO.setSourceCreateUserName(entity.getCreateUserName());
			materialSourceVO.setSourceCreateTime(entity.getCreateTime());
			materialSourceVO.setSourceCreateTime(entity.getCreateTime());
			materialSourceVO.setSourceOrgName(entity.getOrgName());
			sourceList.add(materialSourceVO);
			vo.setSourceList(sourceList);

			saveList.add(vo);
		});
		List<MaterialVO> materialVOS = materialService.addNewMaterialsFromBill(saveList);
		Map<String, List<MaterialVO>> map = materialVOS.stream().collect(
				Collectors.groupingBy(
						s->s.getName()+'-'+(StringUtils.isNotBlank(s.getPropertyShowName()) ? s.getPropertyShowName() : "")+'-'+s.getUnitId()
				));
		for (ControlPlanDetailEntity controlPlanDetailEntity : detailList){
			String key = controlPlanDetailEntity.getMaterialName() + "-" + (StringUtils.isNotBlank(controlPlanDetailEntity.getPropertyValue()) ? controlPlanDetailEntity.getPropertyValue() : "") + "-" + controlPlanDetailEntity.getUnitId();
			if (map.containsKey(key)) {
				MaterialVO materialVOS1 = map.get(key).get(0);
				controlPlanDetailEntity.setMaterialId(materialVOS1.getId());
				controlPlanDetailEntity.setMaterialCode(materialVOS1.getCode());
			}
		}
		detailService.saveOrUpdateBatch(detailList);
	}

	/**
	 * 推送汇总单
	 * @param entity
	 * @return
	 */
	private ControlPlanSumEntity pushToSum(ControlPlanEntity entity) {
		logger.info("--> 单据：" + entity.getId() + "汇总开始");
		LambdaQueryWrapper<ControlPlanSumEntity> ew = new LambdaQueryWrapper<>();
		ew.eq(ControlPlanSumEntity::getProjectId, entity.getProjectId());
		List<ControlPlanSumEntity> sumList = sumService.list(ew);
		// 明细及非末级Map
		ControlPlanSumEntity sum = null;
		if(CollectionUtils.isEmpty(sumList)){
			sum = this.getSumVO(entity);// 构造主表VO
			// 子表
			List<ControlPlanSumDetailEntity> detailList = sum.getDetailList();
			if(CollectionUtils.isNotEmpty(detailList)){
				detailList.forEach(vo->{
					vo.setSourceId(String.valueOf(entity.getId()));
					vo.setSourceDetailId(String.valueOf(vo.getId()));
					vo.setBillType(entity.getBillType());
					vo.setSumNum(vo.getNum());
					vo.setId(null);
					vo.setCreateTime(null);
					vo.setCreateUserCode(null);
					vo.setUpdateTime(null);
					vo.setUpdateUserCode(null);
					vo.setVersion(null);
					vo.setRowState("add");
				});
			}
		} else {
			sum = sumService.selectById(sumList.get(0).getId());
			if(PlanConstant.BILL_TYPE_NEW.equals(entity.getBillType())){
				sum.setLastTime(entity.getCreateTime());// 最新汇总日期
			} else {
				sum.setChangeStatus(PlanConstant.CHANGE_OVER);// 已变更
				sum.setChangeVersion(sum.getChangeVersion() + 1);// 变更次数加一
			}
			List<ControlPlanSumDetailEntity> detailList = sum.getDetailList();
			// 新增
			List<ControlPlanSumDetailEntity> saveList = entity.getDetailList().stream().filter(x->PlanConstant.ROW_TYPE_NEW.equals(x.getRowType())).
					map(x->BeanMapper.map(x, ControlPlanSumDetailEntity.class)).collect(Collectors.toList());
			if(CollectionUtils.isNotEmpty(saveList)){
				saveList.forEach(vo->{
					vo.setSourceId(String.valueOf(entity.getId()));
					vo.setSourceDetailId(String.valueOf(vo.getId()));
					vo.setBillType(entity.getBillType());
					if(PlanConstant.BILL_TYPE_NEW.equals(entity.getBillType())){
						vo.setSumNum(vo.getNum());
					} else {
						vo.setSumNum(BigDecimal.ZERO);
					}
					vo.setId(null);
					vo.setCreateTime(null);
					vo.setCreateUserCode(null);
					vo.setUpdateTime(null);
					vo.setUpdateUserCode(null);
					vo.setVersion(null);
					vo.setRowState("add");
				});
			}
			// 变更
			Map<Long, ControlPlanDetailEntity> updateMap = entity.getDetailList().stream().filter(x->PlanConstant.ROW_TYPE_CHANGE.equals(x.getRowType())).
					collect(Collectors.toMap(ControlPlanDetailEntity::getMaterialId, x->x));
			detailList.forEach(vo->{
				if(updateMap.containsKey(vo.getMaterialId())){
					vo.setNum(updateMap.get(vo.getMaterialId()).getAfterNum());
					vo.setRowType(PlanConstant.ROW_TYPE_CHANGE);
				}else {
					vo.setRowType(PlanConstant.ROW_TYPE_UNCHANGE);
				}
			});
			detailList.addAll(saveList);
		}
		logger.info("--> 汇总后VO：" + JSONObject.toJSONString(sum));
		sum = sumService.saveOrUpdateEntity(sum);

		// TODO 暂时不考虑附件汇总
		// 编制/变更附件汇总
		String sourceBillType = PlanConstant.NEW_BILL_TYPE;
		if(PlanConstant.BILL_TYPE_CHANGE.equals(entity.getBillType())){
			sourceBillType = PlanConstant.CHANGE_BILL_TYPE;
		}
		attachmentApi.copyFilesFromSourceBillToTargetBill(
				String.valueOf(entity.getId()), sourceBillType, PlanConstant.UPLOAD_SOURCE_TYPE,
				String.valueOf(sum.getId()), PlanConstant.SUM_BILL_TYPE, PlanConstant.BILL_SOURCE_TYPE);

		attachmentApi.copyFilesFromSourceBillToTargetBill(
				String.valueOf(entity.getId()), sourceBillType, PlanConstant.BILL_SOURCE_TYPE,
				String.valueOf(sum.getId()), PlanConstant.SUM_BILL_TYPE, PlanConstant.BILL_SOURCE_TYPE);
		return sum;
	}

	/**
	 * 构造主表VO
	 * @param entity
	 * @return
	 */
	private ControlPlanSumEntity getSumVO(ControlPlanEntity entity) {
		ControlPlanSumEntity vo = BeanMapper.map(entity, ControlPlanSumEntity.class);
		vo.setId(null);
		vo.setCreateTime(null);
		vo.setCreateUserCode(null);
		vo.setUpdateTime(null);
		vo.setUpdateUserCode(null);
		vo.setVersion(null);
		vo.setFirstTime(entity.getCreateTime());
		vo.setLastTime(entity.getCreateTime());
		vo.setChangeStatus(PlanConstant.CHANGE_NO);
		vo.setChangeVersion(0);
		vo.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
		return vo;
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ControlPlanEntity entity = service.selectById(billId);
		if(PlanConstant.BILL_TYPE_NEW.equals(entity.getBillType())){
			// 计划编制校验
			this.validateNew(entity);
		} else {
			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, entity.getProjectId()));
			queryParam.getParams().put("billType", new Parameter(QueryParam.EQ, PlanConstant.BILL_TYPE_CHANGE));
			queryParam.getParams().put("id", new Parameter(QueryParam.NE, billId));
			List<ControlPlanEntity> dataList = service.queryList(queryParam);
			if(dataList.stream().anyMatch(x -> !"1,3".contains(String.valueOf(x.getBillState())))){
				throw new BusinessException("项目下存在未生效变更单，不允许弃审!");
			}
			Integer max = dataList.stream().map(ControlPlanEntity::getChangeVersion).max(Integer::compareTo).orElse(null);
			if(max != null && entity.getChangeVersion() <= max){
				throw new BusinessException("非最新变更单，不允许弃审!");
			}
		}
		// 校验是否被采购计划引用
		this.validatePurchase(entity);
		return CommonResponse.success();
	}

	/**
	 * 校验是否被采购计划引用
	 * @param entity
	 */
	private void validatePurchase(ControlPlanEntity entity) {
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, entity.getProjectId()));
		List<PurchasePlanEntity> purchaseList = purchaseService.queryList(queryParam);
		Map<Long, String> dataMap = purchaseList.stream().collect(Collectors.toMap(PurchasePlanEntity::getId, PurchasePlanEntity::getBillCode));
		if(CollectionUtils.isNotEmpty(purchaseList)){
			List<Long> planIds = purchaseList.stream().map(PurchasePlanEntity::getId).collect(Collectors.toList());
			List<ControlPlanDetailEntity> detailList = entity.getDetailList();
			List<Long> ids = detailList.stream().filter(x->PlanConstant.ROW_TYPE_NEW.equals(x.getRowType())).
					map(ControlPlanDetailEntity::getMaterialId).collect(Collectors.toList());
			if(CollectionUtils.isEmpty(ids)){
				return;
			}
			QueryParam param = new QueryParam();
			param.getParams().put("planId", new Parameter(QueryParam.IN, planIds));
			param.getParams().put("materialId", new Parameter(QueryParam.IN, ids));
			List<PurchasePlanDetailEntity> list = purchaseDetailService.queryList(param);
			if(CollectionUtils.isNotEmpty(list)){
				StringBuilder msg = new StringBuilder();
				msg.append("采购计划");
				for(PurchasePlanDetailEntity detail : list){
					msg.append("【" + dataMap.get(detail.getPlanId()) + "】-【" + detail.getMaterialName() + "】，" );
				}
				msg.append("已引用，不允许弃审！");
				throw new BusinessException(msg.toString());
			}
		}
	}

	/**
	 * 计划编制校验
	 * @param entity
	 */
	private void validateNew(ControlPlanEntity entity) {
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, entity.getProjectId()));
		queryParam.getParams().put("billType", new Parameter(QueryParam.EQ, PlanConstant.BILL_TYPE_CHANGE));
		List<ControlPlanEntity> dataList = service.queryList(queryParam);
		Map<Long, String> dataMap = dataList.stream().collect(Collectors.toMap(ControlPlanEntity::getId, ControlPlanEntity::getBillCode));
		if(CollectionUtils.isNotEmpty(dataList)){
			List<Long> planIds = dataList.stream().map(ControlPlanEntity::getId).collect(Collectors.toList());
			List<ControlPlanDetailEntity> detailList = entity.getDetailList();
			List<Long> ids = detailList.stream().map(ControlPlanDetailEntity::getMaterialId).collect(Collectors.toList());
			QueryParam param = new QueryParam();
			param.getParams().put("planId", new Parameter(QueryParam.IN, planIds));
			param.getParams().put("materialId", new Parameter(QueryParam.IN, ids));
			List<ControlPlanDetailEntity> list = detailService.queryList(param);
			if(CollectionUtils.isNotEmpty(list)){
				StringBuilder msg = new StringBuilder();
				msg.append("变更单");
				for(ControlPlanDetailEntity detail : list){
					msg.append("【" + dataMap.get(detail.getPlanId()) + "】-【" + detail.getMaterialName() + "】，" );
				}
				msg.append("已发生数据，不允许弃审！");
				throw new BusinessException(msg.toString());
			}
		}
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @returnrjuq
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ControlPlanEntity entity = service.selectById(billId);
		// 撤回汇总单数据
		this.withdrawSum(entity);
		// 删除物料库
		List<ControlPlanDetailEntity> detailList = entity.getDetailList();
		List<Long> sourceIds = detailList.stream().filter(x->PlanConstant.ROW_TYPE_NEW.equals(x.getRowType())).
				map(ControlPlanDetailEntity::getId).collect(Collectors.toList());
		if(CollectionUtils.isNotEmpty(sourceIds)) {
			materialService.deleteMaterialsFromBill(sourceIds);
		}
		return CommonResponse.success();
	}

	/**
	 * 从汇总单撤回
	 * @param entity
	 * @return
	 */
	private ControlPlanSumEntity withdrawSum(ControlPlanEntity entity) {
		logger.info("--> 单据：" + entity.getId() + "取消汇总开始");
		QueryParam param = new QueryParam();
		param.getParams().put("projectId", new Parameter(QueryParam.EQ, entity.getProjectId()));
		List<ControlPlanSumEntity> sumList = sumService.queryList(param);
		ControlPlanSumEntity sum = sumService.selectById(sumList.get(0).getId());
		if(PlanConstant.BILL_TYPE_NEW.equals(entity.getBillType())){
			param.getParams().put("id", new Parameter(QueryParam.NE, entity.getId()));
			param.getOrderMap().put("createTime", QueryParam.DESC);
			List<ControlPlanEntity> newList = service.queryList(param);
			if(CollectionUtils.isNotEmpty(newList)){
				sum.setLastTime(newList.get(0).getCreateTime());// 最新汇总日期
			}
		} else {
			sum.setChangeStatus(PlanConstant.CHANGE_ING);// 变更中
			sum.setChangeVersion(sum.getChangeVersion() - 1);// 变更次数减一
		}

		List<ControlPlanSumDetailEntity> detailList = sum.getDetailList();
		// 新增
		Map<Long, ControlPlanDetailEntity> saveMap = entity.getDetailList().stream().filter(x->PlanConstant.ROW_TYPE_NEW.equals(x.getRowType())).
				collect(Collectors.toMap(ControlPlanDetailEntity::getMaterialId, x->x));
		// 变更
		Map<Long, ControlPlanDetailEntity> updateMap = entity.getDetailList().stream().filter(x->PlanConstant.ROW_TYPE_CHANGE.equals(x.getRowType())).
				collect(Collectors.toMap(ControlPlanDetailEntity::getMaterialId, x->x));
		detailList.forEach(vo->{
			if(saveMap.containsKey(vo.getMaterialId())){
				vo.setRowState("del");
			}
			if(updateMap.containsKey(vo.getMaterialId())){
				vo.setNum(updateMap.get(vo.getMaterialId()).getBeforeNum());
				vo.setRowState("edit");
			}
		});
		Integer row = (int) detailList.stream().filter(x->!"del".equals(x.getRowState())).count();
		// 子级不为空则修改，否则删除
		if(row > 0){
			logger.info("--> 汇总后VO：" + JSONObject.toJSONString(sum));
			sumService.saveOrUpdate(sum, false);
		} else {
			logger.info("--> 汇总单VO：" + sum.getId() + "已删除");
			sumService.removeById(sum.getId(), true);
		}
		// TODO 暂时不考虑附件汇总
		// 删除编制/变更已汇总的附件
		String sourceBillType = PlanConstant.NEW_BILL_TYPE;
		if(PlanConstant.BILL_TYPE_CHANGE.equals(entity.getBillType())){
			sourceBillType = PlanConstant.CHANGE_BILL_TYPE;
		}
		List<AttachmentVO> fileList = this.queryListBySourceId(entity.getId(), sourceBillType, PlanConstant.UPLOAD_SOURCE_TYPE);
		List<AttachmentVO> sumFileList = this.queryListBySourceId(sum.getId(), PlanConstant.SUM_BILL_TYPE, PlanConstant.BILL_SOURCE_TYPE);
		List<AttachmentVO> fileList2 = this.queryListBySourceId(entity.getId(), sourceBillType, PlanConstant.BILL_SOURCE_TYPE);
//		List<AttachmentVO> sumFileList2 = this.queryListBySourceId(sum.getId(), PlanConstant.SUM_BILL_TYPE, PlanConstant.BILL_SOURCE_TYPE);
		fileList.addAll(fileList2);
//		sumFileList.addAll(sumFileList2);
		if(CollectionUtils.isNotEmpty(fileList) && CollectionUtils.isNotEmpty(sumFileList)){
			Map<String, AttachmentVO> fileMap = fileList.stream().collect(Collectors.toMap(AttachmentVO::getFilePath, Function.identity()));
			List<String> ids = new ArrayList<>();
			for(AttachmentVO vo : sumFileList){
				if(fileMap.containsKey(vo.getFilePath())){
					ids.add(String.valueOf(vo.getId()));
				}
			}
			if(CollectionUtils.isNotEmpty(ids)){
				attachmentApi.delete(String.join(",", ids));
			}
		}
		return sum;
	}

	/**
	 * 查询附件信息
	 * @param sourceId
	 * @param billType
	 * @param sourceType
	 * @return
	 */
	private List<AttachmentVO> queryListBySourceId(Long sourceId, String billType, String sourceType){
	/*
	 * 从ERP获取成本控制人员信息
	*/
		CommonResponse<List<AttachmentVO>> response = attachmentApi.queryListBySourceId(sourceId, billType, sourceType, null);
		if(!response.isSuccess()){
			logger.error("获取文件信息异常，", response.getMsg());
			return new ArrayList<>();
		}
		return response.getData();
	}
	/*
	 * 获取成本控制人员信息,更新实体表里的字段chenbo.zhao
	*/
	private void getCostcontrolInfor(Long sourceId){
		// 1. 获取ControlPlanEntity实体
		logger.info("--> 启动流程调用回调资源ID：" + sourceId.toString());
		ControlPlanEntity entity = service.selectById(sourceId);
		if (entity == null) {
			logger.error("未找到ID为" + sourceId + "的总控计划");
			return;
		}
		// 2. 获取项目编码
		String projectCode = entity.getProjectCode();
		logger.info("--> 获取项目编码：" + projectCode);
		if (StringUtils.isBlank(projectCode)) {
			logger.error("总控制计划[ID:" + sourceId + "]缺少项目编码");
			return;
		}
		//3、查询子表里的二级材料分类
		QueryParam paramPlan = new QueryParam();
		paramPlan.getParams().put("planId", new Parameter(QueryParam.EQ, sourceId));
		List<ControlPlanDetailEntity> detailList = detailService.queryList(paramPlan);
		// 获取二级材料分类ID列表(parent_material_type_id字段)
		Long secondLevelCategoryId = null;
		if (CollectionUtils.isNotEmpty(detailList)) {
			ControlPlanDetailEntity firstDetail = detailList.get(0);
			secondLevelCategoryId = firstDetail.getMaterialTypeId(); // 获取第一条记录的二级分类ID
		}
		logger.info("--> 获取二级分类ID：" + secondLevelCategoryId);
		//获取一级材料分类信息
		QueryParam paramCategories = new QueryParam();
		String goodSid=null;
		if(secondLevelCategoryId!=null){
			paramCategories.getParams().put("parent_id", new Parameter(QueryParam.EQ, secondLevelCategoryId));
			List<MaterialCategoryEntity> categories = categoryService.queryList(paramCategories);
			if (CollectionUtils.isNotEmpty(categories)) {
				goodSid= categories.get(0).getSourceId(); // 返回第一条记录
			}
		}
		if(goodSid==null){
			logger.error("获取一级分类失败[二级分类ID:" + secondLevelCategoryId + "]，项目编码为"+projectCode);
			return;
		}
		logger.info("--> 获取一级分类SID：" + goodSid);
		Map<String, Integer> param = new HashMap<>();
        String reqUrl = ERP_SSO_HOST + ERP_INQUIRY_COSTCONTROL_URL;
		try {
			reqUrl=reqUrl+"?projectID="+projectCode+"&goodSid="+goodSid;
			logger.info("--> 请求中电四接口：" + reqUrl);
			Map<String, String> headers = ZDSInterfaceCommonUtil.getErpHeaders();
			String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers,
					ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);
			JSONObject reqJson = JSONObject.parseObject(reqResp);
			logger.info("--> 响应结果：" + reqResp);
			if ("ok".equals(reqJson.getString("status"))) {
				logger.info("请求中电四接口成功：请求地址-{},参数-{},header-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers));
				String userISD=reqJson.getString("userISD");
				if (StringUtils.isBlank(userISD)) {
					logger.error("获取成本管控人员SID失败[项目ID:" + projectCode + "]");
					return;
				}
				CommonResponse<EmployeeVO> empResp = employeeApi.getOneBySourceId(userISD);
				if (!empResp.isSuccess()) {
					logger.error("通过SID匹配EL平台账号信息失败：{}", JSONObject.toJSONString(empResp));
					return;
				}
				Long userID=empResp.getData().getUserId();
				String userName=empResp.getData().getUserName();
				//通过工号匹配EL平台账号信息，然后更新EL平台成本管控人员
				entity.setCostcontrolId(userID); 
				entity.setControlName(userName);
				service.updateById(entity);
			} else {
				logger.error("请求中电四接口失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
			}
		} catch (Exception e) {
			logger.error("请求中电四接口异常, 请求地址：{}, 请求参数：{}", reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat), e);
		}
	}
}
