package com.ejianc.business.zdsmaterial.plan.purchase.bean;

import java.math.*;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 采购计划详情
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_purchase_plan_detail")
public class PurchasePlanDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="plan_id")
    private Long planId; // 计划id
    @TableField(value="source_type")
    private Integer sourceType; // 来源： 0：参照总控计划清单； 1：参照常用材料库  2：新增  该为总计划
    @TableField(value="excess_detail_flag")
    private Integer excessDetailFlag; // 是否超量明细 1：是； 0：否
    @TableField(value="work_plan_flag")
    private Integer workPlanFlag; // 是否有对应总工计划 1：是； 0：否
    @TableField(value="part")
    private String part; // 部位
    @TableField(value="source_id")
    private Long sourceId; // 来源单据主键
    @TableField(value="source_detail_id")
    private Long sourceDetailId; // 来源明细主键
    @TableField(value="material_type_name")
    private String materialTypeName; // 物资分类名称
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物资分类id
    @TableField(value="material_type_sid")
    private String materialTypeSid; // 物资分类来源id
    @TableField(value="material_code")
    private String materialCode; // 物资编码
    @TableField(value="material_name")
    private String materialName; // 物资编码
    @TableField(value="material_id")
    private Long materialId; // 物资id
    @TableField(value="property_value")
    private String propertyValue; // 属性值
    @TableField(value="unit_name")
    private String unitName; // 计量单位
    @TableField(value="unit_id")
    private Long unitId; // 计量单位
    @TableField(value="num")
    private BigDecimal num; // 总控量
    @TableField(value="residue_num")
    private BigDecimal residueNum; // 总控量剩余量
    @TableField(value="requirement_num")
    private BigDecimal requirementNum; // 需求量
    @TableField(value="local_assignable_num")
    private BigDecimal localAssignableNum; // 可调拨物资量(本大区)
    @TableField(value="other_assignable_num")
    private BigDecimal otherAssignableNum; // 可调拨物资量(其他大区)
    @TableField(value="excess_cause")
    private String excessCause; // 超量原因
    @TableField(value="cost_coding_name")
    private String costCodingName; // 费用包
    @TableField(value="cost_coding_code")
    private String costCodingCode; // 费用包编码
    @TableField(value="cost_coding_id")
    private String costCodingId; // 费用包id
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="exceed_num")
    private BigDecimal exceedNum; // 超量数量
    @TableField(value="excess_residue_detail_flag")
    private Integer excessResidueDetailFlag; // 是否超剩余总量明细 1：是； 0：否
    @TableField(value="property_show_name")
    private String propertyShowName; // 属性列表展示名称
    @TableField(value="has_new_property_val")
    private Integer hasNewPropertyVal; // 是否新增属性值：0-否，1-是
    @TableField(value = "total_requirement_num")
    private BigDecimal totalRequirementNum; // 累计需求量
    @TableField(value = "product_code")
    private String productCode; // 产品代码
    @TableField(value="material_serial_no")
    private String materialSerialNo; // 物资流水号
    @TableField(value="material_type_code")
    private String materialTypeCode; // 物资分类编码
    @TableField(value="brand_id")
    private Long brandId; //品牌主键
    @TableField(value="brand_name")
    private String brandName; // 品牌名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value = "plan_in_date")
    private Date planInDate;//计划到场日期

    @TableField(value="property")
    private String property; // 属性
    @TableField(value="detail_index")
    private Integer detailIndex; // 序号
    @TableField(exist = false)
    private String systemClassifyName;
    @TableField(exist = false)
    private String inventoryClassifyCode;

    @TableField(value = "detail_additive")
    private String detailAdditive;//添加剂
    @TableField(value = "detail_delivery_mode")
    private String detailDeliveryMode;//输送方式

    @TableField(value = "material_type_p_id")
    private Long materialTypePId; //物资分类上级分类Id
    @TableField(value = "material_type_p_name")
    private String materialTypePName;//物资分类上级分类名称
    @TableField(value = "material_type_p_code")
    private String materialTypePCode;//物资分类上级分类编码
    /**
     * 切包改造====
     */
    @TableField(value = "material_pack_id")
    private Long materialPackId; // 切包情况-材料包id，二级物料类别
    @TableField(value = "material_pack_code")
    private String materialPackCode; // 切包情况-材料包编码
    @TableField(value = "material_pack_name")
    private String materialPackName; // 切包情况-材料包名称
    @TableField(value = "item_code")
    private String itemCode; // 清单编码
    @TableField(value = "item_name")
    private String itemName; // 清单名称
    @TableField(value = "budget_type")
    private String budgetType; // 1:切包请单内2：切包清单外
    @TableField(value = "budget_detail_id")
    private Long budgetDetailId; // 清单子表ID


    public Long getMaterialPackId() {
        return materialPackId;
    }

    public void setMaterialPackId(Long materialPackId) {
        this.materialPackId = materialPackId;
    }

    public String getMaterialPackCode() {
        return materialPackCode;
    }

    public void setMaterialPackCode(String materialPackCode) {
        this.materialPackCode = materialPackCode;
    }

    public String getMaterialPackName() {
        return materialPackName;
    }

    public void setMaterialPackName(String materialPackName) {
        this.materialPackName = materialPackName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getBudgetType() {
        return budgetType;
    }

    public void setBudgetType(String budgetType) {
        this.budgetType = budgetType;
    }

    public Long getBudgetDetailId() {
        return budgetDetailId;
    }

    public void setBudgetDetailId(Long budgetDetailId) {
        this.budgetDetailId = budgetDetailId;
    }

    /**
     * 切包改造end=====
     */

    public String getDetailAdditive() {
        return detailAdditive;
    }

    public void setDetailAdditive(String detailAdditive) {
        this.detailAdditive = detailAdditive;
    }

    public String getDetailDeliveryMode() {
        return detailDeliveryMode;
    }

    public void setDetailDeliveryMode(String detailDeliveryMode) {
        this.detailDeliveryMode = detailDeliveryMode;
    }

    public Long getMaterialTypePId() {
        return materialTypePId;
    }

    public void setMaterialTypePId(Long materialTypePId) {
        this.materialTypePId = materialTypePId;
    }

    public String getMaterialTypePName() {
        return materialTypePName;
    }

    public void setMaterialTypePName(String materialTypePName) {
        this.materialTypePName = materialTypePName;
    }

    public String getMaterialTypePCode() {
        return materialTypePCode;
    }

    public void setMaterialTypePCode(String materialTypePCode) {
        this.materialTypePCode = materialTypePCode;
    }

    public String getInventoryClassifyCode() {
        return inventoryClassifyCode;
    }

    public void setInventoryClassifyCode(String inventoryClassifyCode) {
        this.inventoryClassifyCode = inventoryClassifyCode;
    }

    public String getSystemClassifyName() {
        return systemClassifyName;
    }

    public void setSystemClassifyName(String systemClassifyName) {
        this.systemClassifyName = systemClassifyName;
    }

    public Integer getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(Integer detailIndex) {
        this.detailIndex = detailIndex;
    }

    public String getMaterialTypeSid() {
        return materialTypeSid;
    }

    public void setMaterialTypeSid(String materialTypeSid) {
        this.materialTypeSid = materialTypeSid;
    }

    public String getProperty() {
        return property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public Date getPlanInDate() {
        return planInDate;
    }

    public void setPlanInDate(Date planInDate) {
        this.planInDate = planInDate;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }
    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public String getMaterialSerialNo() {
        return materialSerialNo;
    }

    public void setMaterialSerialNo(String materialSerialNo) {
        this.materialSerialNo = materialSerialNo;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }
    public BigDecimal getTotalRequirementNum() {
        return totalRequirementNum;
    }

    public void setTotalRequirementNum(BigDecimal totalRequirementNum) {
        this.totalRequirementNum = totalRequirementNum;
    }

    public Integer getHasNewPropertyVal() {
        return hasNewPropertyVal;
    }

    public void setHasNewPropertyVal(Integer hasNewPropertyVal) {
        this.hasNewPropertyVal = hasNewPropertyVal;
    }

    public String getPropertyShowName() {
        return propertyShowName;
    }

    public void setPropertyShowName(String propertyShowName) {
        this.propertyShowName = propertyShowName;
    }

    public Integer getExcessResidueDetailFlag() {
        return excessResidueDetailFlag;
    }

    public void setExcessResidueDetailFlag(Integer excessResidueDetailFlag) {
        this.excessResidueDetailFlag = excessResidueDetailFlag;
    }

    public BigDecimal getExceedNum() {
        return exceedNum;
    }

    public void setExceedNum(BigDecimal exceedNum) {
        this.exceedNum = exceedNum;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    public Integer getExcessDetailFlag() {
        return excessDetailFlag;
    }

    public void setExcessDetailFlag(Integer excessDetailFlag) {
        this.excessDetailFlag = excessDetailFlag;
    }
    public Integer getWorkPlanFlag() {
        return workPlanFlag;
    }

    public void setWorkPlanFlag(Integer workPlanFlag) {
        this.workPlanFlag = workPlanFlag;
    }
    public String getPart() {
        return part;
    }

    public void setPart(String part) {
        this.part = part;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getPropertyValue() {
        return propertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getResidueNum() {
        return residueNum;
    }

    public void setResidueNum(BigDecimal residueNum) {
        this.residueNum = residueNum;
    }
    public BigDecimal getRequirementNum() {
        return requirementNum;
    }

    public void setRequirementNum(BigDecimal requirementNum) {
        this.requirementNum = requirementNum;
    }
    public BigDecimal getLocalAssignableNum() {
        return localAssignableNum;
    }

    public void setLocalAssignableNum(BigDecimal localAssignableNum) {
        this.localAssignableNum = localAssignableNum;
    }
    public BigDecimal getOtherAssignableNum() {
        return otherAssignableNum;
    }

    public void setOtherAssignableNum(BigDecimal otherAssignableNum) {
        this.otherAssignableNum = otherAssignableNum;
    }
    public String getExcessCause() {
        return excessCause;
    }

    public void setExcessCause(String excessCause) {
        this.excessCause = excessCause;
    }
    public String getCostCodingName() {
        return costCodingName;
    }

    public void setCostCodingName(String costCodingName) {
        this.costCodingName = costCodingName;
    }
    public String getCostCodingCode() {
        return costCodingCode;
    }

    public void setCostCodingCode(String costCodingCode) {
        this.costCodingCode = costCodingCode;
    }
    public String getCostCodingId() {
        return costCodingId;
    }

    public void setCostCodingId(String costCodingId) {
        this.costCodingId = costCodingId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
