package com.ejianc.business.zdsmaterial.plan.purchase.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanDetailVO;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanVO;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.SupPurchasePlanVo;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 采购计划
 * 
 * @author generator
 * 
 */
public interface IPurchasePlanService extends IBaseService<PurchasePlanEntity> {

    PurchasePlanVO saveOrUpdate(PurchasePlanVO saveOrUpdateVO);

    PurchasePlanEntity setSid(PurchasePlanEntity purchasePlanEntity);
    CommonResponse<PurchasePlanVO> queryDetail(Long id);
    /**
     *
     * @param planVo
     * @return
     */
    ParamsCheckVO checkParams(PurchasePlanVO planVo);

    /**
     * 查询是否存在总计划单据
     */
    Map<Long, PurchasePlanDetailVO> queryMaterialListSum(List<Long> materialIds,Long projectId);
    Map<String, BigDecimal> queryAllotOrgSum(List<String> materialCodes, Long projectId);
    BigDecimal queryAllotOtherSum(String materialCode, Long brandId, Long projectId);

    void checkMaterialSumPlan(List<Long> materialIds ,Long projectId);

    /**
     * 采购计划推送计划量
     * @param plan
     */
     void planToSum(PurchasePlanEntity plan,boolean addFlag);

    IPage<SupPurchasePlanVo> supQueryList(Map<String, Object> params);


    void validatePlanNum(PurchasePlanEntity entity);

    Map<String, BigDecimal> queryAllotSum(List<String> materialCodes, Long projectId);
}
