package com.ejianc.business.zdsmaterial.pricelib.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.constants.ConjectureConstants;
import com.ejianc.business.zdsmaterial.plan.conjecture.handler.ConjectureManageFactory;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.pricelib.bean.MaterialPriceCalcEntity;
import com.ejianc.business.zdsmaterial.pricelib.bean.MaterialPriceCalcFormulaEntity;
import com.ejianc.business.zdsmaterial.pricelib.bean.MaterialPriceCalcSubConditionEntity;
import com.ejianc.business.zdsmaterial.pricelib.bean.MaterialPriceSubConditionDetailEntity;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcFormulaService;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcService;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcSubConditionService;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceSubConditionDetailService;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcSubConditionVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceSubConditionDetailVO;
import com.ejianc.business.zdssupplier.material.api.IMatSupplierApi;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.foundation.share.api.IUnitApi;
import com.ejianc.foundation.share.vo.UnitShareVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.*;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 价格公式设置子表-公式条件
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("materialPriceCalcSubCondition")
public class MaterialPriceCalcSubConditionController  {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMaterialPriceCalcSubConditionService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMaterialPriceCalcService calcService;

    @Autowired
    private IMaterialConjectureService materialConjectureService;

    @Autowired
    private IMaterialPriceSubConditionDetailService conditionDetailService;

    @Autowired
    private ConjectureManageFactory factory;

    @Value("${material.ai.handlerName:CJYT}")
    private String handlerName;

    @Autowired
    private IUnitApi unitApi;

    @Autowired
    private IBrandService brandService;

    @Autowired
    private IMatSupplierApi matSupplierApi;

    @Autowired
    private IMaterialPriceCalcFormulaService formulaService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialPriceCalcSubConditionVO> saveOrUpdate(@RequestBody MaterialPriceCalcSubConditionVO saveOrUpdateVO) {
        MaterialPriceCalcSubConditionEntity entity = null;
        MaterialPriceCalcFormulaEntity formula = null;

        if(null == saveOrUpdateVO.getId() || null == saveOrUpdateVO.getPid()) {
            MaterialPriceCalcVO calcVO = calcService.getOneByCategoryId(saveOrUpdateVO.getCategoryId());
            saveOrUpdateVO.setPid(calcVO.getId());

            List<MaterialPriceCalcSubConditionVO> conditions =
                    service.getAllByPids(Collections.singletonList(calcVO.getId()),null, false);

            if(null == saveOrUpdateVO.getId()) {
                entity = BeanMapper.map(saveOrUpdateVO, MaterialPriceCalcSubConditionEntity.class);

                //序号重新生成
                MaterialPriceCalcSubConditionVO max = null;
                if(CollectionUtils.isNotEmpty(conditions)) {
                    max = conditions.stream().max(Comparator.comparingInt(MaterialPriceCalcSubConditionVO::getSequence)).get();
                }
                entity.setSequence(null != max ? max.getSequence()+1 : 0);
            } else {
                entity = service.selectById(saveOrUpdateVO.getId());

                entity.setCalcId(saveOrUpdateVO.getCalcId());
                entity.setCalcParams(saveOrUpdateVO.getCalcParams());
                if(StringUtils.isNotBlank(saveOrUpdateVO.getCalcDisplayContent())) {
                    entity.setCalcDisplayContent(saveOrUpdateVO.getCalcDisplayContent());
                }
                if(CollectionUtils.isNotEmpty(saveOrUpdateVO.getDetailList())) {
                    entity.setDetailList(BeanMapper.mapList(saveOrUpdateVO.getDetailList(), MaterialPriceSubConditionDetailEntity.class));
                }
                if(StringUtils.isNotBlank(saveOrUpdateVO.getCalcCode())) {
                    entity.setCalcCode(saveOrUpdateVO.getCalcCode());
                }

                //排序号不能重
                Set<MaterialPriceCalcSubConditionVO> repeatList = conditions.stream().filter(item -> !item.getId().equals(saveOrUpdateVO.getId()) && item.getSequence() == saveOrUpdateVO.getSequence()).collect(Collectors.toSet());
                if(CollectionUtils.isNotEmpty(repeatList)) {
                    return CommonResponse.error("操作失败，已存在排序为："+saveOrUpdateVO.getSequence()+"的条件，请调整后再保存！");
                }
            }
        }

        //替换公式参数
        if(null != entity.getCalcId() && StringUtils.isNotBlank(entity.getCalcParams())) {
            formula = formulaService.getById(entity.getCalcId());
            Map<String, String> calcParams = JSONObject.parseObject(entity.getCalcParams(), Map.class);
            String calcContent = formula.getCalcDisplayContent();
            for(String key : calcParams.keySet()) {
                if(calcContent.contains(key)) {
                    calcContent = calcContent.replaceAll(key, calcParams.get(key));
                }
            }
            entity.setCalcDisplayContent(calcContent);
        }

    	service.saveOrUpdate(entity, false);
    	MaterialPriceCalcSubConditionVO vo = BeanMapper.map(entity, MaterialPriceCalcSubConditionVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description update
     * @param saveOrUpdateVO
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialPriceCalcSubConditionVO> update(@RequestBody MaterialPriceCalcSubConditionVO saveOrUpdateVO) {
        MaterialPriceCalcSubConditionEntity entity = service.selectById(saveOrUpdateVO.getId());
        if(null != saveOrUpdateVO.getSequence()) {
            entity.setSequence(saveOrUpdateVO.getSequence());
        }
        if(null != saveOrUpdateVO.getEnabled()) {
            entity.setEnabled(saveOrUpdateVO.getEnabled());
        }
        service.saveOrUpdate(entity, false);
        MaterialPriceCalcSubConditionVO vo = BeanMapper.map(entity, MaterialPriceCalcSubConditionVO.class);
        return CommonResponse.success("操作成功！！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialPriceCalcSubConditionVO> queryDetail(Long id) {
    	MaterialPriceCalcSubConditionEntity entity = service.selectById(id);
    	MaterialPriceCalcSubConditionVO vo = BeanMapper.map(entity, MaterialPriceCalcSubConditionVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialPriceCalcSubConditionVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MaterialPriceCalcSubConditionVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MaterialPriceCalcSubConditionVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialPriceCalcSubConditionVO>> queryList(@RequestBody QueryParam param) {

        IPage<MaterialPriceCalcSubConditionVO> resp = new Page<>();
        resp.setCurrent(param.getPageIndex());
        resp.setSize(param.getPageSize());
        param.getOrderMap().put("sequence", "asc");

        if(param.getParams().containsKey("categoryId") || param.getParams().containsKey("materialType")) {
            //查询对应主表id
            QueryWrapper<MaterialPriceCalcEntity> query =new QueryWrapper<>();
            if(param.getParams().containsKey("categoryId")) {
                query.eq("category_id", Long.valueOf(param.getParams().get("categoryId").getValue().toString()));
                param.getParams().remove("categoryId");
            }
            if(param.getParams().containsKey("materialType")) {
                query.eq("material_type", param.getParams().get("materialType").getValue().toString());
                param.getParams().remove("materialType");
            }
            List<MaterialPriceCalcEntity> calcList = calcService.list(query);
            if(CollectionUtils.isEmpty(calcList)) {
                resp.setTotal(0L);
                resp.setRecords(new ArrayList<>());
                return CommonResponse.success(resp);
            }

            param.getParams().put("pid", Parameter.getInInstance(calcList.stream().map(MaterialPriceCalcEntity::getId).collect(Collectors.toList())));
        }

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<MaterialPriceCalcSubConditionEntity> page = service.queryPage(param,false);
        IPage<MaterialPriceCalcSubConditionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<MaterialPriceCalcSubConditionVO> records = BeanMapper.mapList(page.getRecords(), MaterialPriceCalcSubConditionVO.class);

        if(CollectionUtils.isNotEmpty(records)) {
           Map<Long, List<MaterialPriceSubConditionDetailVO>> detailMap = conditionDetailService.getAllByConditionIds(records.stream().map(MaterialPriceCalcSubConditionVO::getId).collect(Collectors.toList()));
           for(MaterialPriceCalcSubConditionVO m :records) {
               if(detailMap.containsKey(m.getId())) {
                   m.setDetailList(detailMap.get(m.getId()));
               }
           }
        }
        pageData.setRecords(records);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        List<MaterialPriceCalcSubConditionEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialPriceCalcSubCondition-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMaterialPriceCalcSubConditionData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialPriceCalcSubConditionVO>> refMaterialPriceCalcSubConditionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaterialPriceCalcSubConditionEntity> page = service.queryPage(param,false);
        IPage<MaterialPriceCalcSubConditionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialPriceCalcSubConditionVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "materialPriceCalc-import.xlsx", "价格查询导入模板");
    }

    @PostMapping(value = "/saveImport")
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<MaterialConjectureVO> saveList, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        //保存入库
        materialConjectureService.saveOrUpdateBatch(BeanMapper.mapList(saveList, MaterialConjectureEntity.class), saveList.size(), false);

        //启动异步识别
        materialConjectureService.startConjecture(saveList.get(0).getIdentificationId(), authority, saveList.get(0).getMode());

        return CommonResponse.success("操作成功,物料识别中！");
    }


    @PostMapping(value = "/excelImport")
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request ) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        String conjectureId = request.getParameter("identificationId"); //导入序列
        String mode = request.getParameter("mode"); //识别渠道
        if(StringUtils.isBlank(mode)) { //默认长江云通
            mode = ConjectureConstants.CONJECTURE_TYPE_CJTY;
        }
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }

        List<MaterialConjectureVO> successList = new ArrayList<>();
        List<MaterialConjectureVO> processList = new ArrayList<>();
        List<MaterialConjectureVO> errorList = new ArrayList<>();
        Set<String> unitNames = new HashSet<>();
        Set<String> brandNames = new HashSet<>();
        Set<String> matSupplierNames = new HashSet<>();

        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            if(result.size() > 10000) {
                return CommonResponse.error("数据超过10000条，请分批上传！");
            }
            MaterialConjectureVO vo = null;

            for(int i = 0;i < result.size(); i++) {
                List<String> datas = result.get(i);
                vo = new MaterialConjectureVO();
                vo.setMode(mode);
                vo.setIdentificationId(conjectureId);
                vo.setMateType("4"); //默认待识别
                vo.setConjectureMateType("4"); //默认待识别
                vo.setDelFlag("0");//未作废
                vo.setIgnoreFlag("0");//未忽略
                vo.setLoadState("0");//未加载
                vo.setIdentificationDate(new Date());
                vo.setId(IdWorker.getId());

                vo.setImportSeq(datas.get(0)); //序号
                vo.setSourceMaterialName(datas.get(1)); //物料名称
                vo.setSourceMaterialSpec(datas.get(2)); //特征描述
                vo.setSourceUnitName(datas.get(3)); //单位
                try {
                    vo.setSourceNum(ComputeUtil.toBigDecimal(datas.get(4)));//数量
                } catch (Exception e) {
                    vo.setErrorMsg("【数量】需填写数值！");
                    errorList.add(vo);
                    continue;
                }

                vo.setBrandName(datas.get(5));//品牌名称
                vo.setSupplierName(datas.get(6));//供应商名称
                if(datas.size() >= 8) {
                    vo.setExtParam1(datas.get(7));//扩展字段1
                }
                if(datas.size() >= 9) {
                    vo.setExtParam2(datas.get(8));//扩展字段2
                }
                if(StringUtils.isBlank(datas.get(1))){
                    vo.setErrorMsg("【物料名称】不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(2))){
                    vo.setErrorMsg("【特征描述】不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(3))){
                    vo.setErrorMsg("【单位】不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(vo.getBrandName())){
                    vo.setErrorMsg("【品牌】不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isNotBlank(vo.getSupplierName())){
                    matSupplierNames.add(vo.getSupplierName());
                }
                unitNames.add(vo.getSourceUnitName());
                brandNames.add(vo.getBrandName());


                vo.setRowState("add");
                processList.add(vo);
            }
        }

        if(CollectionUtils.isNotEmpty(processList)) {
            CommonResponse<List<UnitShareVO>> unitListResp = unitApi.findAllEnabledList(new ArrayList<>(unitNames));
            if(!unitListResp.isSuccess()) {
                logger.error("物料ai导入识别失败，获取单据信息失败,names:{}, 结果：{}", JSONObject.toJSONString(unitNames), JSONObject.toJSONString(unitListResp));
                return CommonResponse.error("操作失败，匹配计量单位信息失败！");
            }
            if(CollectionUtils.isEmpty(unitListResp.getData())) {
                logger.error("物料ai导入识别失败，获取单据信息为空, names:{}", JSONObject.toJSONString(unitNames));
                return CommonResponse.error("操作失败，匹配计量单位信息失败！");
            }

            //根据名称查询品牌信息
            Map<String,BrandEntity> brandMap = brandService.getAllByNames(new ArrayList<>(brandNames));

            Map<String, MatSupplierVO> supplierMap = new HashMap<>();

            if(CollectionUtils.isNotEmpty(matSupplierNames)) {
                //根据名称 查询供应商信息
                CommonResponse<List<MatSupplierVO>> matSupResp = matSupplierApi.getAllByNames(new ArrayList<>(matSupplierNames));
                if(!matSupResp.isSuccess()) {
                    logger.error("操作失败，根据名称names-{}查询供应商信息失败,{}", JSONObject.toJSONString(matSupplierNames), JSONObject.toJSONString(matSupResp));
                    return CommonResponse.error("操作失败，根据名称查询供应商信息失败！");
                }

                if(CollectionUtils.isNotEmpty(matSupResp.getData())) {
                    supplierMap.putAll(matSupResp.getData().stream().collect(Collectors.toMap(item -> item.getName(), item -> item, (v1,v2) -> v1)));
                }
            }


            Map<String, Long> unitNameIdMap = new HashMap<>();
            Map<String, Long> unitAliasNameIdMap = new HashMap<>();
            unitNameIdMap.putAll(unitListResp.getData().stream().collect(Collectors.toMap(UnitShareVO::getUnitName, UnitShareVO::getId, (k1,k2) -> k1)));
            unitAliasNameIdMap.putAll(unitListResp.getData().stream().filter(item -> StringUtils.isNotBlank(item.getAliasName())).collect(Collectors.toMap(item -> item.getAliasName(), UnitShareVO::getId, (k1,k2) -> k1)));

            for(MaterialConjectureVO m : processList) {
                m.setActualUnitName(m.getSourceUnitName());

                if(unitNameIdMap.containsKey(m.getSourceUnitName())) {
                    m.setActualUnitId(unitNameIdMap.get(m.getSourceUnitName()));
                }
                for(String key : unitAliasNameIdMap.keySet()) {
                    if(key.contains(","+m.getSourceUnitName()+",")) {
                        m.setActualUnitId(unitAliasNameIdMap.get(key));
                    }
                }

                if(null == m.getActualUnitId()) {
                    m.setErrorMsg("计量单位【"+m.getActualUnitName()+"】在系统中不存在！");
                    errorList.add(m);
                    continue;
                }

                if(brandMap.containsKey(m.getBrandName())) {
                    m.setBrandId(brandMap.get(m.getBrandName()).getId());
                } else {
                    m.setErrorMsg("品牌【"+m.getBrandName()+"】在系统中不存在！");
                    errorList.add(m);
                    continue;
                }

                if(StringUtils.isNotBlank(m.getSupplierName())) { //填写供应商名称的 则与EL库做匹配
                    if(supplierMap.containsKey(m.getSupplierName())) {
                        m.setSupplierId(supplierMap.get(m.getSupplierName()).getId());
                        m.setSupplierCode(supplierMap.get(m.getSupplierName()).getCode());
                    } else {
                        m.setErrorMsg("供应商【"+m.getSupplierName()+"】在系统中不存在！");
                        errorList.add(m);
                        continue;
                    }
                }


                successList.add(m);
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
