package com.ejianc.business.zdsmaterial.cloudstore.apply.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.cloudstore.apply.service.IAllotApplyService;
import com.ejianc.business.zdsmaterial.cloudstore.apply.vo.AllotApplyVO;
import com.ejianc.business.zdsmaterial.cloudstore.apply.vo.ShopCartVO;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.bean.GoodsEntity;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.service.IGoodsService;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zdsmaterial.cloudstore.apply.mapper.ShopCartMapper;
import com.ejianc.business.zdsmaterial.cloudstore.apply.bean.ShopCartEntity;
import com.ejianc.business.zdsmaterial.cloudstore.apply.service.IShopCartService;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 购物车
 * 
 * @author generator
 * 
 */
@Service("shopCartService")
public class ShopCartServiceImpl extends BaseServiceImpl<ShopCartMapper, ShopCartEntity> implements IShopCartService{

    @Autowired
    private IGoodsService goodsService;

    @Autowired
    private IAllotApplyService allotApplyService;
    @Override
    public CommonResponse<List<GoodsEntity>> queryGoodsByPurUserId(Long purUserId){
        QueryWrapper<ShopCartEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("pur_user_id",purUserId);
        List<ShopCartEntity> list = super.list(queryWrapper);
        List<Long> marketIds = list.stream().map(ShopCartEntity::getMarketId).collect(Collectors.toList());
        QueryWrapper<GoodsEntity> queryGoods = new QueryWrapper<>();
        queryGoods.in("id", marketIds);
        List<GoodsEntity> goods = goodsService.list(queryGoods);
        return CommonResponse.success(goods);
    }
    @Override
    public CommonResponse<Integer> queryCountByPurUserId(Long purUserId){
        QueryWrapper<ShopCartEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("pur_user_id",purUserId);
        return CommonResponse.success(super.count(queryWrapper));
    }
    @Override
    public AllotApplyVO addAllotApply(List<ShopCartVO> vos) {
        List<ShopCartEntity> shopCartEntities = new ArrayList<>();
        for (ShopCartVO vo:vos){
            ShopCartEntity shopCartEntity = super.selectById(vo.getId());
            shopCartEntity.setAllotNum(vo.getAllotNum());
            shopCartEntities.add(shopCartEntity);
        }
        AllotApplyVO allotApplyVO = allotApplyService.addAllotApplyByCart(shopCartEntities);
        super.saveOrUpdateBatch(shopCartEntities);
        return allotApplyVO;
    }

    @Override
    public void upShopCart(List<Long> ids) {
        super.removeByIds(ids);
    }
}
