package com.ejianc.business.zdsmaterial.erp.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 品牌申请主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_brand_apply")
public class BrandApplyEntity extends BaseEntity {
    private static final long serialVersionUID = 278589654045628751L;

    @TableField(value="bill_code")
    private String billCode; // 编码
    @TableField(value="apply_user_id")
    private Long applyUserId; // 申请人id
    @TableField(value="apply_user_sid")
    private String applyUserSid; // 申请人名称
    @TableField(value="apply_user_name")
    private String applyUserName; // 申请人名称
    @TableField(value="apply_user_code")
    private String applyUserCode; // 申请人账号
    @TableField(value="memo")
    private String memo; // 申请说明
    @TableField(value="sec_org_id")
    private Long secOrgId; // 申请人所属二级单位id
    @TableField(value="sec_org_name")
    private String secOrgName; // 申请人所属二级单位名称
    @TableField(value="sec_org_code")
    private String secOrgCode; // 申请人所属二级单位编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人编码
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期

    @TableField(value = "brand_names")
    private String brandNames; //品牌名称

    @TableField(exist=false)
    @SubEntity(serviceName="brandApplyDetailService", pidName = "applyId")
    private List<BrandApplyDetailEntity> detailList = new ArrayList<>(); // 品牌申请字表-品牌明细

    public String getBrandNames() {
        return brandNames;
    }

    public void setBrandNames(String brandNames) {
        this.brandNames = brandNames;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }
    public String getApplyUserSid() {
        return applyUserSid;
    }

    public void setApplyUserSid(String applyUserSid) {
        this.applyUserSid = applyUserSid;
    }
    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }
    public String getApplyUserCode() {
        return applyUserCode;
    }

    public void setApplyUserCode(String applyUserCode) {
        this.applyUserCode = applyUserCode;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getSecOrgId() {
        return secOrgId;
    }

    public void setSecOrgId(Long secOrgId) {
        this.secOrgId = secOrgId;
    }
    public String getSecOrgName() {
        return secOrgName;
    }

    public void setSecOrgName(String secOrgName) {
        this.secOrgName = secOrgName;
    }
    public String getSecOrgCode() {
        return secOrgCode;
    }

    public void setSecOrgCode(String secOrgCode) {
        this.secOrgCode = secOrgCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public List<BrandApplyDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<BrandApplyDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
