package com.ejianc.business.zdsmaterial.erp.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;
/**
 * 品牌关系
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_brand_relation")
public class BrandRelationEntity extends BaseEntity {

    private static final long serialVersionUID = 959912244349054709L;

    @TableField(value = "source_id")
    private String sourceId;//第三方业务单据Id
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物料分类id
    @TableField(value="material_type_sid")
    private String materialTypeSid; // 物料分类sid
    @TableField(value="material_type_name")
    private String materialTypeName; // 物料分类名称
    @TableField(value="material_type_code")
    private String materialTypeCode; // 物料分类编码
    @TableField(value="material_type_pname")
    private String materialTypePname; // 上级物料分类名称
    @TableField(value="material_type_pid")
    private Long materialTypePid; // 上级物料分类id
    @TableField(value="material_type_psid")
    private String materialTypePsid; // 上级物料分类sid
    @TableField(value="brand_id")
    private Long brandId; // 品牌id
    @TableField(value="brand_name")
    private String brandName; // 品牌名称
    @TableField(value="brand_sid")
    private String brandSid; // 品牌来源id
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value = "supplier_code")
    private String supplierCode;//供应商编码
    @TableField(value = "supplier_character")
    private String supplierCharacter; //供应商供货内容性质：0-生产商，1-贸易商-代理型，2-贸易商-项目授权型
    @TableField(value="supplier_sid")
    private String supplierSid; // 供应商sid
    @TableField(value="db_supplier_flag")
    private Integer dbSupplierFlag; // 供应商是否在库 0-否，1-是
    @TableField(value="relation_enabled")
    private Integer relationEnabled; // 停启用：0-停用，1-启用
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="push_erp_flag")
    private Integer pushErpFlag; // 推送ERP标识：0-待推送，1-已推送，2-推送失败

    @TableField(exist = false)
    private Integer brandEnabled; //品牌停启用:0-停用，1-启用
    @TableField(exist = false)
    private Integer brandSequence; //序号
    @TableField(value = "brand_label")
    private String brandLabel; //品牌标签 0-代理，1-直签，2-代理/直签

    @TableField(exist=false)
    private String delFlag; //是否删除 0-否，1-是

    @TableField(exist=false)
    private String brandControlFlag;//物料分类品牌管控标识 0-停用，1-启用

    @TableField(value = "source_main_id")
    private Long sourceMainId;//数据来源业务主表id
    @TableField(value = "source_detail_id")
    private Long sourceDetailId; //数据来源业务字表id
    
    @TableField(exist=false)
    @SubEntity(serviceName="brandRelationFlowService", pidName = "relationId")
    private List<BrandRelationFlowEntity> detailList = new ArrayList<>(); // 品牌关系流水

    public Long getSourceMainId() {
        return sourceMainId;
    }

    public void setSourceMainId(Long sourceMainId) {
        this.sourceMainId = sourceMainId;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public String getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(String delFlag) {
        this.delFlag = delFlag;
    }

    public String getBrandControlFlag() {
        return brandControlFlag;
    }

    public void setBrandControlFlag(String brandControlFlag) {
        this.brandControlFlag = brandControlFlag;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public Integer getBrandEnabled() {
        return brandEnabled;
    }

    public void setBrandEnabled(Integer brandEnabled) {
        this.brandEnabled = brandEnabled;
    }

    public Integer getBrandSequence() {
        return brandSequence;
    }

    public void setBrandSequence(Integer brandSequence) {
        this.brandSequence = brandSequence;
    }

    public String getBrandLabel() {
        return brandLabel;
    }

    public void setBrandLabel(String brandLabel) {
        this.brandLabel = brandLabel;
    }

    public String getSupplierCharacter() {
        return supplierCharacter;
    }

    public void setSupplierCharacter(String supplierCharacter) {
        this.supplierCharacter = supplierCharacter;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeSid() {
        return materialTypeSid;
    }

    public void setMaterialTypeSid(String materialTypeSid) {
        this.materialTypeSid = materialTypeSid;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }
    public String getMaterialTypePname() {
        return materialTypePname;
    }

    public void setMaterialTypePname(String materialTypePname) {
        this.materialTypePname = materialTypePname;
    }
    public Long getMaterialTypePid() {
        return materialTypePid;
    }

    public void setMaterialTypePid(Long materialTypePid) {
        this.materialTypePid = materialTypePid;
    }
    public String getMaterialTypePsid() {
        return materialTypePsid;
    }

    public void setMaterialTypePsid(String materialTypePsid) {
        this.materialTypePsid = materialTypePsid;
    }
    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }
    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
    public String getBrandSid() {
        return brandSid;
    }

    public void setBrandSid(String brandSid) {
        this.brandSid = brandSid;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupplierSid() {
        return supplierSid;
    }

    public void setSupplierSid(String supplierSid) {
        this.supplierSid = supplierSid;
    }
    public Integer getDbSupplierFlag() {
        return dbSupplierFlag;
    }

    public void setDbSupplierFlag(Integer dbSupplierFlag) {
        this.dbSupplierFlag = dbSupplierFlag;
    }
    public Integer getRelationEnabled() {
        return relationEnabled;
    }

    public void setRelationEnabled(Integer relationEnabled) {
        this.relationEnabled = relationEnabled;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getPushErpFlag() {
        return pushErpFlag;
    }

    public void setPushErpFlag(Integer pushErpFlag) {
        this.pushErpFlag = pushErpFlag;
    }


    public List<BrandRelationFlowEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<BrandRelationFlowEntity> detailList) {
        this.detailList = detailList;
    }
}
