package com.ejianc.business.zdsmaterial.erp.controller;

import com.ejianc.business.zdsmaterial.erp.service.IMessageInfoService;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Author: caojie
 * @CreateTime:2025-05-19 17:50
 * @Version: 1.0
 */
@RestController
@RequestMapping(value = "thirdTodo")
public class ThirdTodoController {

    @Autowired
    private IMessageInfoService service;


    /**
     * 待办、已办批量处理
     *
     * @return
     */
    @RequestMapping(value = "/thirdTaskReSend", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> thirdTaskReSend(@RequestBody List<Long> ids) {
        service.thirdTaskReSend(ids);
        return CommonResponse.success("操作成功！");
    }

    /**
     * 中电四-待办、已办批量重新推送
     *
     * @return
     */
    @RequestMapping(value = "/scanThirdFailTask", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> scanThirdFailTask() {
        service.scanThirdFailTask();
        return CommonResponse.success("操作成功！");
    }

}
