package com.ejianc.business.zdsmaterial.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 物资来源明细
 *
 * @author CJ
 * @Description:
 * @date 2024/1/12 11:14
 */
@TableName("ejc_material_source")
public class MaterialSourceEntity extends BaseEntity {

    private static final long serialVersionUID = 7593989147228159513L;

    @ApiModelProperty("物资Id")
    @TableField("material_id")
    private Long materialId;

    @ApiModelProperty("来源单据类型")
    @TableField(value = "bill_type")
    private String billType;

    @ApiModelProperty("来源单据类型名称")
    @TableField("bill_type_name")
    private String billTypeName;

    @ApiModelProperty("来源单据编码")
    @TableField("source_bill_code")
    private String sourceBillCode;

    @ApiModelProperty("来源单据主表Id")
    @TableField("source_pid")
    private Long sourcePid;

    @ApiModelProperty("来源单据子表Id")
    @TableField("source_detail_id")
    private Long sourceDetailId;

    @ApiModelProperty("来源单据PC端详情地址")
    @TableField("source_bill_pc_url")
    private String sourceBillPcUrl;

    @ApiModelProperty("来源单据移动端详情地址")
    @TableField("source_bill_mobile_url")
    private String sourceBillMobileUrl;

    @ApiModelProperty("来源数据创建人编码")
    @TableField("source_create_user_code")
    private String sourceCreateUserCode;

    @ApiModelProperty("创建人名称")
    @TableField(value = "source_create_user_name")
    private String sourceCreateUserName;

    @ApiModelProperty("来源单据所属组织名称")
    @TableField(value = "source_org_name")
    private String sourceOrgName;

    @ApiModelProperty("来源数据创建时间")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField("source_create_time")
    private Date sourceCreateTime;

    public String getSourceCreateUserName() {
        return sourceCreateUserName;
    }

    public void setSourceCreateUserName(String sourceCreateUserName) {
        this.sourceCreateUserName = sourceCreateUserName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getBillTypeName() {
        return billTypeName;
    }

    public void setBillTypeName(String billTypeName) {
        this.billTypeName = billTypeName;
    }

    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }

    public Long getSourcePid() {
        return sourcePid;
    }

    public void setSourcePid(Long sourcePid) {
        this.sourcePid = sourcePid;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public String getSourceBillPcUrl() {
        return sourceBillPcUrl;
    }

    public void setSourceBillPcUrl(String sourceBillPcUrl) {
        this.sourceBillPcUrl = sourceBillPcUrl;
    }

    public String getSourceBillMobileUrl() {
        return sourceBillMobileUrl;
    }

    public void setSourceBillMobileUrl(String sourceBillMobileUrl) {
        this.sourceBillMobileUrl = sourceBillMobileUrl;
    }

    public String getSourceCreateUserCode() {
        return sourceCreateUserCode;
    }

    public void setSourceCreateUserCode(String sourceCreateUserCode) {
        this.sourceCreateUserCode = sourceCreateUserCode;
    }

    public String getSourceOrgName() {
        return sourceOrgName;
    }

    public void setSourceOrgName(String sourceOrgName) {
        this.sourceOrgName = sourceOrgName;
    }

    public Date getSourceCreateTime() {
        return sourceCreateTime;
    }

    public void setSourceCreateTime(Date sourceCreateTime) {
        this.sourceCreateTime = sourceCreateTime;
    }
}
