package com.ejianc.business.zdsmaterial.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.material.bean.InvalidMatExaminerEntity;
import com.ejianc.business.zdsmaterial.material.service.IInvalidMatExaminerService;
import com.ejianc.business.zdsmaterial.material.vo.InvalidMatExaminerVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 临时档案审核人
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("invalidMatExaminer")
public class InvalidMatExaminerController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvalidMatExaminerService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<String> saveOrUpdate(@RequestBody List<InvalidMatExaminerVO> saveOrUpdateVOs) {
    	List<Long> employeeIds = saveOrUpdateVOs.stream().map(InvalidMatExaminerVO::getEmployeeId).collect(Collectors.toList());
        Long categoryId = saveOrUpdateVOs.get(0).getCategoryId();

        //去掉已添加的人员
    	List<InvalidMatExaminerVO> existsEmpList = service.getByEmpIdsAndCategoryId(categoryId, employeeIds);
        if(CollectionUtils.isNotEmpty(existsEmpList)) {
            List<Long> existsEmpIds = existsEmpList.stream().map(InvalidMatExaminerVO::getEmployeeId).collect(Collectors.toList());
            saveOrUpdateVOs = saveOrUpdateVOs.stream().filter(item -> !existsEmpIds.contains(item.getEmployeeId())).collect(Collectors.toList());
        }
        if(CollectionUtils.isNotEmpty(saveOrUpdateVOs)) {
            saveOrUpdateVOs.stream().forEach(item -> {
                item.setSourceId(UUID.randomUUID().toString());
            });
            List<InvalidMatExaminerEntity> saveEntites = BeanMapper.mapList(saveOrUpdateVOs, InvalidMatExaminerEntity.class);
            service.saveOrUpdateBatch(saveEntites, saveEntites.size(), false);

            //推送ERP
//            cToEMap<String, Object> syncParams = new HashedMap();
////            syncParams.put("ids", saveEntites.stream().map(InvalidMatExaminerEntity::getId).collect(Collectors.toList()));
////            service.synrp(syncParams);
        }

    	return CommonResponse.success("操作成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<InvalidMatExaminerVO> queryDetail(Long id) {
    	InvalidMatExaminerEntity entity = service.selectById(id);
    	InvalidMatExaminerVO vo = BeanMapper.map(entity, InvalidMatExaminerVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<InvalidMatExaminerVO> vos) {
        service.removeByIds(vos.stream().map(InvalidMatExaminerVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<InvalidMatExaminerVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("employeeCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("employeePostName");
        fuzzyFields.add("employeeOrgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<InvalidMatExaminerEntity> page = service.queryPage(param,false);
        IPage<InvalidMatExaminerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvalidMatExaminerVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<InvalidMatExaminerEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("InvalidMatExaminer-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refInvalidMatExaminerData", method = RequestMethod.GET)
    public CommonResponse<IPage<InvalidMatExaminerVO>> refInvalidMatExaminerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<InvalidMatExaminerEntity> page = service.queryPage(param,false);
        IPage<InvalidMatExaminerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvalidMatExaminerVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

     @PostMapping(value = "/pushToZds")
     public CommonResponse<String> pushToZds(@RequestBody JSONObject param) {
        logger.info("临时档案审核人推送中电四任务开始*********, param-{}", param.toString(SerializerFeature.PrettyFormat));
         String startDate = null != param.get("startDate") ? param.getString("startDate") : null;
         String endDate = null != param.get("endDate") ? param.getString("endDate") : null;
         if(StringUtils.isBlank(startDate) && StringUtils.isBlank(endDate)) {
             SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
             //获取昨天日期
             startDate = sdf.format(DateUtil.addDays(new Date(), -1));
             endDate = startDate + " 23:59:59";
             startDate += " 00:00:00";
         }

         Map<String, Object> queryParams = new HashMap<>();
         queryParams.put("startDate", startDate);
         queryParams.put("endDate", endDate);

         service.syncToErp(queryParams);

         return CommonResponse.success("临时档案审核人同步ERP任务执行成功!");
     }
}
