package com.ejianc.business.zdsmaterial.material.mapper;

import com.ejianc.business.zdsmaterial.material.bean.MaterialPropertyRelationEntity;
import com.ejianc.business.zdsmaterial.material.vo.MaterialRelationAiVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 材料属性关系
 * 
 * @author generator
 * 
 */
@Mapper
public interface MaterialPropertyRelationMapper extends BaseCrudMapper<MaterialPropertyRelationEntity> {

    void deleteByMaterialIds(@Param("materialIds") List<Long> materialIds);

    List<Long> matchedMaterialIdsByPropertyVal(@Param("params") Map<String, Object> propertyFilterParam);

    List<String> checkMaterialPropertyValue(@Param("materialId") Long materialId);

    List<Long> validMaterialHasNewPropertyItem(@Param("materialIds") List<Long> materialIds, @Param("categoryIds") List<Long> categoryIds);

    List<MaterialRelationAiVO> getAiRelationsByMaterialIds(@Param("materialIds") List<Long> materialIds);
}
