package com.ejianc.business.zdsmaterial.material.service;

import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertyEntity;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertyVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 材料分类属性
 * 
 * @author generator
 * 
 */
public interface IMaterialCategoryPropertyService extends IBaseService<MaterialCategoryPropertyEntity> {

    List<MaterialCategoryPropertyVO> getAllByCategoryId(Long categoryId, Integer enabled);

    List<MaterialCategoryPropertyVO> getAllPropertiesAndValue(Long categoryId, Integer enabled, Boolean includeUnValid);

    String checkQuote(List<Long> propertyIds);

    List<MaterialCategoryPropertyVO> queryByIds(List<Long> collect);

    Map<Long, List<MaterialCategoryPropertyVO>> getAllByCategoryIds(List<Long> categoryIds, Integer enabled);
    Map<Long, List<MaterialCategoryPropertyVO>> getAllByCategoryIds(List<Long> categoryIds);

    List<MaterialCategoryPropertyVO> getAllPropertiesAndValueHaveUnit(Long categoryId, Integer enabled, Boolean includeUnValid);
}
