package com.ejianc.business.zdsmaterial.plan.conjecture.handler;

import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public interface IMaterialConjectureHandler {
    /**
     * 物料AI识别 批量
     * @param sourceList
     * @return
     */
    default Future<List<MaterialConjectureVO>> conjecture(List<MaterialConjectureVO> sourceList, String authority) {
        return null;
    }

    /**
     * 物料AI识别 单个
     * @param source
     * @return
     */
    default Future<MaterialConjectureVO> conjectureSingle(MaterialConjectureVO source, String authority) {
        return null;
    }

    /**
     * 相似物料匹配
     * @param searchText 相似匹配内容
     * @param topLimit 返回按相似度排序，从高到低共 topLimit 个结果
     * @param queryRange 物料类型限制，以数组形式传入
     * @return
     */
    default Map<Long, MaterialConjectureVO> similarSearch(String searchText, Integer topLimit, String[] queryRange) {
        return new HashMap<>();
    }

}
