package com.ejianc.business.zdsmaterial.plan.purchase.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdscost.api.IBudgetPorjectDetailApi;
import com.ejianc.business.zdscost.consts.ChangTypeConst;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailVO;
import com.ejianc.business.zdscost.vo.query.BudgetProjectDetailQueryVO;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.erp.bean.OrderEntity;
import com.ejianc.business.zdsmaterial.erp.vo.SyncOrderDetailVO;
import com.ejianc.business.zdsmaterial.erp.vo.SyncOrderVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.constants.ConjectureConstants;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.api.IUnitApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.UnitShareVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.*;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author: caojie
 * @CreateTime:2025-04-14 15:20
 * @Version: 1.0
 */
@RestController
@RequestMapping(value = "/purchasePlanDetail/")
public class PurchasePlanDetailController {

    @Autowired
    private IMaterialConjectureService materialConjectureService;
    @Autowired
    private IBudgetPorjectDetailApi budgetPorjectDetailApi;
    @Autowired
    private IUnitApi unitApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    private final String QUE_BUDGET_DETAIL_REQ_URL = "/cefoc/yql/getContractLimitedSubBList";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "ControlPlan-material-import.xlsx", "采购计划清单导入模板");
    }

    @RequestMapping(value = "/downloadBudgetDate")
    @ResponseBody
    public void downloadBudgetDate(Long projectId,String materialPackIds,String materialPackCodes,HttpServletRequest request, HttpServletResponse response){
        if (projectId == null ) {
            throw new BusinessException("参数项目ID[projectId]不能为空！");
        }
        logger.info("*********************中电四-获取切包清单明细 开始*********************");
        CommonResponse<ProjectPoolSetVO> projectVoResp = projectSetApi.getProjectId(projectId);
        if (!projectVoResp.isSuccess()){
            throw new BusinessException("查询项目信息失败！");
        }
        Map<String, Object> param = new HashMap<>();
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + QUE_BUDGET_DETAIL_REQ_URL+"?ProjectOID="+projectVoResp.getData().getSourceId();
        if (StringUtils.isNotBlank(materialPackCodes)){
            reqUrl =reqUrl +"&PackageCode="+materialPackCodes;
        }
        JSONObject reqJson = null;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1900, Calendar.JANUARY, 1);
        String startDateStr =  DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO,calendar.getTime());
        String endDateStr =  DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO, new Date());;
        param.put("BeginDateTime", startDateStr);
        param.put("EndDateTime", endDateStr);
        param.put("PageSize", -1);
        param.put("PageNum", 1);

        try {
            Map<String, String> headers = ZDSInterfaceCommonUtil.getErpHeaders();

            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers, ZDSInterfaceCommonUtil.CONN_TIME_OUT,
                    ZDSInterfaceCommonUtil.READ_TIME_OUT);
            reqJson = JSONObject.parseObject(reqResp);

            if("ok".equals(reqJson.getString("status"))) {
                logger.error("请求中电四获取切包清单明细结果返回成功：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
                JSONArray pageData = reqJson.getJSONArray("data");
                logger.info("获取切包清单明细数据：{}条", pageData.size());
                List<JSONObject> list = new ArrayList();
                Map<String, Object> beans = new HashMap<>();
                if(pageData.size() == 0) {
                    logger.info("获取切包清单明细数据为空，任务执行结束。。。。");
                }else {
                    JSONObject tmpJson = null;

                    for (Object obj : pageData) {
                        tmpJson = (JSONObject) obj;
                        JSONObject detailVO = new JSONObject();
//                        detailVO.setMaterialPackName(tmpJson.getString("MaterialPackageName"));
//                        detailVO.setId(Long.valueOf(tmpJson.getString("YQL_ID")));
//                        detailVO.setItemName(tmpJson.getString("DownProjectName"));
//                        detailVO.setItemFeature(tmpJson.getString("DownProjectFeature"));
//                        detailVO.setItemUnit(tmpJson.getString("DownUnit"));
                        detailVO.put("materialPackName",tmpJson.getString("MaterialPackageName"));
                        detailVO.put("id",tmpJson.getString("YQL_ID"));
                        detailVO.put("itemName",tmpJson.getString("DownProjectName"));
                        detailVO.put("itemFeature",tmpJson.getString("DownProjectFeature"));
                        detailVO.put("itemUnit",tmpJson.getString("DownUnit"));
                        detailVO.put("itemNum",tmpJson.getBigDecimal("ApproachNum").setScale(2, BigDecimal.ROUND_HALF_UP));
                        list.add(detailVO);
                    }
                }
                beans.put("records", list);
                ExcelExport.getInstance().export("material-budget-nocode-import.xlsx", beans, response);

            }else {
                logger.error("请求中电四切包清单明细结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
            }

        } catch (Exception e) {
            logger.error("获取切包清单明细异常, 请求地址：{}, 请求参数：{}", reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat), e);
        }
    }

    @PostMapping(value = "/saveImport")
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<MaterialConjectureVO> saveList, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        //保存入库
        materialConjectureService.saveOrUpdateBatch(BeanMapper.mapList(saveList, MaterialConjectureEntity.class), saveList.size(), false);

        //启动异步识别
        materialConjectureService.startConjecture(saveList.get(0).getIdentificationId(), authority, saveList.get(0).getMode());

        return CommonResponse.success("操作成功,物料识别中！");
    }

    @GetMapping(value = "/getConjectureProgress")
    @ResponseBody
    public CommonResponse<JSONObject> saveImport(@RequestParam String identificationId,
                                                 @RequestParam(required = false) String mateType,
                                                 @RequestParam(required = false) String actualCategoryName,
                                                 @RequestParam(required = false) String actualMaterialCode,
                                                 @RequestParam(required = false) String actualMaterialName,
                                                 @RequestParam(required = false) String actualMaterialSpec,
                                                 @RequestParam(required = false) String actualUnitName,
                                                 @RequestParam(required = false) BigDecimal actualNum) {
        JSONObject resp = new JSONObject();
        List<MaterialConjectureEntity> identifyList = materialConjectureService
                .getAllByIdentifyId(identificationId, null,actualCategoryName,actualMaterialCode,actualMaterialName,actualMaterialSpec,actualUnitName,actualNum);

        resp.put("total", identifyList.size());
        Integer completeMatch = 0, partialMatch = 0, misMatch = 0;

        resp.put("conjecturedNum", identifyList.stream().filter(item -> !"3".equals(item.getMateType())&&!"4".equals(item.getMateType())).count());
        List<MaterialConjectureEntity> respList = new ArrayList<>();
        for(MaterialConjectureEntity m :identifyList) {
            switch (m.getMateType()) {
                case "0": //不匹配
                    misMatch++;
                    break;
                case "1": //部分匹配
                    partialMatch++;
                    break;
                case "2": //完全匹配
                    completeMatch++;
                    break;
                default:;
            }
            if(StringUtils.isBlank(mateType) || "-1".equals(mateType) || (m.getMateType().equals(mateType))) {
                respList.add(m);
            }
        }

        resp.put("completeMatch", completeMatch);
        resp.put("partialMatch", partialMatch);
        resp.put("misMatch", misMatch);
        resp.put("identifyList", CollectionUtils.isNotEmpty(respList) ?
                BeanMapper.mapList(respList, MaterialConjectureVO.class) : new ArrayList<>());

        return CommonResponse.success(resp);
    }


    @PostMapping(value = "/delConjectureDetail")
    @ResponseBody
    public CommonResponse<String> delConjectureByIds(@RequestBody List<Long> detailIds) {
        materialConjectureService.delConjectureByIds(detailIds);
        return CommonResponse.success("操作成功！");
    }


    @PostMapping(value = "/excelImport")
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request ) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        String conjectureId = request.getParameter("identificationId"); //导入序列
        String mode = request.getParameter("mode"); //识别渠道
        if(StringUtils.isBlank(mode)) { //默认长江云通
            mode = ConjectureConstants.CONJECTURE_TYPE_CJTY;
        }
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }

        List<MaterialConjectureVO> successList = new ArrayList<>();
        List<MaterialConjectureVO> processList = new ArrayList<>();
        List<MaterialConjectureVO> errorList = new ArrayList<>();
        Set<String> unitNames = new HashSet<>();

        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            if(result.size() > 10000) {
                return CommonResponse.error("数据超过10000条，请分批上传！");
            }
            MaterialConjectureVO vo = null;

            for(int i = 0;i < result.size(); i++) {
                List<String> datas = result.get(i);
                vo = new MaterialConjectureVO();
                vo.setMode(mode);
                vo.setIdentificationId(conjectureId);
                vo.setMateType("4"); //默认待识别
                vo.setConjectureMateType("4"); //默认待识别
                vo.setDelFlag("0");//未作废
                vo.setIgnoreFlag("0");//未忽略
                vo.setLoadState("0");//未加载
                vo.setIdentificationDate(new Date());
                vo.setId(IdWorker.getId());
                vo.setImportSeq(datas.get(0)); //序号
                vo.setSourceMaterialName(datas.get(1)); //物料名称
                vo.setSourceUnitName(datas.get(3)); //单位
                vo.setSourceMaterialSpec(datas.get(2)); //描述
                vo.setSourceNum(ComputeUtil.toBigDecimal(datas.get(4))); //数量
                vo.setActualNum(ComputeUtil.toBigDecimal(datas.get(4))); //数量
                if(StringUtils.isBlank(datas.get(1))){
                    vo.setErrorMsg("物料名称不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(2))){
                    vo.setErrorMsg("描述不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(3))){
                    vo.setErrorMsg("单位不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(4))){
                    vo.setErrorMsg("数量不能为空！");
                    errorList.add(vo);
                    continue;
                }
                unitNames.add(vo.getSourceUnitName());

                vo.setRowState("add");
                processList.add(vo);
            }
        }

        if(CollectionUtils.isNotEmpty(processList)) {
            CommonResponse<List<UnitShareVO>> unitListResp = unitApi.findAllEnabledList(new ArrayList<>(unitNames));
            if(!unitListResp.isSuccess()) {
                logger.error("物料ai导入识别失败，获取单据信息失败,names:{}, 结果：{}", JSONObject.toJSONString(unitNames), JSONObject.toJSONString(unitListResp));
                return CommonResponse.error("操作失败，匹配计量单位信息失败！");
            }
            if(CollectionUtils.isEmpty(unitListResp.getData())) {
                logger.error("物料ai导入识别失败，获取单据信息为空, names:{}", JSONObject.toJSONString(unitNames));
                return CommonResponse.error("操作失败，匹配计量单位信息失败！");
            }

            Map<String, Long> unitNameIdMap = new HashMap<>();
            Map<String, Long> unitAliasNameIdMap = new HashMap<>();
            unitNameIdMap.putAll(unitListResp.getData().stream().collect(Collectors.toMap(UnitShareVO::getUnitName, UnitShareVO::getId, (k1, k2) -> k1)));
            unitAliasNameIdMap.putAll(unitListResp.getData().stream().filter(item -> StringUtils.isNotBlank(item.getAliasName())).collect(Collectors.toMap(item -> item.getAliasName(), UnitShareVO::getId, (k1,k2) -> k1)));

            for(MaterialConjectureVO m : processList) {
                m.setActualUnitName(m.getSourceUnitName());

                if(unitNameIdMap.containsKey(m.getSourceUnitName())) {
                    m.setActualUnitId(unitNameIdMap.get(m.getSourceUnitName()));
                }
                for(String key : unitAliasNameIdMap.keySet()) {
                    if(key.contains(","+m.getSourceUnitName()+",")) {
                        m.setActualUnitId(unitAliasNameIdMap.get(key));
                    }
                }

                if(null == m.getActualUnitId()) {
                    m.setErrorMsg("计量单位与在系统中不存在！");
                    errorList.add(m);
                    continue;
                }
                successList.add(m);
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    @PostMapping(value = "/excelImportBudgetDate")
    @ResponseBody
    public CommonResponse<JSONObject> excelImportBudgetDate(Long projectId,String materialPackIds,HttpServletRequest request ) {
        if (projectId == null ) {
            throw new BusinessException("参数项目ID[projectId]不能为空！");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        String conjectureId = request.getParameter("identificationId"); //导入序列
        String mode = request.getParameter("mode"); //识别渠道
        if(StringUtils.isBlank(mode)) { //默认长江云通
            mode = ConjectureConstants.CONJECTURE_TYPE_CJTY;
        }
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }

        List<MaterialConjectureVO> successList = new ArrayList<>();
        List<MaterialConjectureVO> processList = new ArrayList<>();
        List<MaterialConjectureVO> errorList = new ArrayList<>();
        Set<String> unitNames = new HashSet<>();
        List<Long> budgetDetailIds= new ArrayList();
        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            if(result.size() > 10000) {
                return CommonResponse.error("数据超过10000条，请分批上传！");
            }
            MaterialConjectureVO vo = null;

            for(int i = 0;i < result.size(); i++) {
                List<String> datas = result.get(i);
                vo = new MaterialConjectureVO();
                vo.setMode(mode);
                vo.setIdentificationId(conjectureId);
                vo.setMateType("4"); //默认待识别
                vo.setConjectureMateType("4"); //默认待识别
                vo.setDelFlag("0");//未作废
                vo.setIgnoreFlag("0");//未忽略
                vo.setLoadState("0");//未加载
                vo.setIdentificationDate(new Date());
                vo.setId(IdWorker.getId());
                vo.setImportSeq(datas.get(0)); //序号
                vo.setMaterialPackName(datas.get(1)); //包名称
                if (StringUtils.isNotBlank(datas.get(2))) {
                    vo.setBudgetDetailId(Long.valueOf(datas.get(2))); //切包清单子表明细id
                    budgetDetailIds.add(Long.valueOf(datas.get(2)));
                }
                vo.setSourceMaterialName(datas.get(3)); //物料名称
                vo.setSourceUnitName(datas.get(5)); //单位
                vo.setSourceMaterialSpec(datas.get(4)); //描述
                vo.setSourceNum(ComputeUtil.toBigDecimal(datas.get(6))); //数量
                vo.setActualNum(ComputeUtil.toBigDecimal(datas.get(6))); //数量
                vo.setBudgetType("1");
//                if(StringUtils.isBlank(datas.get(1))){
//                    vo.setErrorMsg("包名称不能为空！");
//                    errorList.add(vo);
//                    continue;
//                }
//                if(StringUtils.isBlank(datas.get(2))){
//                    vo.setErrorMsg("清单编码不能为空！");
//                    errorList.add(vo);
//                    continue;
//                }
                if(StringUtils.isBlank(datas.get(3))){
                    vo.setErrorMsg("物料名称不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(4))){
                    vo.setErrorMsg("描述不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(5))){
                    vo.setErrorMsg("单位不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(6))){
                    vo.setErrorMsg("数量不能为空！");
                    errorList.add(vo);
                    continue;
                }
                unitNames.add(vo.getSourceUnitName());

                vo.setRowState("add");
                processList.add(vo);
            }
        }

        if(CollectionUtils.isNotEmpty(processList)) {
            CommonResponse<List<UnitShareVO>> unitListResp = unitApi.findAllEnabledList(new ArrayList<>(unitNames));
            if(!unitListResp.isSuccess()) {
                logger.error("物料ai导入识别失败，获取单据信息失败,names:{}, 结果：{}", JSONObject.toJSONString(unitNames), JSONObject.toJSONString(unitListResp));
                return CommonResponse.error("操作失败，匹配计量单位信息失败！");
            }
            if(CollectionUtils.isEmpty(unitListResp.getData())) {
                logger.error("物料ai导入识别失败，获取单据信息为空, names:{}", JSONObject.toJSONString(unitNames));
                return CommonResponse.error("操作失败，匹配计量单位信息失败！");
            }

            Map<String, Long> unitNameIdMap = new HashMap<>();
            Map<String, Long> unitAliasNameIdMap = new HashMap<>();
            Map<Long, BudgetProjectDetailVO> budegetMap = new HashMap<>();
            unitNameIdMap.putAll(unitListResp.getData().stream().collect(Collectors.toMap(UnitShareVO::getUnitName, UnitShareVO::getId, (k1, k2) -> k1)));
            unitAliasNameIdMap.putAll(unitListResp.getData().stream().filter(item -> StringUtils.isNotBlank(item.getAliasName())).collect(Collectors.toMap(item -> item.getAliasName(), UnitShareVO::getId, (k1,k2) -> k1)));
            if (CollectionUtils.isNotEmpty(budgetDetailIds)) {
                BudgetProjectDetailQueryVO queryVO = new BudgetProjectDetailQueryVO();
                queryVO.setProjectId(projectId);
                //queryVO.setMaterialPackIds(materialPackIds);
                queryVO.setBudgetDetailIds(StringUtils.join(budgetDetailIds, ","));
                queryVO.setPageIndex(1);
                queryVO.setPageSize(-1);
                CommonResponse<Page<BudgetProjectDetailVO>> commonResponse = budgetPorjectDetailApi.queryList(queryVO);
                if (!commonResponse.isSuccess()) {
                    logger.error("查询切包清单失败失败，结果:{}", JSONObject.toJSONString(commonResponse));
                }
                if (null !=commonResponse.getData()) {
                    budegetMap.putAll(commonResponse.getData().getRecords().stream().collect(Collectors.toMap(BudgetProjectDetailVO::getId,
                            Function.identity(), (v1, v2) -> v2)));
                }
            }
            for(MaterialConjectureVO m : processList) {
                m.setActualUnitName(m.getSourceUnitName());

                if(unitNameIdMap.containsKey(m.getSourceUnitName())) {
                    m.setActualUnitId(unitNameIdMap.get(m.getSourceUnitName()));
                }
                for(String key : unitAliasNameIdMap.keySet()) {
                    if(key.contains(","+m.getSourceUnitName()+",")) {
                        m.setActualUnitId(unitAliasNameIdMap.get(key));
                    }
                }

                if(null == m.getActualUnitId()) {
                    m.setErrorMsg("计量单位与在系统中不存在！");
                    errorList.add(m);
                    continue;
                }
                BudgetProjectDetailVO budgetProjectDetailVO = budegetMap.get(m.getBudgetDetailId());
                if (null == budgetProjectDetailVO){
//                    m.setErrorMsg("清单在切包清单中不存在！");
//                    errorList.add(m);
//                    continue;
                } else {
                    m.setItemCode(budgetProjectDetailVO.getItemCode());
                    m.setItemName(budgetProjectDetailVO.getItemName());
                    m.setMaterialPackId(budgetProjectDetailVO.getMaterialPackId());
                    m.setMaterialPackCode(budgetProjectDetailVO.getMaterialPackCode());
                }
                successList.add(m);
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    @RequestMapping(value = "/refERPBudgetProjectDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> refERPBudgetProjectDetail(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                       String condition,
                                                                                       String searchObject,
                                                                                       String searchText) {
        IPage iPage = new Page();
        /** 租户隔离 */
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            Map _con = JSONObject.parseObject(condition,Map.class);
            if ( _con.get("projectId")== null) {
                throw new BusinessException("参数项目ID[projectId]不能为空！");
            }
            String projectId= _con.get("projectId").toString();
            logger.info("*********************中电四-获取切包清单明细 开始*********************");
            CommonResponse<ProjectPoolSetVO> projectVoResp = projectSetApi.getProjectId(Long.valueOf(projectId));
            if (!projectVoResp.isSuccess()){
                throw new BusinessException("查询项目信息失败！");
            }
            Map<String, Object> param = new HashMap<>();
            String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + QUE_BUDGET_DETAIL_REQ_URL+"?ProjectOID="+projectVoResp.getData().getSourceId();
            JSONObject reqJson = null;
            Calendar calendar = Calendar.getInstance();
            calendar.set(1900, Calendar.JANUARY, 1);
            String startDateStr =  DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO,calendar.getTime());
            String endDateStr =  DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO, new Date());;
            param.put("BeginDateTime", startDateStr);
            param.put("EndDateTime", endDateStr);
            param.put("PageSize", -1);
            param.put("PageNum", 1);
            List<JSONObject> list = new ArrayList();

            try {
                Map<String, String> headers = ZDSInterfaceCommonUtil.getErpHeaders();

                String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers, ZDSInterfaceCommonUtil.CONN_TIME_OUT,
                        ZDSInterfaceCommonUtil.READ_TIME_OUT);
                reqJson = JSONObject.parseObject(reqResp);

                if("ok".equals(reqJson.getString("status"))) {
                    logger.error("请求中电四获取切包清单明细结果返回成功：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
                    JSONArray pageData = reqJson.getJSONArray("data");
                    logger.info("获取切包清单明细数据：{}条", pageData.size());
                    JSONObject tmpJson = null;
                    HashSet hashSet = new HashSet();
                    for (Object obj : pageData) {
                        tmpJson = (JSONObject) obj;
                        if (StringUtils.isBlank(tmpJson.getString("MaterialPackageCode")) || hashSet.contains(tmpJson.getString("MaterialPackageCode"))){
                            continue;
                        }
                        //模糊查询
                        if (null != searchText ){
                            if (tmpJson.getString("MaterialPackageCode").contains(searchText) || tmpJson.getString("MaterialPackageName").contains(searchText)) {
                                JSONObject detailVO = new JSONObject();
                                detailVO.put("id", tmpJson.getString("YQL_ID"));
                                detailVO.put("materialPackName", tmpJson.getString("MaterialPackageName"));
                                detailVO.put("materialPackCode", tmpJson.getString("MaterialPackageCode"));
                                detailVO.put("materialPackId", null);
                                detailVO.put("type", "材料包");
                                hashSet.add(tmpJson.getString("MaterialPackageCode"));
                                list.add(detailVO);
                            }
                        }else {
                            JSONObject detailVO = new JSONObject();
                            detailVO.put("id", tmpJson.getString("YQL_ID"));
                            detailVO.put("materialPackName", tmpJson.getString("MaterialPackageName"));
                            detailVO.put("materialPackCode", tmpJson.getString("MaterialPackageCode"));
                            detailVO.put("materialPackId", null);
                            detailVO.put("type", "材料包");
                            hashSet.add(tmpJson.getString("MaterialPackageCode"));
                            list.add(detailVO);
                        }
                    }
                    iPage.setRecords(list.subList((pageNumber - 1) * pageSize, Math.min(pageNumber * pageSize, list.size())));
                    iPage.setPages((int) Math.ceil((double) list.size() / pageSize));
                    iPage.setTotal(list.size());
                    iPage.setSize(pageSize);
                    iPage.setCurrent(pageNumber);
                    return CommonResponse.success("查询参照数据成功！", iPage);
                }else {
                    logger.error("请求中电四切包清单明细结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
                }

            } catch (Exception e) {
                logger.error("获取切包清单明细异常, 请求地址：{}, 请求参数：{}", reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat), e);
            }
        }else {
            throw new BusinessException("参数项目ID[projectId]不能为空！");
        }
        return CommonResponse.success("查询参照数据成功！", iPage);
    }

}
