package com.ejianc.business.zdsmaterial.sub.subvisa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractEntity;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractService;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.InstructionSetEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.SignatureChangeDetailEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.SignatureChangeEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.SignatureChangeSetDetailEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.enums.InstructionStatusEnum;
import com.ejianc.business.zdsmaterial.sub.subvisa.mapper.SignatureChangeMapper;
import com.ejianc.business.zdsmaterial.sub.subvisa.service.IInstructionSetService;
import com.ejianc.business.zdsmaterial.sub.subvisa.service.ISignatureChangeService;
import com.ejianc.business.zdsmaterial.sub.subvisa.vo.SignatureChangeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包签章变更
 * 
 * @author generator
 * 
 */
@Service("signatureChangeService")
public class SignatureChangeServiceImpl extends BaseServiceImpl<SignatureChangeMapper, SignatureChangeEntity> implements ISignatureChangeService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE_CODE = "EJCBT202402000002";//单价类型编码规则
    private static final String BILL_CODE = "SIGNCH-CODE";//此处需要根据实际修改
    private final String BILL_PUSH_PM_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/signatureChange/syncBill";//推送接口

    private final String OPERATE = "InstructionSetBill";

    @Autowired
    private IInstructionSetService instructionSetService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private SignatureChangeMapper mapper;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private ISubContractService subContractService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<String> syncBill(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);
        logger.info("接收到推送分包签章单据: {}, 当前上下文: {}", transData, authority);
        if (StringUtils.isBlank(transData)) {
            return CommonResponse.error("单据同步失败，单据内容为空！");
        }
        SignatureChangeEntity entity = JSONObject.parseObject(transData, SignatureChangeEntity.class);
        logger.info("接收到推送分包签章转换单据: {}", entity);
        long id = IdWorker.getId();
        //保存单据中附件并获取到上传后附件的Id
        Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                mp, BILL_TYPE_CODE, authority, String.valueOf(id));
        logger.info("保存单据中附件并获取到上传后附件的Id: {}",JSONObject.toJSONString(attachIdsMap));
        logger.info("保存单据中附件并获取到上传后附件的nameSourceTypeMapping: {}",nameSourceTypeMapping);
        //将附件关联在单据中
        List<Long> attchIdsList = new ArrayList<>();
        for (List<Long> attachIds : attachIdsMap.values()) {
            if (CollectionUtils.isNotEmpty(attachIds)) {
                attchIdsList.addAll(attachIds);
            }
        }
        //执行新增 设置来源
        entity.setSourceId(entity.getId());
        entity.setId(id);
        Map<String, Long> collect = new HashMap<>();
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryListBySourceId(entity.getId(), null, null, null);
        if (listCommonResponse.isSuccess()) {
            List<AttachmentVO> attachmentVOS = listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty(attachmentVOS)) {
                collect = attachmentVOS.stream().collect(Collectors.toMap(e -> e.getFileName(), e -> e.getId()));
            }
        }
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setReceiveStatus(InstructionStatusEnum.待审核.getStatus());

        //创建人
        EmployeeVO creator = null;
        if (entity.getSetId()!=null){
            entity.setSourceType(InstructionStatusEnum.来源指令单.getStatus());
            instructionSetService.changeInstructionSetStatus(entity.getSetId(), InstructionStatusEnum.已引用.getStatus());
            InstructionSetEntity instruct = instructionSetService.selectById(entity.getSetId());
            if(null == instruct) {
                logger.error("供方变更签证单保id-{}存失败，获取对应指令单信息id-{}为空！", entity.getSourceId(), entity.getSetId());
                return CommonResponse.error("操作失败，获取对应指令单信息失败！");
            }
            //创建人取指令单的创建人
            CommonResponse<EmployeeVO> empResp = employeeApi.getByEmpmloyeeCode(instruct.getCreateUserCode());
            if(empResp.isSuccess() || null == empResp.getData()) {
                logger.error("供方变更签证单保id-{}存失败，获取对应指令单创建人信息[userCode-{}]为空！", entity.getSourceId(), null != instruct ?
                        instruct.getCreateUserCode() : "指令单信息为空");
                return CommonResponse.error("操作失败，获取对应指令单创建人信息失败！");
            }
            creator = empResp.getData();
        }else {
            entity.setSourceType(InstructionStatusEnum.直接新增.getStatus());
            //创建人为合同录入人
            SubContractEntity contract = subContractService.selectById(entity.getSubContractId());
            CommonResponse<EmployeeVO> empResp = employeeApi.getOneBySourceId(contract.getSourceCompileId());
            if(empResp.isSuccess() || null == empResp.getData()) {
                logger.error("供方变更签证单保id-{}存失败，获取对应分包合同[id-{}]录入人信息[sourceId-{}]为空！", entity.getSourceId(),
                        null != contract ? contract.getId() : "合同信息为空", null != contract ? contract.getSourceCompileId() : "合同信息为空");
                return CommonResponse.error("操作失败，获取对应合同录入人信息失败！");
            }
            creator = empResp.getData();
        }

        //将附件关联在单据中
        entity.setAttachIds(attchIdsList);
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        entity.setVersion(null);
        entity.setCreateUserCode(creator.getCode());
        entity.setUpdateUserCode(null);
        Map<String, Long> finalCollect = collect;
        for(SignatureChangeDetailEntity detail : entity.getDetailList()) {
            if (finalCollect.containsKey(detail.getAttachmentName())){
                detail.setAttachmentId(finalCollect.get(detail.getAttachmentName()));
            }
            detail.setId(IdWorker.getId());
            detail.setSignatureId(entity.getId());
            detail.setSourceId(detail.getId());
            detail.setCreateTime(null);
            detail.setUpdateTime(null);
            detail.setTenantId(InvocationInfoProxy.getTenantid());
            detail.setUpdateUserCode(null);
            detail.setCreateUserCode(creator.getCode());
            detail.setVersion(null);
        }
        for(SignatureChangeSetDetailEntity detail : entity.getSetDetailList()) {
            detail.setId(IdWorker.getId());
            detail.setSignatureId(entity.getId());
            detail.setSourceId(detail.getId());
            detail.setCreateTime(null);
            detail.setUpdateTime(null);
            detail.setTenantId(InvocationInfoProxy.getTenantid());
            detail.setUpdateUserCode(null);
            detail.setCreateUserCode(creator.getCode());
            detail.setVersion(null);
        }
        logger.info("接收到推送分包签章转换保存单据: {}", JSONObject.toJSONString(entity));

        super.saveOrUpdate(entity,false);

        //供方提交变更签证 向指令发布人发送消息
        //标题：【签证变更】，【单据编号】，【时间】需要您审核！
        //内容：【单据编号】，【项目名称】，【合同名称】，【供应商名称】提交了变更申请，请您审核！
        PushMsgParameter parameter = new PushMsgParameter();

        parameter.setContent("【"+entity.getBillCode()+"】，【"+entity.getProjectName()+"】，【"+entity.getSubContractName()+"】，【"+
                entity.getSupplierName()+"提交了变更申请，请您审核！");
        parameter.setSubject("【签证变更】，【"+entity.getBillCode()+"】，【"+ DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())+"】需要您审核！");
        parameter.setReceivers(new String[]{entity.getEmployeeId().toString()});
        parameter.setPcUrl(baseHost + "ejc-zdsmaterial-frontend/#/signatureChange/card?id="+entity.getId().toString());
        sendMsg(parameter, entity.getId(), "供方提交变更签证 向指令发布人发送消息");

        return CommonResponse.success("单据同步成功！");
    }

    public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("提醒");
        parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS, PushMsgParameter.CHANNEL_TYPE_EMAIL});

        CommonResponse<String> sendResp = pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            logger.error("变更签证id-{}供方提交审核发送消息失败，{}", billId, oprMsg, JSONObject.toJSONString(sendResp, SerializerFeature.PrettyFormat,
                    SerializerFeature.WriteMapNullValue));
        } else {
            logger.info("变更签证id-{}供方提交审核发送消息成功！", billId, oprMsg);
        }
    }


    @Override
    public String pushBill(SignatureChangeEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = OPERATE + "::" + entity.getId().toString() + "::sup";

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);
            if (!locked) {
                releaseLock(jedis, false, key, OPERATE);
                return "分包变更推送供应链平台失败，加锁失败！";
            }
            //设置单据当前系统信息
            CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                logger.error("推送分包变更-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
                return "推送分包变更失败，获取当前系统编码失败";
            }
            Map<String, String> params = new HashMap<>();
            params.put("transData", JSONObject.toJSONString(entity));
            logger.info("分包变更推送供应链平台: url-{}, 分包变更：{}", BILL_PUSH_PM_SERVER_URL, JSONObject.toJSONString(entity));
            CommonResponse<String> writeBackResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_PUSH_PM_SERVER_URL,
                    params, entity.getSupplierId().toString(), null);
            logger.error("分包变更推送供应链平台请求结果，{}", JSONObject.toJSONString(writeBackResp));
            if (!writeBackResp.isSuccess()) {
                releaseLock(jedis, true, key, OPERATE);
                logger.error("分包变更id-{}推送供应链平台发送请求失败，{}", entity.getId(), writeBackResp.getMsg());
                return "分包变更推送供应链平台失败";
            }
            String operateRespStr = writeBackResp.getData();
            CommonResponse<String> operateResp = JSONObject.parseObject(operateRespStr, CommonResponse.class);
            if (!operateResp.isSuccess()) {
                logger.error("分包变更id-{}推送供应链，平台处理失败，{}", entity.getId(), operateResp.getMsg());
                releaseLock(jedis, true, key, OPERATE);
                return "分包变更推送供应链平台失败";
            }
        } catch (Exception e) {
            logger.error("分包变更id-{}推送供应链平台失败，", entity.getId(), e);
            msg = "操作失败，分包变更推送供应链平台失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }

    @Override
    public CommonResponse<SignatureChangeVO> pushStatus(SignatureChangeVO saveOrUpdateVO) {
        SignatureChangeEntity entity = super.selectById(saveOrUpdateVO.getId());
        entity.setReceiveStatus(InstructionStatusEnum.已驳回.getStatus());
        String s = pushBill(entity);
        if (StringUtils.isNotBlank(s)) {
            throw new BusinessException(s);
        }
        if (entity.getSetId()!=null){
            instructionSetService.changeInstructionSetStatus(entity.getSetId(), InstructionStatusEnum.未引用.getStatus());
        }
        super.saveOrUpdate(entity,false);
        SignatureChangeVO instructionSetVO = BeanMapper.map(entity, SignatureChangeVO.class);
        return CommonResponse.success("驳回成功！",instructionSetVO);
    }

    @Override
    public int pageCount(Map<String, Object> queryParam) {
        return mapper.pageCount(queryParam);
    }

    @Override
    public List<JSONObject> pageList(Map<String, Object> queryParam) {
        return mapper.pageList(queryParam);
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }



}
